/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.util;

import java.io.Serializable;
import java.util.ResourceBundle;

public final class FloatCollection
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final int DEFAULT_SIZE = 30;
    public float[] data;
    public int size;
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.util.resources.UtilResources");

    public FloatCollection(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException(String.valueOf(resource.getString("IllegalCapacityException")) + initialCapacity);
        }
        this.data = new float[initialCapacity];
    }

    public FloatCollection() {
        this(30);
    }

    public final void ensureCapacity(int minCapacity) {
        int oldCapacity = this.data.length;
        if (minCapacity > oldCapacity) {
            float[] oldData = this.data;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.data = new float[newCapacity];
            System.arraycopy(oldData, 0, this.data, 0, this.size);
        }
    }

    public final int size() {
        return this.size;
    }

    public final float get(int index) {
        return this.data[index];
    }

    public final float set(int index, float element) {
        float oldValue = this.data[index];
        this.data[index] = element;
        return oldValue;
    }

    public final boolean add(float newElement) {
        this.ensureCapacity(this.size + 1);
        this.data[this.size++] = newElement;
        return true;
    }

    public final void add(int index, float element) {
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.data, index, this.data, index + 1, this.size - index);
        this.data[index] = element;
        ++this.size;
    }

    public final void remove(int index) {
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.data, index + 1, this.data, index, numMoved);
        }
        if (this.size > 0) {
            this.data[--this.size] = 0.0f;
        }
    }
}

