/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.oobn.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import unbbayes.prs.oobn.IOOBNClass;
import unbbayes.prs.oobn.IOOBNNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOOBNNode
implements IOOBNNode {
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.prs.oobn.resources.Resources");
    private List<String> stateNames = null;
    private Set<IOOBNNode> innerNodes = new HashSet<IOOBNNode>();
    private IOOBNClass parentClass = null;
    private IOOBNNode upperInstance = null;
    private String name = null;
    private int type = 1;
    private IOOBNNode originalClassNode = null;
    private Set<IOOBNNode> parents = null;
    private Set<IOOBNNode> children = null;

    protected DefaultOOBNNode() {
        this.stateNames = new ArrayList<String>();
        this.parents = new HashSet<IOOBNNode>();
        this.children = new HashSet<IOOBNNode>();
    }

    public static DefaultOOBNNode newInstance() {
        return new DefaultOOBNNode();
    }

    @Override
    public IOOBNClass getParentClass() {
        return this.parentClass;
    }

    @Override
    public void setParentClass(IOOBNClass parentClass) {
        this.parentClass = parentClass;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void setType(int type) {
        if (type == 4 && this.getOOBNParents().size() > 0) {
            throw new IllegalArgumentException(resource.getString("InputNodeHasNoParents"));
        }
        this.type = type;
    }

    @Override
    public IOOBNNode getUpperInstanceNode() {
        return this.upperInstance;
    }

    @Override
    public void setUpperInstanceNode(IOOBNNode upperInstanceNode) {
        this.upperInstance = upperInstanceNode;
    }

    @Override
    public void addInnerNode(IOOBNNode inner) {
        this.innerNodes.add(inner);
    }

    @Override
    public Collection<IOOBNNode> getInnerNodes() {
        return this.innerNodes;
    }

    @Override
    public String getName() {
        if (this.getType() == 12 || this.getType() == 9) {
            return String.valueOf(this.getUpperInstanceNode().getName()) + "_" + this.getOriginalClassNode().getName();
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public List<String> getStateNames() {
        return this.stateNames;
    }

    @Override
    public void setStateNames(List<String> stateNames) {
        this.stateNames = stateNames;
    }

    @Override
    public IOOBNNode clone() throws CloneNotSupportedException {
        DefaultOOBNNode clone = DefaultOOBNNode.newInstance();
        clone.setName(this.getName());
        clone.setParentClass(this.getParentClass());
        clone.setStateNames(this.getStateNames());
        clone.setType(this.getType());
        clone.setUpperInstanceNode(this.getUpperInstanceNode());
        return clone;
    }

    @Override
    public IOOBNNode getOriginalClassNode() {
        return this.originalClassNode;
    }

    @Override
    public void setOriginalClassNode(IOOBNNode originalClassNode) {
        this.originalClassNode = originalClassNode;
    }

    @Override
    public void addParent(IOOBNNode node) {
        if (this.getType() == 4) {
            throw new IllegalArgumentException(resource.getString("InputNodeHasNoParents"));
        }
        if (this.getType() == 9) {
            throw new IllegalArgumentException(resource.getString("InstanceOutputNodeHasNoParents"));
        }
        if (this.getType() == 12) {
            if (this.getOOBNParents().size() > 0) {
                throw new IllegalArgumentException(resource.getString("InstanceInputNodeHasNoMultipleParents"));
            }
            if (!this.getStateNames().equals(node.getStateNames())) {
                throw new IllegalArgumentException(resource.getString("InstanceInputTypeCompatibilityFailed"));
            }
        }
        if (this.getType() == 8) {
            throw new IllegalArgumentException(resource.getString("PleaseAddParentToInstanceInputNodes"));
        }
        if (node.getType() == 12) {
            throw new IllegalArgumentException(resource.getString("PleaseAddChildToInstanceOutputNodes"));
        }
        this.parents.add(node);
        try {
            node.addChild(this);
        }
        catch (RuntimeException e) {
            this.parents.remove(node);
            throw e;
        }
    }

    @Override
    public Set<IOOBNNode> getOOBNParents() {
        return this.parents;
    }

    @Override
    public void addChild(IOOBNNode node) {
        if (node.getType() == 12 && this.getOOBNChildren() != null) {
            for (IOOBNNode child : this.getOOBNChildren()) {
                if (child.getType() != 12) continue;
                throw new IllegalArgumentException(resource.getString("NoNodeIsParentOf2InstanceInput"));
            }
        }
        if (this.getType() == 8) {
            throw new IllegalArgumentException(resource.getString("PleaseAddChildToInstanceOutputNodes"));
        }
        this.children.add(node);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof IOOBNNode && this.getName().equals(((IOOBNNode)obj).getName())) {
            return true;
        }
        return super.equals(obj);
    }

    @Override
    public Set<IOOBNNode> getOOBNChildren() {
        return this.children;
    }
}

