/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.oobn.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import unbbayes.prs.Node;
import unbbayes.prs.hybridbn.ContinuousNode;
import unbbayes.prs.oobn.IOOBNClass;
import unbbayes.prs.oobn.IOOBNNode;
import unbbayes.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOOBNContinuousNode
extends ContinuousNode
implements IOOBNNode {
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.prs.oobn.resources.Resources");
    private Set<IOOBNNode> innerNodes = null;
    private IOOBNClass parentClass = null;
    private IOOBNNode upperInstance = null;
    private String name = null;
    private int type = 1;
    private IOOBNNode originalClassNode = null;
    private Set<IOOBNNode> parents = null;
    private Set<IOOBNNode> children = null;

    protected DefaultOOBNContinuousNode() {
    }

    public static DefaultOOBNContinuousNode newInstance() {
        Debug.println(DefaultOOBNContinuousNode.class, "Continuous node for OOBN is not implemented yet.");
        return new DefaultOOBNContinuousNode();
    }

    @Override
    public IOOBNClass getParentClass() {
        return this.parentClass;
    }

    @Override
    public void setParentClass(IOOBNClass parentClass) {
        this.parentClass = parentClass;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void setType(int type) {
        if (type == 4 && this.getOOBNParents().size() > 0) {
            throw new IllegalArgumentException(resource.getString("InputNodeHasNoParents"));
        }
        this.type = type;
    }

    @Override
    public IOOBNNode getUpperInstanceNode() {
        return this.upperInstance;
    }

    @Override
    public void setUpperInstanceNode(IOOBNNode upperInstanceNode) {
        this.upperInstance = upperInstanceNode;
    }

    @Override
    public void addInnerNode(IOOBNNode inner) {
        this.innerNodes.add(inner);
    }

    @Override
    public Collection<IOOBNNode> getInnerNodes() {
        return this.innerNodes;
    }

    @Override
    public String getName() {
        if (this.getType() == 12 || this.getType() == 9) {
            try {
                return String.valueOf(this.getUpperInstanceNode().getName()) + "_" + this.getOriginalClassNode().getName();
            }
            catch (Exception e) {
                return String.valueOf(this.getUpperInstanceNode().getName()) + "_" + this.name;
            }
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public List<String> getStateNames() {
        return null;
    }

    @Override
    public void setStateNames(List<String> stateNames) {
        Debug.println(this.getClass(), "Attempt to set continuous node's state was detected.");
        for (String string : stateNames) {
            Debug.print(" State: " + string);
        }
        Debug.println("");
    }

    @Override
    public IOOBNNode getOriginalClassNode() {
        return this.originalClassNode;
    }

    @Override
    public void setOriginalClassNode(IOOBNNode originalClassNode) {
        this.originalClassNode = originalClassNode;
    }

    @Override
    public void addParent(IOOBNNode node) {
        if (this.getType() == 4) {
            throw new IllegalArgumentException(resource.getString("InputNodeHasNoParents"));
        }
        if (this.getType() == 9) {
            throw new IllegalArgumentException(resource.getString("InstanceOutputNodeHasNoParents"));
        }
        if (this.getType() == 12) {
            if (this.getOOBNParents().size() > 0) {
                throw new IllegalArgumentException(resource.getString("InstanceInputNodeHasNoMultipleParents"));
            }
            if (!this.getStateNames().equals(node.getStateNames())) {
                throw new IllegalArgumentException(resource.getString("InstanceInputTypeCompatibilityFailed"));
            }
        }
        if (this.getType() == 8) {
            throw new IllegalArgumentException(resource.getString("PleaseAddParentToInstanceInputNodes"));
        }
        if (node.getType() == 12) {
            throw new IllegalArgumentException(resource.getString("PleaseAddChildToInstanceOutputNodes"));
        }
        this.parents.add(node);
        try {
            node.addChild(this);
        }
        catch (RuntimeException e) {
            this.parents.remove(node);
            throw e;
        }
    }

    @Override
    public Set<IOOBNNode> getOOBNParents() {
        return this.parents;
    }

    @Override
    public void addChild(IOOBNNode node) {
        if (node.getType() == 12 && this.getOOBNChildren() != null) {
            for (IOOBNNode child : this.getOOBNChildren()) {
                if (child.getType() != 12) continue;
                throw new IllegalArgumentException(resource.getString("NoNodeIsParentOf2InstanceInput"));
            }
        }
        if (this.getType() == 8) {
            throw new IllegalArgumentException(resource.getString("PleaseAddChildToInstanceOutputNodes"));
        }
        this.children.add(node);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof IOOBNNode && this.getName().equals(((IOOBNNode)obj).getName())) {
            return true;
        }
        return super.equals(obj);
    }

    @Override
    public Set<IOOBNNode> getOOBNChildren() {
        return this.children;
    }

    @Override
    public IOOBNNode clone() {
        DefaultOOBNContinuousNode clone = DefaultOOBNContinuousNode.newInstance();
        clone.setName(this.getName());
        clone.setOriginalClassNode(this.getOriginalClassNode());
        clone.setParentClass(this.getParentClass());
        clone.setStateNames(new ArrayList<String>());
        clone.setType(this.getType());
        clone.setUpperInstanceNode(this.getUpperInstanceNode());
        clone.setAdjacents(new ArrayList<Node>(this.getAdjacents()));
        clone.setAssociatedClique(this.getAssociatedClique());
        clone.setChildren(new ArrayList<Node>(this.getChildren()));
        clone.setDescription(this.getDescription());
        clone.setExplanationDescription(this.getExplanationDescription());
        clone.setInformationType(this.getInformationType());
        clone.setLabel(this.getLabel());
        clone.setMean((double[])this.getMean().clone());
        clone.setParents(this.getParents());
        clone.setPhrasesMap(this.getPhrasesMap());
        clone.setPosition(this.getPosition().x, this.getPosition().y);
        clone.setSelected(this.isSelected());
        clone.setSizeIsVariable(this.sizeIsVariable);
        clone.setStandardDeviation((double[])this.getStandardDeviation().clone());
        clone.setStates(new ArrayList<String>(this.states));
        return clone;
    }
}

