/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.mebn.ssbn;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TreeMap;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.prs.exception.InvalidParentException;
import unbbayes.prs.mebn.InputNode;
import unbbayes.prs.mebn.OrdinaryVariable;
import unbbayes.prs.mebn.ResidentNode;
import unbbayes.prs.mebn.entity.StateLink;
import unbbayes.prs.mebn.exception.MEBNException;
import unbbayes.prs.mebn.ssbn.AbstractSSBNGenerator;
import unbbayes.prs.mebn.ssbn.ContextNodeAvaliator;
import unbbayes.prs.mebn.ssbn.MFragInstance;
import unbbayes.prs.mebn.ssbn.OVInstance;
import unbbayes.prs.mebn.ssbn.Query;
import unbbayes.prs.mebn.ssbn.SSBNNode;
import unbbayes.prs.mebn.ssbn.SSBNNodeJacket;
import unbbayes.prs.mebn.ssbn.SSBNNodeList;
import unbbayes.prs.mebn.ssbn.SSBNWarning;
import unbbayes.prs.mebn.ssbn.SituationSpecificBayesianNetwork;
import unbbayes.prs.mebn.ssbn.exception.ImplementationError;
import unbbayes.prs.mebn.ssbn.exception.ImplementationRestrictionException;
import unbbayes.prs.mebn.ssbn.exception.OVInstanceFaultException;
import unbbayes.prs.mebn.ssbn.exception.SSBNNodeGeneralException;
import unbbayes.prs.mebn.ssbn.util.PositionAdjustmentUtils;
import unbbayes.prs.mebn.ssbn.util.SSBNDebugInformationUtil;
import unbbayes.util.Debug;

public class ExplosiveSSBNGenerator
extends AbstractSSBNGenerator {
    private ResourceBundle resource = ResourceBundle.getBundle("unbbayes.prs.mebn.ssbn.resources.Resources");
    private long recursiveCallLimit = 100L;
    private long recursiveCallCount = 0L;
    public static long stepCount = 0L;
    public static String queryName = "";
    private List<SSBNNode> findingList;

    public SituationSpecificBayesianNetwork generateSSBN(Query query) throws SSBNNodeGeneralException, ImplementationRestrictionException, MEBNException, InvalidParentException {
        Debug.setDebug(true);
        this.ssbnNodeList = new SSBNNodeList();
        this.ssbnNodesMap = new TreeMap();
        this.warningList = new ArrayList();
        this.findingList = new ArrayList<SSBNNode>();
        SSBNNode queryNode = query.getQueryNode();
        this.setKnowledgeBase(query.getKb());
        this.setContextNodeAvaliator(new ContextNodeAvaliator(this.getKnowledgeBase()));
        stepCount = 0L;
        queryName = queryNode.getUniqueName();
        logManager.clear();
        this.recursiveCallCount = 0L;
        ArrayList<Query> queryList = new ArrayList<Query>();
        queryList.add(query);
        queryNode.setPermanent(true);
        this.ssbnNodesMap.put(queryNode.getUniqueName(), queryNode);
        try {
            this.generateRecursive(queryNode, this.ssbnNodeList, queryNode.getProbabilisticNetwork(), true);
            this.generateCPTForAllSSBNNodes(queryNode);
            this.removeNotPermanentNodes(this.ssbnNodeList);
            logManager.appendln("\n");
            logManager.appendln("SSBN generation finished");
            ExplosiveSSBNGenerator.printAndSaveCurrentNetwork(queryNode);
        }
        finally {
            try {
                logManager.writeToDisk("LogSSBN.log", true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        SituationSpecificBayesianNetwork ssbn = new SituationSpecificBayesianNetwork(queryNode.getProbabilisticNetwork(), this.findingList, queryList);
        ssbn.setWarningList(this.warningList);
        return ssbn;
    }

    private void generateRecursive(SSBNNode currentNode, SSBNNodeList seen, ProbabilisticNetwork net, boolean generatedByDownProcessOfOriginNode) throws SSBNNodeGeneralException, ImplementationRestrictionException, MEBNException, InvalidParentException {
        if (currentNode.getEvaluationState() == SSBNNode.EvaluationSSBNNodeState.EVALUATED_COMPLETE) {
            return;
        }
        if (currentNode.getEvaluationState() == SSBNNode.EvaluationSSBNNodeState.NOT_EVALUATED && currentNode.getEvaluationState() != SSBNNode.EvaluationSSBNNodeState.EVALUATING_BELOW) {
            currentNode.setEvaluationState(SSBNNode.EvaluationSSBNNodeState.EVALUATING_BELOW);
            logManager.appendln("\nGENERATE RECURSIVE DOWN: " + currentNode.getName());
            this.generateRecursiveDown(currentNode, seen, net, generatedByDownProcessOfOriginNode);
            currentNode.setEvaluationState(SSBNNode.EvaluationSSBNNodeState.EVALUATED_BELOW);
        }
        if (currentNode.isPermanent() && currentNode.getEvaluationState() != SSBNNode.EvaluationSSBNNodeState.EVALUATING_UP && !currentNode.isUsingDefaultCPT()) {
            currentNode.setEvaluationState(SSBNNode.EvaluationSSBNNodeState.EVALUATING_UP);
            logManager.appendln("\n");
            logManager.appendln("Node " + currentNode + " created");
            ExplosiveSSBNGenerator.printAndSaveCurrentNetwork(currentNode);
            logManager.appendln("\nGENERATE RECURSIVE UP: " + currentNode.getName());
            this.generateRecursiveUp(currentNode, seen, net, null, generatedByDownProcessOfOriginNode);
            currentNode.setEvaluationState(SSBNNode.EvaluationSSBNNodeState.EVALUATED_COMPLETE);
        }
    }

    private boolean generateRecursiveDown(SSBNNode currentNode, SSBNNodeList seen, ProbabilisticNetwork net, boolean generatedByDownProcessOfOriginNode) throws SSBNNodeGeneralException, ImplementationRestrictionException, MEBNException, InvalidParentException {
        logManager.appendln("\n\n[D] Recursive Call Count = " + this.recursiveCallCount);
        logManager.appendln("[D]" + currentNode + ": -------------EVALUATING NODE BELOW: " + currentNode.getName() + "--------------\n");
        ResidentNode residentNode = currentNode.getResident();
        if (this.recursiveCallCount > this.recursiveCallLimit) {
            throw new SSBNNodeGeneralException(this.resource.getString("RecursiveLimit"));
        }
        ++this.recursiveCallCount;
        logManager.appendln("[D]" + currentNode + ":A - Search findings");
        StateLink exactValue = this.getKnowledgeBase().searchFinding(currentNode.getResident(), currentNode.getArguments());
        if (exactValue != null) {
            currentNode.setNodeAsFinding(exactValue.getState());
            if (!seen.contains(currentNode)) {
                seen.add(currentNode);
            }
            logManager.appendln("[D]" + currentNode + ":A - Exact value of " + currentNode.getName() + "=" + exactValue.getState());
            currentNode.setPermanent(true);
            this.findingList.add(currentNode);
            return true;
        }
        logManager.appendln("[D]" + currentNode + ":A - Search finding fail");
        if (!seen.contains(currentNode)) {
            seen.add(currentNode);
        }
        logManager.appendln("[D]" + currentNode + ":B - Analyse context nodes");
        ArrayList<OVInstance> ovInstancesList = new ArrayList<OVInstance>();
        ovInstancesList.addAll(currentNode.getArguments());
        boolean relatedContextNodesEvaluation = false;
        try {
            relatedContextNodesEvaluation = this.getContextNodeAvaliator().evaluateRelatedContextNodes(currentNode.getResident(), ovInstancesList, null);
        }
        catch (OVInstanceFaultException e) {
            logManager.appendln("[D]" + currentNode + ": OVInstance fault. End down method with fail\n\n");
            throw new ImplementationError("OVInstance fault in the method generateRecursiveDown");
        }
        if (!relatedContextNodesEvaluation) {
            logManager.appendln("[D]" + currentNode + ":Context Node fail for " + currentNode.getResident().getMFrag());
            currentNode.setUsingDefaultCPT(true);
            return false;
        }
        logManager.appendln("[D]" + currentNode + ":Context Node evaluation OK for " + currentNode.getResident().getMFrag());
        logManager.appendln("[D]" + currentNode + ":B - Resident Nodes below");
        for (ResidentNode childResidentNode : residentNode.getResidentNodeChildList()) {
            logManager.appendln("[D]" + currentNode + ": Resident Node Child analisy -> " + childResidentNode);
            List<OrdinaryVariable> ovProblematicList = this.getOVForWhichNotExistOVInstance(childResidentNode.getOrdinaryVariableList(), ovInstancesList);
            if (!ovProblematicList.isEmpty()) {
                logManager.appendln("[D]" + currentNode + ": OVariable list problem");
                try {
                    try {
                        List<SSBNNode> createdNodes = this.createSSBNNodesOfEntitiesSearchForResidentNode(childResidentNode.getMFrag(), currentNode, childResidentNode, ovProblematicList, ovInstancesList, false);
                        for (SSBNNode ssbnNode : createdNodes) {
                            if (currentNode.getParents().contains(ssbnNode)) continue;
                            this.generateRecursive(ssbnNode, seen, net, true);
                            if (!currentNode.getParents().contains(ssbnNode)) {
                                currentNode.addParent(ssbnNode, true);
                            }
                            if (!ssbnNode.isPermanent()) continue;
                            currentNode.setPermanent(true);
                        }
                    }
                    catch (SSBNNodeGeneralException e) {
                        logManager.appendln("[D]" + currentNode + ": Error: entity for ordinary variable don't found: " + ovProblematicList + " !\n");
                        this.warningList.add(new SSBNWarning(1, e, currentNode, ovProblematicList));
                    }
                }
                catch (Throwable throwable) {}
                continue;
            }
            logManager.appendln("[D]" + currentNode + ": OVariable list OK");
            SSBNNode ssbnNode = null;
            List<OVInstance> arguments = this.filterArgumentsForNode(ovInstancesList, childResidentNode);
            SSBNNode testSSBNNodeDuplicated = (SSBNNode)this.ssbnNodesMap.get(SSBNNode.getUniqueNameFor(childResidentNode, arguments));
            if (testSSBNNodeDuplicated == null) {
                ssbnNode = SSBNNode.getInstance(net, childResidentNode, new ProbabilisticNode());
                ssbnNode.setPermanent(false);
                for (OVInstance ovInstance : arguments) {
                    ssbnNode.addArgument(ovInstance);
                }
                seen.add(ssbnNode);
                this.ssbnNodesMap.put(ssbnNode.getUniqueName(), ssbnNode);
                this.generateRecursive(ssbnNode, seen, net, true);
            } else {
                ssbnNode = testSSBNNodeDuplicated;
            }
            if (!ssbnNode.isPermanent()) continue;
            currentNode.setPermanent(true);
            if (ssbnNode.getParents().contains(currentNode)) continue;
            ssbnNode.addParent(currentNode, true);
        }
        logManager.appendln("[D]" + currentNode + ":C - Input Nodes below");
        for (InputNode inputNode : residentNode.getInputInstanceFromList()) {
            List<OVInstance> ovInstancesInputList;
            SSBNNodeJacket curNodeInputSNJacket;
            block36: {
                logManager.appendln("[D]" + currentNode + ": Input Node Child analisy -> " + inputNode);
                curNodeInputSNJacket = new SSBNNodeJacket(currentNode);
                for (OVInstance ovInstance : currentNode.getArgumentsAsList()) {
                    curNodeInputSNJacket.addArgument(residentNode, inputNode, ovInstance);
                }
                ovInstancesInputList = curNodeInputSNJacket.getInputMFragOvInstances();
                boolean contextNodesOK = false;
                try {
                    contextNodesOK = this.getContextNodeAvaliator().evaluateRelatedContextNodes(inputNode, ovInstancesInputList, null);
                    if (!contextNodesOK) {
                        inputNode.getMFrag().setAsUsingDefaultCPT(true);
                    }
                    break block36;
                }
                catch (OVInstanceFaultException e1) {
                    logManager.appendln("[D]" + currentNode + ": Error (Input node instance from )- " + "Evaluation of context nodes don't found all entities " + "that match the ordinary variables");
                    this.warningList.add(new SSBNWarning(2, e1, currentNode, inputNode));
                }
                continue;
            }
            for (ResidentNode residentChild : inputNode.getResidentNodeChildList()) {
                logManager.appendln("[D]" + currentNode + ": Child of the input -> " + residentChild);
                logManager.appendln("[D]" + currentNode + ": do nothing...");
                if (residentChild.equals(currentNode.getResident())) {
                    ArrayList<OVInstance> tempListArgsFather = new ArrayList<OVInstance>();
                    SSBNNode procNode = this.getProcNode(currentNode, seen, net, residentChild, tempListArgsFather, inputNode);
                    if (procNode == null) continue;
                    currentNode.setRecursiveOVInstanceList(tempListArgsFather);
                    this.generateRecursive(procNode, seen, net, true);
                    if (!procNode.getParents().contains(currentNode)) {
                        procNode.addParent(currentNode, false);
                    }
                    currentNode.setRecursiveOVInstanceList(curNodeInputSNJacket.getInputMFragOvInstances());
                    if (!procNode.isPermanent()) continue;
                    currentNode.setPermanent(true);
                    continue;
                }
                currentNode.addArgumentsForMFrag(residentChild.getMFrag(), curNodeInputSNJacket.getInputMFragOvInstances());
                List<OrdinaryVariable> ovProblematicList = this.getOVForWhichNotExistOVInstance(residentChild.getOrdinaryVariableList(), ovInstancesInputList);
                if (!ovProblematicList.isEmpty()) {
                    logManager.appendln("[D]" + currentNode + ": OVariable list problem");
                    try {
                        List<SSBNNode> createdNodes = this.createSSBNNodesOfEntitiesSearchForResidentNode(residentChild.getMFrag(), currentNode, residentChild, ovProblematicList, ovInstancesInputList, false);
                        for (SSBNNode ssbnNode : createdNodes) {
                            if (ssbnNode.getParents().contains(currentNode)) continue;
                            this.generateRecursive(ssbnNode, seen, net, true);
                            if (!ssbnNode.getParents().contains(currentNode)) {
                                ssbnNode.addParent(currentNode, false);
                            }
                            if (!ssbnNode.isPermanent()) continue;
                            currentNode.setPermanent(true);
                        }
                    }
                    catch (Exception e) {
                        logManager.appendln("[D]" + currentNode + ": Error - Not all ordinary variables of the resident node filled");
                        this.warningList.add(new SSBNWarning(3, e, currentNode, residentChild));
                    }
                    continue;
                }
                logManager.appendln("[D]" + currentNode + ": OVariable list OK");
                SSBNNode ssbnNode = null;
                List<OVInstance> arguments = this.filterArgumentsForNode(ovInstancesList, residentChild);
                SSBNNode testSSBNNodeDuplicated = (SSBNNode)this.ssbnNodesMap.get(SSBNNode.getUniqueNameFor(residentChild, arguments));
                if (testSSBNNodeDuplicated == null) {
                    ssbnNode = SSBNNode.getInstance(net, residentChild, new ProbabilisticNode());
                    ssbnNode.setPermanent(false);
                    for (OVInstance ovInstance : arguments) {
                        ssbnNode.addArgument(ovInstance);
                    }
                    seen.add(ssbnNode);
                    this.ssbnNodesMap.put(ssbnNode.getUniqueName(), ssbnNode);
                    this.generateRecursive(ssbnNode, seen, net, true);
                } else {
                    ssbnNode = testSSBNNodeDuplicated;
                }
                if (ssbnNode.isPermanent()) {
                    currentNode.setPermanent(true);
                    if (!ssbnNode.getParents().contains(currentNode)) {
                        ssbnNode.addParent(currentNode, true);
                    }
                }
                logManager.appendln("exit");
            }
        }
        logManager.appendln("[D]" + currentNode + ":D - The end");
        return currentNode.isPermanent();
    }

    private SSBNNode generateRecursiveUp(SSBNNode currentNode, SSBNNodeList seen, ProbabilisticNetwork net, MFragInstance mFragInstance, boolean generatedByDownProcessOfOriginNode) throws SSBNNodeGeneralException, ImplementationRestrictionException, MEBNException, InvalidParentException {
        SSBNNode ssbnNode;
        logManager.appendln("\n\n[U] Recursive call count = " + this.recursiveCallCount);
        logManager.appendln("[U]" + currentNode + ":-------------EVALUATING NODE: " + currentNode.getName() + "--------------\n");
        currentNode.setPermanent(true);
        if (this.recursiveCallCount > this.recursiveCallLimit) {
            throw new SSBNNodeGeneralException(this.resource.getString("RecursiveLimit"));
        }
        ++this.recursiveCallCount;
        ArrayList<OVInstance> ovInstancesList = new ArrayList<OVInstance>();
        ovInstancesList.addAll(currentNode.getArguments());
        logManager.appendln("[U]" + currentNode + "A:- Analyse resident nodes fathers");
        for (ResidentNode residentNode : currentNode.getResident().getResidentNodeFatherList()) {
            List<OrdinaryVariable> ovProblematicList = this.getOVForWhichNotExistOVInstance(residentNode.getOrdinaryVariableList(), currentNode.getArguments());
            if (!ovProblematicList.isEmpty()) {
                List<SSBNNode> createdNodes = this.createSSBNNodesOfEntitiesSearchForResidentNode(residentNode.getMFrag(), currentNode, residentNode, ovProblematicList, ovInstancesList, true);
                for (SSBNNode ssbnnode : createdNodes) {
                    if (currentNode.getParents().contains(ssbnnode)) continue;
                    if (!currentNode.isFinding()) {
                        this.generateRecursive(ssbnnode, seen, net, false);
                        ssbnnode.setPermanent(true);
                    } else if (generatedByDownProcessOfOriginNode) {
                        ssbnnode.setPermanent(true);
                        this.generateRecursive(ssbnnode, seen, net, false);
                    }
                    if (currentNode.getParents().contains(ssbnnode)) continue;
                    currentNode.addParent(ssbnnode, true);
                }
                continue;
            }
            List<OVInstance> arguments = this.filterArgumentsForNode(currentNode.getArguments(), residentNode);
            ssbnNode = (SSBNNode)this.ssbnNodesMap.get(SSBNNode.getUniqueNameFor(residentNode, arguments));
            if (ssbnNode == null) {
                ssbnNode = SSBNNode.getInstance(net, residentNode, new ProbabilisticNode());
                for (OVInstance ovInstance : arguments) {
                    ssbnNode.addArgument(ovInstance);
                }
                this.ssbnNodeList.add(ssbnNode);
                this.ssbnNodesMap.put(ssbnNode.getUniqueName(), ssbnNode);
                if (!currentNode.isFinding()) {
                    this.generateRecursive(ssbnNode, seen, net, false);
                    ssbnNode.setPermanent(true);
                } else if (generatedByDownProcessOfOriginNode) {
                    ssbnNode.setPermanent(true);
                    this.generateRecursive(ssbnNode, seen, net, false);
                }
            } else {
                logManager.appendln("Node already exists:" + ssbnNode);
                if (!currentNode.isFinding()) {
                    this.generateRecursive(ssbnNode, seen, net, false);
                    ssbnNode.setPermanent(true);
                } else if (generatedByDownProcessOfOriginNode) {
                    ssbnNode.setPermanent(true);
                    this.generateRecursive(ssbnNode, seen, net, false);
                }
            }
            if (currentNode.getParents().contains(ssbnNode)) continue;
            currentNode.addParent(ssbnNode, true);
        }
        logManager.appendln(currentNode + " returned from the resident node parents' recursion");
        logManager.appendln(currentNode + "B:- Analyze input nodes fathers");
        for (InputNode inputNode : currentNode.getResident().getInputNodeFatherList()) {
            SSBNNodeJacket ssbnNodeJacket2;
            ResidentNode residentNodeTargetOfInput = inputNode.getResidentNodePointer().getResidentNode();
            logManager.appendln(String.valueOf(currentNode.getName()) + "Evaluate input " + residentNodeTargetOfInput.getName());
            if (currentNode.getResident() == residentNodeTargetOfInput) {
                SSBNNodeJacket previousNode = this.getPreviousNode(currentNode, seen, net, residentNodeTargetOfInput, inputNode);
                if (previousNode == null) continue;
                previousNode.setResidentMFragArguments();
                if (!currentNode.isFinding()) {
                    previousNode.getSsbnNode().setPermanent(true);
                    this.generateRecursive(previousNode.getSsbnNode(), seen, net, false);
                }
                if (currentNode.getParents().contains(previousNode)) continue;
                currentNode.addParent(previousNode.getSsbnNode(), true);
                continue;
            }
            List<OrdinaryVariable> ovProblematicList = this.getOVForWhichNotExistOVInstance(inputNode.getOrdinaryVariableList(), currentNode.getArguments());
            if (!ovProblematicList.isEmpty()) {
                List<SSBNNodeJacket> parentList = this.createSSBNNodesOfEntitiesSearchForInputNode(currentNode, inputNode, ovProblematicList, currentNode.getArgumentsAsList());
                for (SSBNNodeJacket ssbnNodeJacket2 : parentList) {
                    SSBNNode ssbnNode2 = ssbnNodeJacket2.getSsbnNode();
                    ssbnNode2.addArgumentsForMFrag(currentNode.getResident().getMFrag(), ssbnNodeJacket2.getInputMFragOvInstances());
                    if (!currentNode.isFinding()) {
                        ssbnNodeJacket2.setResidentMFragArguments();
                        ssbnNodeJacket2.getSsbnNode().setPermanent(true);
                        this.generateRecursive(ssbnNode2, seen, net, false);
                    }
                    logManager.appendln("Node Created: " + ssbnNode2.toString());
                    ssbnNodeJacket2.setResidentMFragArguments();
                    if (currentNode.getParents().contains(ssbnNode2)) continue;
                    currentNode.addParent(ssbnNode2, true);
                }
                continue;
            }
            ssbnNode = SSBNNode.getInstance(net, residentNodeTargetOfInput, new ProbabilisticNode());
            ssbnNodeJacket2 = new SSBNNodeJacket(ssbnNode);
            for (OVInstance ovInstance : currentNode.getArguments()) {
                ssbnNodeJacket2.addArgument(inputNode, ovInstance);
            }
            ssbnNodeJacket2.setResidentMFragArguments();
            SSBNNode duplicatedNodeTest = (SSBNNode)this.ssbnNodesMap.get(ssbnNode.getUniqueName());
            if (duplicatedNodeTest != null) {
                ssbnNode = duplicatedNodeTest;
                ssbnNodeJacket2.getSsbnNode().delete();
                ssbnNodeJacket2.setSsbnNode(duplicatedNodeTest);
            }
            seen.add(ssbnNodeJacket2.getSsbnNode());
            this.ssbnNodesMap.put(ssbnNode.getUniqueName(), ssbnNode);
            boolean contextNodesOK = false;
            try {
                contextNodesOK = this.evaluateRelatedContextNodes(inputNode, currentNode.getArgumentsAsList());
            }
            catch (OVInstanceFaultException e) {
                e.printStackTrace();
            }
            if (!currentNode.isFinding()) {
                ssbnNodeJacket2.getSsbnNode().setPermanent(true);
            }
            if (contextNodesOK) {
                if (!currentNode.isFinding()) {
                    this.generateRecursive(ssbnNode, seen, net, false);
                }
            } else {
                logManager.append("Context Nodes False for " + ssbnNode + " (input node)");
                ssbnNode.setUsingDefaultCPT(true);
            }
            ssbnNodeJacket2.setInputMFragArguments();
            if (currentNode.getParents().contains(ssbnNode)) continue;
            currentNode.addParent(ssbnNode, true);
        }
        logManager.appendln(currentNode + "End");
        return currentNode;
    }

    public long getRecursiveCallCount() {
        return this.recursiveCallCount;
    }

    public void setRecursiveCallCount(long recursiveCallCount) {
        this.recursiveCallCount = recursiveCallCount;
    }

    public long getRecursiveCallLimit() {
        return this.recursiveCallLimit;
    }

    public void setRecursiveCallLimit(long recursiveCallLimit) {
        this.recursiveCallLimit = recursiveCallLimit;
    }

    public static void printAndSaveCurrentNetwork(SSBNNode queryNode) {
        PositionAdjustmentUtils.adjustPositionProbabilisticNetwork(queryNode.getProbabilisticNetwork());
        SSBNDebugInformationUtil.printNetworkInformation(logManager, queryNode, ++stepCount, queryName);
    }
}

