/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.mebn.ssbn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import unbbayes.prs.mebn.ContextNode;
import unbbayes.prs.mebn.InputNode;
import unbbayes.prs.mebn.MFrag;
import unbbayes.prs.mebn.MultiEntityNode;
import unbbayes.prs.mebn.OrdinaryVariable;
import unbbayes.prs.mebn.ResidentNode;
import unbbayes.prs.mebn.kb.KnowledgeBase;
import unbbayes.prs.mebn.ssbn.LiteralEntityInstance;
import unbbayes.prs.mebn.ssbn.MFragInstance;
import unbbayes.prs.mebn.ssbn.OVInstance;
import unbbayes.prs.mebn.ssbn.exception.ImplementationRestrictionException;
import unbbayes.prs.mebn.ssbn.exception.InvalidContextNodeFormulaException;
import unbbayes.prs.mebn.ssbn.exception.OVInstanceFaultException;
import unbbayes.prs.mebn.ssbn.exception.SSBNNodeGeneralException;
import unbbayes.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextNodeAvaliator {
    private KnowledgeBase kb;

    public ContextNodeAvaliator(KnowledgeBase kb) {
        this.kb = kb;
    }

    public boolean evaluateContextNode(ContextNode node, List<OVInstance> ovInstances) throws OVInstanceFaultException {
        boolean isDebug = Debug.isDebugMode();
        Debug.setDebug(false);
        List<OrdinaryVariable> ovFaultList = node.getOVFaultForOVInstanceSet(ovInstances);
        Debug.setDebug(isDebug);
        if (!ovFaultList.isEmpty()) {
            throw new OVInstanceFaultException(ovFaultList);
        }
        boolean result = this.kb.evaluateContextNodeFormula(node, ovInstances);
        Debug.setDebug(isDebug);
        return result;
    }

    public List<String> evalutateSearchContextNode(ContextNode context, List<OVInstance> ovInstances) throws InvalidContextNodeFormulaException, OVInstanceFaultException {
        List<String> entitiesResult = this.kb.evaluateSearchContextNodeFormula(context, ovInstances);
        return entitiesResult;
    }

    protected boolean evaluateRelatedContextNodes(ResidentNode residentNode, List<OVInstance> ovInstances, MFragInstance mFragInstance) throws OVInstanceFaultException {
        return this.evaluateRelatedContextNodes(residentNode, ovInstances, mFragInstance, residentNode.getOrdinaryVariableList());
    }

    protected boolean evaluateRelatedContextNodes(InputNode inputNode, List<OVInstance> ovInstances, MFragInstance mFragInstance) throws OVInstanceFaultException {
        return this.evaluateRelatedContextNodes(inputNode, ovInstances, mFragInstance, inputNode.getOrdinaryVariableList());
    }

    private boolean evaluateRelatedContextNodes(MultiEntityNode multiEntityNode, List<OVInstance> ovInstances, MFragInstance mFragInstance, List<OrdinaryVariable> ovList) throws OVInstanceFaultException {
        if (multiEntityNode.getMFrag().isUsingDefaultCPT()) {
            return false;
        }
        Collection<ContextNode> contextNodeList = multiEntityNode.getMFrag().getContextByOVCombination(ovList);
        for (ContextNode context : contextNodeList) {
            if (this.evaluateContextNode(context, ovInstances)) continue;
            return false;
        }
        return true;
    }

    public List<OVInstance> evaluateSearchContextNode(MFrag mFrag, List<OrdinaryVariable> ovFaultList, List<OVInstance> ovInstances) throws ImplementationRestrictionException, SSBNNodeGeneralException {
        boolean debug = false;
        HashMap mapOVInstanceMap = new HashMap();
        for (OVInstance ovInstance : ovInstances) {
            ArrayList<OVInstance> list = new ArrayList<OVInstance>();
            list.add(ovInstance);
            mapOVInstanceMap.put(ovInstance.getOv(), list);
        }
        Collection<ContextNode> cnList = mFrag.getContextNodeByOrdinaryVariableRelated(ovFaultList);
        boolean changed = false;
        boolean i = false;
        do {
            ArrayList<ContextNode> solvedNodes = new ArrayList<ContextNode>();
            changed = false;
            for (ContextNode context : cnList) {
                System.out.println("N\u00f3 de contexto avaliado: " + context);
                ArrayList<OrdinaryVariable> ovFaultTempList = new ArrayList<OrdinaryVariable>();
                ArrayList<OVInstance> ovInstanceList = new ArrayList<OVInstance>();
                ovInstanceList.addAll(ovInstances);
                boolean doIntersection = false;
                for (OrdinaryVariable ov : context.getVariableList()) {
                    System.out.println("Ordinary variable: " + ov);
                    List instanceListForOV = (List)mapOVInstanceMap.get(ov);
                    if (instanceListForOV != null) {
                        if (instanceListForOV.size() == 1) {
                            System.out.println("   OVInstance: " + instanceListForOV.get(0));
                            if (ovInstanceList.contains(instanceListForOV.get(0))) continue;
                            ovInstanceList.add((OVInstance)instanceListForOV.get(0));
                            continue;
                        }
                        System.out.println("  Do intersection");
                        doIntersection = true;
                        ovFaultTempList.add(ov);
                        continue;
                    }
                    System.out.println(" OV Fault!!! ");
                    ovFaultTempList.add(ov);
                }
                if (ovFaultTempList.size() > 1) {
                    System.out.println("OV Fault List maior que 1");
                    continue;
                }
                try {
                    System.out.println("Tentando avaliar n\u00f3 de contexto: ");
                    List<String> result = this.evalutateSearchContextNode(context, ovInstanceList);
                    System.out.println("Result: " + result);
                    if (result != null && result.size() > 0) {
                        System.out.println("In");
                        List<OVInstance> ovInstanceListResult = new ArrayList<OVInstance>();
                        List<OrdinaryVariable> contextNodeOvFaultList = context.getOVFaultForOVInstanceSet(ovInstanceList);
                        OrdinaryVariable ovFault = contextNodeOvFaultList.get(0);
                        for (String ovInstanceName : result) {
                            ovInstanceListResult.add(OVInstance.getInstance(ovFault, LiteralEntityInstance.getInstance(ovInstanceName, ovFault.getValueType())));
                        }
                        if (doIntersection) {
                            OrdinaryVariable ov = (OrdinaryVariable)ovFaultTempList.get(0);
                            List instanceListForOV = (List)mapOVInstanceMap.get(ov);
                            ovInstanceListResult = this.intersection(instanceListForOV, ovInstanceListResult);
                        }
                        mapOVInstanceMap.put(ovFault, ovInstanceListResult);
                        System.out.println("Out [" + ovFault + " " + ovInstanceListResult + "]");
                    }
                    solvedNodes.add(context);
                    System.out.println("Houve alteracao");
                    changed = true;
                    System.out.println("\nMapOVInstance");
                    for (OrdinaryVariable ov : mapOVInstanceMap.keySet()) {
                        System.out.println("> OV=" + ov + "[");
                        List ovInstanceListResult = (List)mapOVInstanceMap.get(ov);
                        for (OVInstance ovI : ovInstanceListResult) {
                            System.out.println("   " + ovI);
                        }
                        System.out.println("]");
                    }
                    System.out.println("\n");
                }
                catch (InvalidContextNodeFormulaException e) {
                    e.printStackTrace();
                    break;
                }
                catch (OVInstanceFaultException e) {
                    e.printStackTrace();
                    break;
                }
            }
            for (ContextNode context : solvedNodes) {
                cnList.remove(context);
                System.out.println("Solved node: " + context);
            }
        } while (changed);
        System.out.println("Resultado: ");
        ArrayList<OVInstance> listResult = new ArrayList<OVInstance>();
        for (OrdinaryVariable ov : ovFaultList) {
            System.out.println("Ordinary Variable: " + ov);
            List listOVInstance = (List)mapOVInstanceMap.get(ov);
            if (listOVInstance != null && listOVInstance.size() == 1) {
                System.out.println("   OVInstance = " + listOVInstance.get(0));
                listResult.add((OVInstance)listOVInstance.get(0));
                continue;
            }
            System.out.println("   Not ov instance for the ordinary variable");
            return null;
        }
        return listResult;
    }

    public List<String> getEntityByType(String type) {
        return this.kb.getEntityByType(type);
    }

    private List<OVInstance> intersection(List<OVInstance> list1, List<OVInstance> list2) {
        ArrayList<OVInstance> listIntersection = new ArrayList<OVInstance>();
        for (OVInstance ovIns : list1) {
            if (!list2.contains(ovIns)) continue;
            listIntersection.add(ovIns);
        }
        return listIntersection;
    }
}

