/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.mebn.entity;

import java.util.ArrayList;
import java.util.List;
import unbbayes.prs.mebn.entity.TypeContainer;
import unbbayes.prs.mebn.entity.exception.TypeAlreadyExistsException;
import unbbayes.prs.mebn.entity.exception.TypeIsInUseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Type
implements Comparable<Type> {
    private String name;
    private List<Object> isTypeOfList;
    private TypeContainer container;
    private boolean hasOrder = false;

    protected Type(String newType, TypeContainer container) throws TypeAlreadyExistsException {
        this.name = newType;
        this.isTypeOfList = new ArrayList<Object>();
        this.container = container;
        if (container.getType(newType) != null) {
            throw new TypeAlreadyExistsException();
        }
        this.hasOrder = false;
    }

    protected Type(String newType) {
        this.name = newType;
        this.isTypeOfList = new ArrayList<Object>();
        this.hasOrder = false;
    }

    public String getName() {
        return this.name;
    }

    public void addUserObject(Object user) {
        this.isTypeOfList.add(user);
    }

    public void removeUserObject(Object user) {
        this.isTypeOfList.remove(user);
    }

    public boolean typeIsUsed() {
        return !this.isTypeOfList.isEmpty();
    }

    public void delete() throws TypeIsInUseException {
        if (!this.isTypeOfList.isEmpty()) {
            throw new TypeIsInUseException();
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof Type) {
            return ((Type)obj).getName() == this.name;
        }
        return false;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(Type anotherType) {
        return this.name.compareTo(anotherType.getName());
    }

    public void renameType(String name) throws TypeAlreadyExistsException {
        if (this.container.getType(name) != null) {
            throw new TypeAlreadyExistsException();
        }
        this.name = name;
    }

    public List<Object> getIsTypeOfList() {
        return this.isTypeOfList;
    }

    public void setIsTypeOfList(List<Object> isTypeOfList) {
        this.isTypeOfList = isTypeOfList;
    }

    public boolean hasOrder() {
        return this.hasOrder;
    }

    public void setHasOrder(boolean hasOrder) {
        this.hasOrder = hasOrder;
    }
}

