/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.mebn.entity;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import unbbayes.prs.mebn.OrdinaryVariable;
import unbbayes.prs.mebn.entity.Entity;
import unbbayes.prs.mebn.entity.ObjectEntityInstance;
import unbbayes.prs.mebn.entity.ObjectEntityInstanceOrdereable;
import unbbayes.prs.mebn.entity.Type;
import unbbayes.prs.mebn.entity.TypeContainer;
import unbbayes.prs.mebn.entity.exception.ObjectEntityHasInstancesException;
import unbbayes.prs.mebn.entity.exception.TypeAlreadyExistsException;
import unbbayes.prs.mebn.entity.exception.TypeDoesNotExistException;
import unbbayes.prs.mebn.entity.exception.TypeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectEntity
extends Entity {
    private TypeContainer typeContainer = null;
    private List<OrdinaryVariable> listSubstitute;
    private Set<ObjectEntityInstance> listObjectEntityInstance;

    protected ObjectEntity(String name, TypeContainer container) throws TypeException {
        super(name, container.createType(String.valueOf(name) + "_label"));
        this.typeContainer = container;
        this.listObjectEntityInstance = new HashSet<ObjectEntityInstance>();
    }

    private ObjectEntity(String name, Type _type) throws TypeException {
        super(name, _type);
        _type.addUserObject(this);
        this.typeContainer = null;
    }

    public void addSubstitute(OrdinaryVariable oVar) {
        this.listSubstitute.add(oVar);
    }

    public void removeSubstitute(OrdinaryVariable oVar) {
        this.listSubstitute.remove(oVar);
    }

    public ObjectEntityInstance addInstance(String name) throws TypeException {
        ObjectEntityInstance instance = null;
        instance = !this.isOrdereable() ? new ObjectEntityInstance(name, this) : new ObjectEntityInstanceOrdereable(name, this);
        this.listObjectEntityInstance.add(instance);
        return instance;
    }

    public Set<ObjectEntityInstance> getInstanceList() {
        return this.listObjectEntityInstance;
    }

    public ObjectEntityInstance getInstanceByName(String name) {
        for (ObjectEntityInstance instance : this.listObjectEntityInstance) {
            if (!instance.getName().equals(name)) continue;
            return instance;
        }
        return null;
    }

    public void removeInstance(ObjectEntityInstance instance) {
        this.listObjectEntityInstance.remove(instance);
    }

    public void removeAllInstances() {
        this.listObjectEntityInstance.clear();
    }

    protected void delete() throws TypeDoesNotExistException {
        this.getType().removeUserObject(this);
        this.typeContainer.removeType(this.getType());
    }

    public void setType(Type _type) throws TypeException {
        if (this.typeContainer.hasType(_type)) {
            if (this.type != null) {
                this.type.removeUserObject(this);
            }
        } else {
            throw new TypeDoesNotExistException();
        }
        this.type = _type;
    }

    public void setName(String name) throws TypeAlreadyExistsException {
        if (this.type != null) {
            this.type.renameType(String.valueOf(name) + "_label");
        } else {
            this.type = this.typeContainer.createType(String.valueOf(name) + "_label");
        }
        this.name = name;
    }

    @Override
    public String toString() {
        String ret = this.name;
        if (this.isOrdereable()) {
            ret = String.valueOf(ret) + " [Ord]";
        }
        return ret;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ObjectEntity) {
            return this.getName().equals(((ObjectEntity)obj).getName());
        }
        return false;
    }

    public boolean isOrdereable() {
        return this.type.hasOrder();
    }

    public void setOrdereable(boolean isOrdereable) throws ObjectEntityHasInstancesException {
        if (!this.listObjectEntityInstance.isEmpty()) {
            throw new ObjectEntityHasInstancesException();
        }
        this.getType().setHasOrder(isOrdereable);
    }
}

