/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.mebn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import unbbayes.prs.Edge;
import unbbayes.prs.Graph;
import unbbayes.prs.Node;
import unbbayes.prs.mebn.ContextNode;
import unbbayes.prs.mebn.InputNode;
import unbbayes.prs.mebn.MultiEntityBayesianNetwork;
import unbbayes.prs.mebn.MultiEntityNode;
import unbbayes.prs.mebn.OrdinaryVariable;
import unbbayes.prs.mebn.ResidentNode;
import unbbayes.prs.mebn.exception.CycleFoundException;
import unbbayes.prs.mebn.exception.MEBNConstructionException;
import unbbayes.prs.mebn.ssbn.OVInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MFrag
implements Graph {
    private MultiEntityBayesianNetwork multiEntityBayesianNetwork;
    private List<ContextNode> contextNodeList;
    private List<ResidentNode> residentNodeList;
    private List<InputNode> inputNodeList;
    private List<OrdinaryVariable> ordinaryVariableList;
    private List<OVInstance> ovInstancesList;
    private ArrayList<Node> nodeList;
    private ArrayList<Edge> edgeList;
    protected Map<String, Integer> nodeIndexes;
    private String name;
    private String description;
    private int ordinaryVariableNum = 1;
    private boolean isUsingDefaultCPT = false;
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.prs.mebn.resources.Resources");

    public MFrag(String name, MultiEntityBayesianNetwork mebn) {
        this.multiEntityBayesianNetwork = mebn;
        this.residentNodeList = new ArrayList<ResidentNode>();
        this.inputNodeList = new ArrayList<InputNode>();
        this.ordinaryVariableList = new ArrayList<OrdinaryVariable>();
        this.contextNodeList = new ArrayList<ContextNode>();
        this.ovInstancesList = new ArrayList<OVInstance>();
        this.setName(name);
        this.nodeList = new ArrayList();
        this.edgeList = new ArrayList();
        this.nodeIndexes = new HashMap<String, Integer>();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public MultiEntityBayesianNetwork getMultiEntityBayesianNetwork() {
        return this.multiEntityBayesianNetwork;
    }

    public void delete() {
        this.nodeList.clear();
        for (MultiEntityNode multiEntityNode : this.residentNodeList) {
            multiEntityNode.removeFromMFrag();
        }
        this.residentNodeList = new ArrayList<ResidentNode>();
        for (MultiEntityNode multiEntityNode : this.inputNodeList) {
            multiEntityNode.removeFromMFrag();
        }
        this.inputNodeList = new ArrayList<InputNode>();
        for (OrdinaryVariable ordinaryVariable : this.ordinaryVariableList) {
            ordinaryVariable.removeFromMFrag();
        }
        this.ordinaryVariableList = new ArrayList<OrdinaryVariable>();
        for (MultiEntityNode multiEntityNode : this.contextNodeList) {
            multiEntityNode.removeFromMFrag();
        }
        this.contextNodeList = new ArrayList<ContextNode>();
    }

    @Override
    public void addNode(Node node) {
        this.nodeList.add(node);
        this.multiEntityBayesianNetwork.addNode(node);
    }

    public void addContextNode(ContextNode contextNode) {
        this.contextNodeList.add(contextNode);
        this.addNode(contextNode);
        contextNode.setMFrag(this);
        this.getMultiEntityBayesianNetwork().plusContextNodeNul();
    }

    public void addResidentNode(ResidentNode residentNode) {
        this.residentNodeList.add(residentNode);
        this.addNode(residentNode);
        this.getMultiEntityBayesianNetwork().plusDomainResidentNodeNum();
    }

    public void addInputNode(InputNode inputNode) {
        this.inputNodeList.add(inputNode);
        this.addNode(inputNode);
        this.getMultiEntityBayesianNetwork().plusGenerativeInputNodeNum();
    }

    public void addOrdinaryVariable(OrdinaryVariable ordinaryVariable) {
        this.ordinaryVariableList.add(ordinaryVariable);
        ++this.ordinaryVariableNum;
        this.addNode(ordinaryVariable);
    }

    @Override
    public void removeNode(Node node) {
        this.nodeList.remove(node);
        this.multiEntityBayesianNetwork.removeNode(node);
    }

    protected void removeResidentNode(ResidentNode residentNode) {
        this.residentNodeList.remove(residentNode);
        this.removeNode(residentNode);
    }

    protected void removeInputNode(InputNode inputNode) {
        this.inputNodeList.remove(inputNode);
        this.removeNode(inputNode);
    }

    public void removeContextNode(ContextNode contextNode) {
        this.contextNodeList.remove(contextNode);
        this.removeNode(contextNode);
    }

    public int getOrdinaryVariableNum() {
        return this.ordinaryVariableNum;
    }

    public void plusOrdinaryVariableNum() {
        ++this.ordinaryVariableNum;
    }

    public void removeOrdinaryVariable(OrdinaryVariable ordinaryVariable) {
        this.ordinaryVariableList.remove(ordinaryVariable);
        this.removeNode(ordinaryVariable);
    }

    public boolean containsOrdinaryVariable(OrdinaryVariable ordinaryVariable) {
        return this.ordinaryVariableList.contains(ordinaryVariable);
    }

    public OrdinaryVariable getOrdinaryVariableByName(String name) {
        for (OrdinaryVariable test : this.ordinaryVariableList) {
            if (!test.getName().equals(name)) continue;
            return test;
        }
        return null;
    }

    public ArrayList<Node> getNodeList() {
        return this.nodeList;
    }

    public List<OrdinaryVariable> getOrdinaryVariableList() {
        return this.ordinaryVariableList;
    }

    public boolean containsNode(Node node) {
        return this.nodeList.contains(node);
    }

    @Override
    public List<Edge> getEdges() {
        return this.edgeList;
    }

    @Override
    public ArrayList<Node> getNodes() {
        return this.getNodeList();
    }

    @Override
    public int getNodeCount() {
        return this.nodeList.size();
    }

    @Override
    public void removeEdge(Edge arco) {
        Node origin = arco.getOriginNode();
        Node destination = arco.getDestinationNode();
        origin.getChildren().remove(arco.getDestinationNode());
        destination.getParents().remove(arco.getOriginNode());
        this.edgeList.remove(arco);
        if (origin instanceof ResidentNode) {
            ((ResidentNode)origin).removeResidentNodeChildList((ResidentNode)destination);
        } else {
            ((InputNode)origin).removeResidentNodeChild((ResidentNode)destination);
        }
    }

    public void removeEdgeByNodes(Node origin, Node destination) {
        for (Edge edge : this.edgeList) {
            if (edge.getOriginNode() != origin || edge.getDestinationNode() != destination) continue;
            this.removeEdge(edge);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addEdge(Edge edge) throws MEBNConstructionException, CycleFoundException, Exception {
        Node origin = edge.getOriginNode();
        Node destination = edge.getDestinationNode();
        if (!(destination instanceof ResidentNode)) throw new MEBNConstructionException(resource.getString("InvalidEdgeException"));
        if (origin instanceof ResidentNode) {
            this.addEdgeInGraph(edge);
            ((ResidentNode)origin).addResidentNodeChild((ResidentNode)destination);
            return;
        } else {
            if (!(origin instanceof InputNode)) throw new MEBNConstructionException(resource.getString("InvalidEdgeException"));
            this.addEdgeInGraph(edge);
            ((InputNode)origin).addResidentNodeChild((ResidentNode)destination);
        }
    }

    private void addEdgeInGraph(Edge edge) throws Exception {
        Node origin = edge.getOriginNode();
        Node destination = edge.getDestinationNode();
        origin.getChildren().add(edge.getDestinationNode());
        destination.getParents().add(edge.getOriginNode());
        this.edgeList.add(edge);
    }

    @Override
    public int hasEdge(Node no1, Node no2) {
        if (no1 == no2) {
            return 1;
        }
        int sizeArcos = this.edgeList.size();
        int i = 0;
        while (i < sizeArcos) {
            Edge auxA = this.edgeList.get(i);
            if (auxA.getOriginNode() == no1 && auxA.getDestinationNode() == no2 || auxA.getOriginNode() == no2 && auxA.getDestinationNode() == no1) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public List<InputNode> getInputNodeList() {
        return this.inputNodeList;
    }

    public void setInputNodeList(List<InputNode> inputNodeList) {
        this.inputNodeList = inputNodeList;
    }

    public List<ResidentNode> getResidentNodeList() {
        return this.residentNodeList;
    }

    public void setResidentNodeList(List<ResidentNode> residentNodeList) {
        this.residentNodeList = residentNodeList;
    }

    public void setOrdinaryVariableNum(int ordinaryVariableNum) {
        this.ordinaryVariableNum = ordinaryVariableNum;
    }

    public List<ContextNode> getContextNodeList() {
        return this.contextNodeList;
    }

    public int getDomainResidentNodeCount() {
        return this.residentNodeList.size();
    }

    public int getContextNodeCount() {
        return this.contextNodeList.size();
    }

    public int getGenerativeInputNodeCount() {
        return this.inputNodeList.size();
    }

    public int getDomainResidentNodeNum() {
        return this.getMultiEntityBayesianNetwork().getDomainResidentNodeNum();
    }

    public ResidentNode getDomainResidentNodeByName(String name) {
        for (ResidentNode test : this.residentNodeList) {
            if (!test.getName().equals(name)) continue;
            return test;
        }
        return null;
    }

    public int getContextNodeNum() {
        return this.getMultiEntityBayesianNetwork().getContextNodeNum();
    }

    public int getGenerativeInputNodeNum() {
        return this.getMultiEntityBayesianNetwork().getGenerativeInputNodeNum();
    }

    public boolean containsContextNode(ContextNode contextNode) {
        return this.contextNodeList.contains(contextNode);
    }

    public boolean containsDomainResidentNode(ResidentNode residentNode) {
        return this.residentNodeList.contains(residentNode);
    }

    public boolean containsGenerativeInputNode(InputNode generativeInputNode) {
        return this.inputNodeList.contains(generativeInputNode);
    }

    public ContextNode getContextNodeByName(String name) {
        for (ContextNode test : this.contextNodeList) {
            if (!test.getName().equals(name)) continue;
            return test;
        }
        return null;
    }

    public boolean containsOrdinaryVariableDomain(OrdinaryVariable ordinaryVariable) {
        return this.containsOrdinaryVariable(ordinaryVariable);
    }

    public void addOVInstance(OVInstance element) {
        this.ovInstancesList.add(element);
    }

    public List<OVInstance> getOVInstancesForOrdinaryVariable(OrdinaryVariable ov) {
        ArrayList<OVInstance> ret = new ArrayList<OVInstance>();
        for (OVInstance ovInstance : this.ovInstancesList) {
            if (!ovInstance.getOv().equals(ov)) continue;
            ret.add(ovInstance);
        }
        return ret;
    }

    public void removeOVInstance(OVInstance element) {
        this.ovInstancesList.remove(element);
    }

    public void clearOVInstanceList() {
        this.ovInstancesList.clear();
    }

    public Collection<ContextNode> getContextByAllOV(OrdinaryVariable ... allOVs) {
        ArrayList<ContextNode> ret = new ArrayList<ContextNode>();
        if (allOVs == null) {
            return ret;
        }
        for (ContextNode node : this.getContextNodeList()) {
            if (node.getAllOVCount() != allOVs.length || !node.hasAllOVs(allOVs)) continue;
            ret.add(node);
        }
        return ret;
    }

    public Collection<ContextNode> getContextByOV(OrdinaryVariable ... allOVs) {
        ArrayList<ContextNode> ret = new ArrayList<ContextNode>();
        if (allOVs == null) {
            return ret;
        }
        for (ContextNode node : this.getContextNodeList()) {
            if (!node.hasAllOVs(allOVs)) continue;
            ret.add(node);
        }
        return ret;
    }

    public Collection<ContextNode> getContextByOVCombination(Collection<OrdinaryVariable> allOVs) {
        ArrayList<ContextNode> ret = new ArrayList<ContextNode>();
        if (allOVs == null) {
            return ret;
        }
        for (ContextNode contextNode : this.getContextNodeList()) {
            boolean test = true;
            Set<OrdinaryVariable> ordinaryVariableList = contextNode.getVariableList();
            for (OrdinaryVariable ov : ordinaryVariableList) {
                if (allOVs.contains(ov)) continue;
                test = false;
                break;
            }
            if (!test) continue;
            ret.add(contextNode);
        }
        return ret;
    }

    public Collection<ContextNode> getSearchContextByOVCombination(Collection<OrdinaryVariable> allOVs) {
        ArrayList<ContextNode> ret = new ArrayList<ContextNode>();
        if (allOVs == null) {
            return ret;
        }
        for (ContextNode node : this.getContextNodeList()) {
            boolean test = false;
            Set<OrdinaryVariable> ordinaryVariableList = node.getVariableList();
            for (OrdinaryVariable ov : ordinaryVariableList) {
                if (!allOVs.contains(ov)) continue;
                test = true;
                break;
            }
            if (!test) continue;
            ret.add(node);
        }
        return ret;
    }

    public Collection<ContextNode> getContextNodeByOrdinaryVariableRelated(Collection<OrdinaryVariable> allOVs) {
        ArrayList<ContextNode> ret = new ArrayList<ContextNode>();
        ArrayList<OrdinaryVariable> ovList = new ArrayList<OrdinaryVariable>();
        boolean ordinaryVariableAdded = true;
        ovList.addAll(allOVs);
        boolean i = false;
        while (ordinaryVariableAdded) {
            ordinaryVariableAdded = false;
            ArrayList<OrdinaryVariable> plusOrdinaryVariable = new ArrayList<OrdinaryVariable>();
            for (OrdinaryVariable ov : ovList) {
                for (ContextNode ct : this.contextNodeList) {
                    if (!ct.getVariableList().contains(ov) || ret.contains(ct)) continue;
                    ret.add(ct);
                    for (OrdinaryVariable ovContext : ct.getVariableList()) {
                        if (ovList.contains(ovContext)) continue;
                        plusOrdinaryVariable.add(ovContext);
                        ordinaryVariableAdded = true;
                    }
                }
            }
            for (OrdinaryVariable ov : plusOrdinaryVariable) {
                ovList.add(ov);
            }
        }
        return ret;
    }

    public Collection<ContextNode> getContextByOV(Collection<OrdinaryVariable> allOVs) {
        if (allOVs == null) {
            return new ArrayList<ContextNode>();
        }
        OrdinaryVariable[] ovs = new OrdinaryVariable[allOVs.size()];
        ovs = allOVs.toArray(ovs);
        return this.getContextByOV(ovs);
    }

    public String toString() {
        return this.getName();
    }

    public boolean isUsingDefaultCPT() {
        return this.isUsingDefaultCPT;
    }

    public void setAsUsingDefaultCPT(boolean isUsingDefaultCPT) {
        this.isUsingDefaultCPT = isUsingDefaultCPT;
    }

    public Node containsNode(String name) {
        ArrayList<Node> list = this.getNodeList();
        Node node = null;
        int i = 0;
        while (i < list.size()) {
            node = list.get(i);
            if (node.getName().equalsIgnoreCase(name)) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

