/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.hybridbn;

import java.awt.Color;
import java.awt.Graphics2D;
import java.io.Serializable;
import java.util.ResourceBundle;
import unbbayes.draw.DrawEllipse;
import unbbayes.prs.Node;
import unbbayes.prs.bn.TreeVariable;
import unbbayes.prs.exception.InvalidParentException;
import unbbayes.prs.hybridbn.CNNormalDistribution;
import unbbayes.util.ResourceController;

public class ContinuousNode
extends TreeVariable
implements Serializable {
    public static final int MEAN_MARGINAL_INDEX = 0;
    public static final int VARIANCE_MARGINAL_INDEX = 1;
    private static final long serialVersionUID = 1L;
    private static Color color = Color.GREEN;
    private DrawEllipse drawEllipse;
    private CNNormalDistribution cnNormalDistribution;
    private ResourceBundle resource = ResourceController.RS_HYBRID_BN;

    public int getType() {
        return 5;
    }

    public ContinuousNode() {
        this.cnNormalDistribution = new CNNormalDistribution(this);
        this.appendState(this.resource.getString("meanName"));
        this.appendState(this.resource.getString("varianceName"));
        this.drawEllipse = new DrawEllipse(this.position, size);
        this.drawElement.add(this.drawEllipse);
    }

    public CNNormalDistribution getCnNormalDistribution() {
        return this.cnNormalDistribution;
    }

    public static Color getColor() {
        return color;
    }

    public static void setColor(Color color) {
        ContinuousNode.color = color;
    }

    public static void setColor(int c) {
        color = new Color(c);
    }

    public void setSelected(boolean b) {
        this.drawEllipse.setSelected(b);
        super.setSelected(b);
    }

    public void paint(Graphics2D graphics) {
        this.drawEllipse.setFillColor(ContinuousNode.getColor());
        super.paint(graphics);
    }

    protected void marginal() {
    }

    public void addParent(Node parent) throws InvalidParentException {
        if (parent.getType() != 0 && parent.getType() != 5) {
            throw new InvalidParentException(this.resource.getString("continuousNodeInvalidParentException"));
        }
        super.addParent(parent);
        this.cnNormalDistribution.refreshParents();
    }

    public void removeParent(Node parent) {
        super.removeParent(parent);
        this.cnNormalDistribution.refreshParents();
    }

    public void addChild(Node child) throws InvalidParentException {
        if (child.getType() != 5) {
            throw new InvalidParentException(this.resource.getString("continuousNodeInvalidParentException"));
        }
        super.addChild(child);
        this.cnNormalDistribution.refreshParents();
    }

    public void removeChild(Node child) {
        super.removeChild(child);
        this.cnNormalDistribution.refreshParents();
    }
}

