/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs.bn;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import unbbayes.prs.Node;
import unbbayes.prs.bn.Clique;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.prs.bn.Separator;
import unbbayes.prs.id.UtilityNode;
import unbbayes.util.SetToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JunctionTree
implements Serializable {
    private static final long serialVersionUID = 0L;
    private boolean initialized;
    private float n;
    private List<Clique> cliques;
    private List<Separator> separators = new ArrayList<Separator>();
    private int[][][] coordSep;

    public JunctionTree() {
        this.cliques = new ArrayList<Clique>();
    }

    public float getN() {
        return this.n;
    }

    public void addSeparator(Separator sep) {
        this.separators.add(sep);
    }

    public int getSeparatorsSize() {
        return this.separators.size();
    }

    public Separator getSeparatorAt(int index) {
        return this.separators.get(index);
    }

    public List<Clique> getCliques() {
        return this.cliques;
    }

    public void consistency() throws Exception {
        this.n = 1.0f;
        Clique raiz = this.cliques.get(0);
        this.coleteEvidencia(raiz);
        this.distributeEvidences(raiz);
    }

    protected void coleteEvidencia(Clique clique) throws Exception {
        int sizeFilhos = clique.getChildrenSize();
        int c = 0;
        while (c < sizeFilhos) {
            Clique auxClique = clique.getChildAt(c);
            if (auxClique.getChildrenSize() != 0) {
                this.coleteEvidencia(auxClique);
            }
            this.absorb(clique, auxClique);
            ++c;
        }
        this.n *= clique.normalize();
    }

    protected void distributeEvidences(Clique clique) {
        int sizeFilhos = clique.getChildrenSize();
        int c = 0;
        while (c < sizeFilhos) {
            Clique auxClique = clique.getChildAt(c);
            this.absorb(auxClique, clique);
            if (auxClique.getChildrenSize() != 0) {
                this.distributeEvidences(auxClique);
            }
            ++c;
        }
    }

    protected void absorb(Clique clique1, Clique clique2) {
        PotentialTable sepTab = this.getSeparator(clique1, clique2).getPotentialTable();
        ArrayList<Node> toDie = SetToolkit.clone(clique2.getNodes());
        int i = 0;
        while (i < sepTab.variableCount()) {
            toDie.remove(sepTab.getVariableAt(i));
            ++i;
        }
        PotentialTable dummyTable = (PotentialTable)clique2.getPotentialTable().clone();
        int i2 = 0;
        while (i2 < toDie.size()) {
            dummyTable.removeVariable(toDie.get(i2));
            ++i2;
        }
        PotentialTable originalSeparatorTable = (PotentialTable)sepTab.clone();
        int i3 = sepTab.tableSize() - 1;
        while (i3 >= 0) {
            sepTab.setValue(i3, dummyTable.getValue(i3));
            --i3;
        }
        dummyTable.directOpTab(originalSeparatorTable, 1);
        clique1.getPotentialTable().opTab(dummyTable, 0);
    }

    public void initBeliefs() throws Exception {
        if (!this.initialized) {
            PotentialTable auxUtilTab;
            PotentialTable auxTabPot;
            int sizeCliques = this.cliques.size();
            int k = 0;
            while (k < sizeCliques) {
                Clique auxClique = this.cliques.get(k);
                auxTabPot = auxClique.getPotentialTable();
                auxUtilTab = auxClique.getUtilityTable();
                int tableSize = auxTabPot.tableSize();
                int c = 0;
                while (c < tableSize) {
                    auxTabPot.setValue(c, 1.0f);
                    ++c;
                }
                int sizeAssociados = auxClique.getAssociatedProbabilisticNodes().size();
                int c2 = 0;
                while (c2 < sizeAssociados) {
                    ProbabilisticNode auxVP = (ProbabilisticNode)auxClique.getAssociatedProbabilisticNodes().get(c2);
                    auxTabPot.opTab(auxVP.getPotentialTable(), 0);
                    ++c2;
                }
                tableSize = auxUtilTab.tableSize();
                int i = 0;
                while (i < tableSize) {
                    auxUtilTab.setValue(i, 0.0f);
                    ++i;
                }
                sizeAssociados = auxClique.getAssociatedUtilityNodes().size();
                int i2 = 0;
                while (i2 < sizeAssociados) {
                    UtilityNode utilNode = (UtilityNode)auxClique.getAssociatedUtilityNodes().get(i2);
                    auxUtilTab.opTab(utilNode.getPotentialTable(), 2);
                    ++i2;
                }
                ++k;
            }
            int sizeSeparadores = this.separators.size();
            int k2 = 0;
            while (k2 < sizeSeparadores) {
                Separator auxSep = this.separators.get(k2);
                auxTabPot = auxSep.getPotentialTable();
                int sizeDados = auxTabPot.tableSize();
                int c = 0;
                while (c < sizeDados) {
                    auxTabPot.setValue(c, 1.0f);
                    ++c;
                }
                auxUtilTab = auxSep.getUtilityTable();
                sizeDados = auxUtilTab.tableSize();
                int i = 0;
                while (i < sizeDados) {
                    auxUtilTab.setValue(i, 0.0f);
                    ++i;
                }
                ++k2;
            }
            this.consistency();
            this.copyTableData();
            this.initialized = true;
        } else {
            this.restoreTableData();
        }
    }

    private void restoreTableData() {
        int sizeCliques = this.cliques.size();
        int k = 0;
        while (k < sizeCliques) {
            Clique auxClique = this.cliques.get(k);
            auxClique.getPotentialTable().restoreData();
            auxClique.getUtilityTable().restoreData();
            ++k;
        }
        int sizeSeparadores = this.separators.size();
        int k2 = 0;
        while (k2 < sizeSeparadores) {
            Separator auxSep = this.separators.get(k2);
            auxSep.getPotentialTable().restoreData();
            auxSep.getUtilityTable().restoreData();
            ++k2;
        }
    }

    private void copyTableData() {
        int sizeCliques = this.cliques.size();
        int k = 0;
        while (k < sizeCliques) {
            Clique auxClique = this.cliques.get(k);
            auxClique.getPotentialTable().copyData();
            auxClique.getUtilityTable().copyData();
            ++k;
        }
        int sizeSeparadores = this.separators.size();
        int k2 = 0;
        while (k2 < sizeSeparadores) {
            Separator auxSep = this.separators.get(k2);
            auxSep.getPotentialTable().copyData();
            auxSep.getUtilityTable().copyData();
            ++k2;
        }
    }

    public Separator getSeparator(Clique clique1, Clique clique2) {
        int sizeSeparadores = this.separators.size();
        int indSep = 0;
        while (indSep < sizeSeparadores) {
            Separator separator = this.separators.get(indSep);
            if (separator.getClique1() == clique1 && separator.getClique2() == clique2 || separator.getClique2() == clique1 && separator.getClique1() == clique2) {
                return separator;
            }
            ++indSep;
        }
        return null;
    }
}

