/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.prs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import unbbayes.prs.Edge;
import unbbayes.prs.Graph;
import unbbayes.prs.Node;
import unbbayes.prs.bn.ITabledVariable;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.exception.InvalidParentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Network
implements Graph {
    protected String id;
    protected String name;
    protected ArrayList<Node> nodeList;
    protected List<Edge> edgeList;
    protected Map<String, Integer> nodeIndexes;
    protected Node.NodeNameChangedListener nodeNameChangedListener;

    public Network(String name) {
        this.id = this.name = name;
        this.nodeList = new ArrayList();
        this.edgeList = new ArrayList<Edge>();
        this.nodeIndexes = new HashMap<String, Integer>();
        this.nodeNameChangedListener = new Node.NodeNameChangedListener(){

            public void nodeNameChanged(Node.NodeNameChangedEvent event) {
                int index = Network.this.nodeIndexes.get(event.getOldName());
                Network.this.nodeIndexes.remove(event.getOldName());
                Network.this.nodeIndexes.put(event.getNewName(), index);
            }
        };
    }

    @Override
    public List<Edge> getEdges() {
        return this.edgeList;
    }

    @Override
    public ArrayList<Node> getNodes() {
        return this.nodeList;
    }

    @Override
    public int getNodeCount() {
        return this.nodeList.size();
    }

    public Node getNodeAt(int index) {
        return this.nodeList.get(index);
    }

    public Node getNode(String name) {
        int index = this.getNodeIndex(name);
        if (index == -1) {
            return null;
        }
        return this.nodeList.get(index);
    }

    public int getNodeIndex(String name) {
        Integer index = this.nodeIndexes.get(name);
        if (index == null) {
            return -1;
        }
        return index;
    }

    @Override
    public void removeEdge(Edge edge) {
        edge.getOriginNode().removeChild(edge.getDestinationNode());
        edge.getDestinationNode().removeParent(edge.getOriginNode());
        this.removeArco(edge);
    }

    @Override
    public void addNode(Node node) {
        this.nodeList.add(node);
        this.nodeIndexes.put(node.getName(), new Integer(this.nodeList.size() - 1));
        node.addNodeNameChangedListener(this.nodeNameChangedListener);
    }

    @Override
    public void addEdge(Edge edge) throws InvalidParentException {
        edge.getOriginNode().addChild(edge.getDestinationNode());
        edge.getDestinationNode().addParent(edge.getOriginNode());
        this.edgeList.add(edge);
        if (edge.getDestinationNode() instanceof ITabledVariable) {
            ITabledVariable v2 = (ITabledVariable)((Object)edge.getDestinationNode());
            PotentialTable auxTab = v2.getPotentialTable();
            auxTab.addVariable(edge.getOriginNode());
        }
    }

    @Override
    public void removeNode(Node element) {
        this.nodeList.remove(element);
        this.nodeIndexes.clear();
        int c = 0;
        while (c < this.nodeList.size()) {
            Node auxNo = this.nodeList.get(c);
            auxNo.removeParent(element);
            auxNo.removeChild(element);
            this.nodeIndexes.put(auxNo.getName(), new Integer(c));
            ++c;
        }
        if (!this.edgeList.isEmpty()) {
            Edge auxArco = this.edgeList.get(0);
            c = 0;
            while (auxArco != this.edgeList.get(this.edgeList.size() - 1)) {
                if (auxArco.getOriginNode() == element || auxArco.getDestinationNode() == element) {
                    this.removeArco(auxArco);
                } else {
                    ++c;
                }
                auxArco = this.edgeList.get(c);
            }
            if (auxArco.getOriginNode() == element || auxArco.getDestinationNode() == element) {
                this.removeArco(auxArco);
            }
        }
    }

    private void removeArco(Edge elemento) {
        this.edgeList.remove(elemento);
        Node auxNo = elemento.getDestinationNode();
        if (auxNo instanceof ITabledVariable) {
            ITabledVariable auxTabledVariable = (ITabledVariable)((Object)auxNo);
            PotentialTable auxPotentialTable = auxTabledVariable.getPotentialTable();
            auxPotentialTable.removeVariable(elemento.getOriginNode(), true);
        }
    }

    protected void clearNodes() {
        this.nodeList.clear();
    }

    protected void clearEdges() {
        this.edgeList.clear();
    }

    @Override
    public int hasEdge(Node no1, Node no2) {
        return this.hasEdge(no1, no2, this.edgeList);
    }

    protected int hasEdge(Node no1, Node no2, List<Edge> vetArcos) {
        if (no1 == no2) {
            return 1;
        }
        int sizeArcos = vetArcos.size();
        int i = 0;
        while (i < sizeArcos) {
            Edge auxA = vetArcos.get(i);
            if (auxA.getOriginNode() == no1 && auxA.getDestinationNode() == no2 || auxA.getOriginNode() == no2 && auxA.getDestinationNode() == no1) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Edge getEdge(Node no1, Node no2) {
        List<Edge> vetArcos = this.edgeList;
        if (no1 == no2) {
            return null;
        }
        int sizeArcos = vetArcos.size();
        int i = 0;
        while (i < sizeArcos) {
            Edge auxA = vetArcos.get(i);
            if (auxA.getOriginNode() == no1 && auxA.getDestinationNode() == no2 || auxA.getOriginNode() == no2 && auxA.getDestinationNode() == no1) {
                return vetArcos.get(i);
            }
            ++i;
        }
        return null;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return String.valueOf(this.name != null ? this.name : "") + '(' + this.id + ')';
    }
}

