/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.metaphor.afin;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import unbbayes.controller.IconController;
import unbbayes.prs.Node;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.prs.bn.TreeVariable;

public class AFINMetaphorTree
extends JTree {
    private static final long serialVersionUID = 0L;
    public static final int CHECK_YES = 1;
    public static final int CHECK_NO = -1;
    public static final int CHECK_EMPTY = 0;
    private ProbabilisticNetwork net = null;
    private boolean showProbability = false;
    private HashMap<DefaultMutableTreeNode, Object> objectsMap = new HashMap();
    private NumberFormat nf;
    protected IconController iconController = IconController.getInstance();

    protected AFINMetaphorTree() {
        this.setShowsRootHandles(true);
        this.setSelectionModel(null);
        this.setRootVisible(false);
        this.setAutoscrolls(true);
        this.setCellRenderer(new MetaphorTreeCellRenderer());
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                AFINMetaphorTree.this.methaphorTreeMouseClicked(evt);
            }
        });
        this.nf = NumberFormat.getInstance(Locale.US);
        this.nf.setMaximumFractionDigits(4);
        this.setSelectionModel(new DefaultTreeSelectionModel());
    }

    public AFINMetaphorTree(ProbabilisticNetwork net) {
        this(net, false);
    }

    public AFINMetaphorTree(ProbabilisticNetwork net, boolean showProbability) {
        this();
        this.showProbability = showProbability;
        this.setProbabilisticNetwork(net);
    }

    public void setProbabilisticNetwork(ProbabilisticNetwork net) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        if (net != null) {
            if (!net.equals(this.net)) {
                this.net = net;
                root.removeAllChildren();
                this.objectsMap.clear();
                DefaultTreeModel model = new DefaultTreeModel((DefaultMutableTreeNode)net.getHierarchicTree().getModel().getRoot());
                this.setModel(model);
                root = (DefaultMutableTreeNode)this.getModel().getRoot();
                ArrayList<Node> nos = net.getNodes();
                int size = nos.size();
                int i = 0;
                while (i < size) {
                    Node node = nos.get(i);
                    DefaultMutableTreeNode treeNode = this.findUserObject(node.getDescription(), root);
                    if (treeNode != null) {
                        this.objectsMap.put(treeNode, node);
                        int statesSize = node.getStatesSize();
                        int j = 0;
                        while (j < statesSize) {
                            DefaultMutableTreeNode stateNode = new DefaultMutableTreeNode(String.valueOf(node.getStateAt(j)) + (this.showProbability ? " " + this.nf.format((double)((TreeVariable)node).getMarginalAt(j) * 100.0) + "%" : ""));
                            treeNode.add(stateNode);
                            this.objectsMap.put(stateNode, new StateObject((ProbabilisticNode)node, j, 0));
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        } else {
            this.net = null;
            root.removeAllChildren();
            this.objectsMap.clear();
        }
    }

    private DefaultMutableTreeNode findUserObject(String treeNode, DefaultMutableTreeNode root) {
        Enumeration<TreeNode> e = root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (!node.getUserObject().toString().equals(treeNode)) continue;
            return node;
        }
        return null;
    }

    public ProbabilisticNetwork getProbabilisticNetwork() {
        return this.net;
    }

    public void setShowProbability(boolean showProbability) {
        if (showProbability != this.showProbability) {
            this.showProbability = showProbability;
            ProbabilisticNetwork temp = this.net;
            this.setProbabilisticNetwork(null);
            this.setProbabilisticNetwork(temp);
        }
    }

    public boolean getShowProbability() {
        return this.showProbability;
    }

    public void propagate() {
        try {
            this.net.initialize();
            int count = this.getRowCount();
            int i = 0;
            while (i < count) {
                StateObject stateObject;
                TreePath path = this.getPathForRow(i);
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)path.getLastPathComponent();
                Object obj = this.objectsMap.get(treeNode);
                if (obj instanceof StateObject && (stateObject = (StateObject)obj).getCheck() == 1) {
                    ProbabilisticNode node = stateObject.getProbabilisticNode();
                    node.addFinding(stateObject.getStateIndex());
                }
                ++i;
            }
            this.net.updateEvidences();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void methaphorTreeMouseClicked(MouseEvent evt) {
        Object obj;
        DefaultMutableTreeNode clickedNode;
        TreePath clickedPath = this.getPathForLocation(evt.getX(), evt.getY());
        if (clickedPath != null && (clickedNode = (DefaultMutableTreeNode)clickedPath.getLastPathComponent()) != null && clickedNode.isLeaf() && (obj = this.objectsMap.get(clickedNode)) instanceof StateObject) {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)clickedNode.getParent();
            Enumeration<TreeNode> childrenEnum = parentNode.children();
            StateObject yesChecked = null;
            ArrayList<StateObject> noCheckeds = new ArrayList<StateObject>();
            ArrayList<StateObject> emptyCheckeds = new ArrayList<StateObject>();
            while (childrenEnum.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)childrenEnum.nextElement();
                if (child.equals(clickedNode)) continue;
                if (((StateObject)this.objectsMap.get(child)).getCheck() == 1) {
                    yesChecked = (StateObject)this.objectsMap.get(child);
                    continue;
                }
                if (((StateObject)this.objectsMap.get(child)).getCheck() == -1) {
                    noCheckeds.add((StateObject)this.objectsMap.get(child));
                    continue;
                }
                emptyCheckeds.add((StateObject)this.objectsMap.get(child));
            }
            if (SwingUtilities.isLeftMouseButton(evt)) {
                if (((StateObject)obj).getCheck() == 1) {
                    ((StateObject)obj).setCheck(0);
                    int i = 0;
                    while (i < noCheckeds.size()) {
                        ((StateObject)noCheckeds.get(i)).setCheck(0);
                        ++i;
                    }
                } else {
                    ((StateObject)obj).setCheck(1);
                    if (yesChecked != null) {
                        yesChecked.setCheck(-1);
                    }
                    int i = 0;
                    while (i < emptyCheckeds.size()) {
                        ((StateObject)emptyCheckeds.get(i)).setCheck(-1);
                        ++i;
                    }
                }
            }
            if (SwingUtilities.isRightMouseButton(evt)) {
                if (((StateObject)obj).getCheck() == -1) {
                    ((StateObject)obj).setCheck(0);
                    if (yesChecked != null) {
                        yesChecked.setCheck(0);
                    }
                } else if (noCheckeds.size() < parentNode.getChildCount() - 1) {
                    ((StateObject)obj).setCheck(-1);
                    if (noCheckeds.size() == parentNode.getChildCount() - 2) {
                        ((StateObject)emptyCheckeds.get(0)).setCheck(1);
                    }
                }
            }
            this.repaint();
        }
    }

    public void expandTree() {
        int i = 0;
        while (i < this.getRowCount()) {
            this.expandRow(i);
            ++i;
        }
    }

    public void collapseTree() {
        int i = 0;
        while (i < this.getRowCount()) {
            this.collapseRow(i);
            ++i;
        }
    }

    public void setNumberFormat(Locale local) {
        this.nf = NumberFormat.getInstance(local);
    }

    public Node getLastSelectedPathComponent() {
        DefaultMutableTreeNode selectedNode = null;
        Node returnNode = null;
        try {
            selectedNode = (DefaultMutableTreeNode)super.getLastSelectedPathComponent();
            Object o = this.objectsMap.get(selectedNode);
            while (!(o instanceof Node)) {
                if ((selectedNode = (DefaultMutableTreeNode)selectedNode.getParent()) == null) break;
                o = this.objectsMap.get(selectedNode);
            }
            returnNode = (Node)o;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return returnNode;
    }

    public boolean hasNode(Node node) {
        return this.objectsMap.containsValue(node);
    }

    private class MetaphorTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 0L;
        ImageIcon yesIcon;
        ImageIcon noIcon;
        ImageIcon emptyIcon;
        ImageIcon evidenciasIcon;
        ImageIcon folderSmallIcon;

        private MetaphorTreeCellRenderer() {
            this.yesIcon = AFINMetaphorTree.this.iconController.getYesStateIcon();
            this.noIcon = AFINMetaphorTree.this.iconController.getNoStateIcon();
            this.emptyIcon = AFINMetaphorTree.this.iconController.getEmptyStateIcon();
            this.evidenciasIcon = AFINMetaphorTree.this.iconController.getMoreIcon();
            this.folderSmallIcon = AFINMetaphorTree.this.iconController.getFolderSmallIcon();
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
            if (leaf) {
                Object obj = AFINMetaphorTree.this.objectsMap.get(treeNode);
                if (obj instanceof StateObject) {
                    StateObject stateObject = (StateObject)obj;
                    int check = stateObject.getCheck();
                    this.setIcon(check == 1 ? this.yesIcon : (check == -1 ? this.noIcon : this.emptyIcon));
                }
            } else {
                Object obj = AFINMetaphorTree.this.objectsMap.get(treeNode);
                if (obj instanceof Node) {
                    this.setIcon(this.evidenciasIcon);
                }
                this.setOpenIcon(this.folderSmallIcon);
                this.setClosedIcon(this.folderSmallIcon);
            }
            return this;
        }
    }

    private class StateObject {
        private ProbabilisticNode node;
        private int stateIndex = -1;
        private int check = 0;

        public StateObject(ProbabilisticNode node, int stateIndex, int check) {
            this.node = node;
            this.stateIndex = stateIndex;
            this.check = check;
        }

        public int getStateIndex() {
            return this.stateIndex;
        }

        public void setStateIndex(int stateIndex) {
            this.stateIndex = stateIndex;
        }

        public int getCheck() {
            return this.check;
        }

        public void setCheck(int check) {
            this.check = check;
        }

        public ProbabilisticNode getProbabilisticNode() {
            return this.node;
        }
    }
}

