/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.metaphor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import unbbayes.controller.FileController;
import unbbayes.controller.IconController;
import unbbayes.gui.FileIcon;
import unbbayes.gui.SimpleFileFilter;
import unbbayes.io.NetIO;
import unbbayes.io.XMLBIFIO;
import unbbayes.metaphor.MetaphorResult;
import unbbayes.metaphor.MetaphorTree;
import unbbayes.prs.bn.ProbabilisticNetwork;

public class MetaphorMainPanel
extends JPanel {
    private static final long serialVersionUID = 0L;
    private BorderLayout borderLayout1 = new BorderLayout();
    private JToolBar metaphorToolBar = new JToolBar();
    private JTabbedPane jTabbedPane1 = new JTabbedPane();
    private JPanel statusPanel = new JPanel();
    private BorderLayout borderLayout2 = new BorderLayout();
    private JLabel statusBar = new JLabel();
    private JButton diagnosticButton = new JButton();
    private JButton saveButton = new JButton();
    private JButton openButton = new JButton();
    private JPanel jPanel1 = new JPanel();
    private JPanel jPanel3 = new JPanel();
    private MetaphorTree metaphorTree = new MetaphorTree();
    private BorderLayout borderLayout7 = new BorderLayout();
    private ImageIcon openMetaphorIcon;
    private ImageIcon saveMetaphorIcon;
    private ImageIcon diagnosticMetaphorIcon;
    private ImageIcon openMetaphorRollOverIcon;
    private ImageIcon saveMetaphorRollOverIcon;
    private ImageIcon diagnosticMetaphorRollOverIcon;
    private ProbabilisticNetwork net = null;
    private JFileChooser fileChooser;
    private TitledBorder titledBorder1;
    private Border border1;
    private Border border2;
    private Border border3;
    private JTextArea jTextArea5 = new JTextArea();
    private BorderLayout borderLayout9 = new BorderLayout();
    private BorderLayout borderLayout12 = new BorderLayout();
    private BorderLayout borderLayout11 = new BorderLayout();
    private JPanel jPanel9 = new JPanel();
    private JLabel jLabel3 = new JLabel();
    private JPanel jPanel11 = new JPanel();
    private JPanel jPanel10 = new JPanel();
    private BorderLayout borderLayout14 = new BorderLayout();
    private BorderLayout borderLayout13 = new BorderLayout();
    private BorderLayout borderLayout10 = new BorderLayout();
    private JLabel jLabel4 = new JLabel();
    private JPanel jPanel13 = new JPanel();
    private JPanel jPanel8 = new JPanel();
    private JPanel jPanel12 = new JPanel();
    private JTextArea jTextArea6 = new JTextArea();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private MetaphorResult metaphorResult = new MetaphorResult();

    public MetaphorMainPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        IconController iconController = IconController.getInstance();
        this.openMetaphorIcon = iconController.getOpenMetaphorIcon();
        this.saveMetaphorIcon = iconController.getSaveMetaphorIcon();
        this.diagnosticMetaphorIcon = iconController.getDiagnosticMetaphorIcon();
        this.openMetaphorRollOverIcon = iconController.getOpenMetaphorRollOverIcon();
        this.saveMetaphorRollOverIcon = iconController.getSaveMetaphorRollOverIcon();
        this.diagnosticMetaphorRollOverIcon = iconController.getDiagnosticMetaphorRollOverIcon();
        this.titledBorder1 = new TitledBorder("");
        this.border1 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.border2 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.border3 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.setLayout(this.borderLayout1);
        this.statusPanel.setLayout(this.borderLayout2);
        this.statusPanel.setBorder(new TitledBorder("Status"));
        this.statusBar.setToolTipText("");
        this.statusBar.setText("Welcome");
        this.metaphorToolBar.setFloatable(false);
        this.jTabbedPane1.setOpaque(true);
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.jPanel3.setLayout(this.borderLayout7);
        this.openButton.setBorder(this.border1);
        this.openButton.setIcon(this.openMetaphorIcon);
        this.openButton.setRolloverIcon(this.openMetaphorRollOverIcon);
        this.openButton.setPressedIcon(this.openMetaphorRollOverIcon);
        this.openButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MetaphorMainPanel.this.openButton_actionPerformed(e);
            }
        });
        this.saveButton.setBorder(this.border2);
        this.saveButton.setIcon(this.saveMetaphorIcon);
        this.saveButton.setRolloverIcon(this.saveMetaphorRollOverIcon);
        this.saveButton.setPressedIcon(this.saveMetaphorRollOverIcon);
        this.diagnosticButton.setBorder(this.border3);
        this.diagnosticButton.setIcon(this.diagnosticMetaphorIcon);
        this.diagnosticButton.setRolloverIcon(this.diagnosticMetaphorRollOverIcon);
        this.diagnosticButton.setPressedIcon(this.diagnosticMetaphorRollOverIcon);
        this.diagnosticButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MetaphorMainPanel.this.diagnosticButton_actionPerformed(e);
            }
        });
        this.jPanel3.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jTextArea5.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jTextArea5.setEditable(false);
        this.jPanel9.setLayout(this.borderLayout9);
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText("Caracter\u00edsticas da Vari\u00e1vel Atual");
        this.jPanel11.setLayout(this.borderLayout11);
        this.jPanel10.setLayout(this.borderLayout12);
        this.jLabel4.setHorizontalAlignment(0);
        this.jLabel4.setText("Evid\u00eancias");
        this.jPanel13.setLayout(this.borderLayout13);
        this.jPanel8.setLayout(this.borderLayout10);
        this.jPanel12.setLayout(this.borderLayout14);
        this.jTextArea6.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jTextArea6.setEditable(false);
        this.add((Component)this.metaphorToolBar, "North");
        this.metaphorToolBar.add((Component)this.openButton, null);
        this.metaphorToolBar.add((Component)this.saveButton, null);
        this.metaphorToolBar.add((Component)this.diagnosticButton, null);
        this.add((Component)this.jTabbedPane1, "Center");
        this.add((Component)this.statusPanel, "South");
        this.statusPanel.add((Component)this.statusBar, "North");
        this.jTabbedPane1.add((Component)this.jPanel1, "Entrada de evidencias");
        this.jTabbedPane1.add((Component)this.metaphorResult, "Laudo");
        this.jPanel1.add((Component)this.jPanel3, new GridBagConstraints(0, 0, 3, 4, 30.0, 30.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jPanel9, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel9.add((Component)this.jPanel10, "Center");
        this.jPanel10.add((Component)this.jTextArea5, "Center");
        this.jPanel9.add((Component)this.jPanel11, "North");
        this.jPanel11.add((Component)this.jLabel3, "Center");
        this.jPanel1.add((Component)this.jPanel8, new GridBagConstraints(3, 1, 1, 3, 2.0, 2.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel8.add((Component)this.jPanel12, "Center");
        this.jPanel12.add((Component)this.jTextArea6, "Center");
        this.jPanel8.add((Component)this.jPanel13, "North");
        this.jPanel13.add((Component)this.jLabel4, "Center");
        this.metaphorResult.setExplanationNodes(null);
    }

    void diagnosticButton_actionPerformed(ActionEvent e) {
        this.jTabbedPane1.setSelectedIndex(1);
        this.metaphorTree.propagate();
        this.metaphorResult.updateResults();
    }

    void openButton_actionPerformed(ActionEvent e) {
        this.setCursor(new Cursor(3));
        String[] s1 = new String[]{"net", "xml"};
        this.fileChooser = new JFileChooser(FileController.getInstance().getCurrentDirectory());
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setFileView(new FileIcon(this));
        this.fileChooser.addChoosableFileFilter(new SimpleFileFilter(s1, "Networks (*.net) or XML-BIF(*.xml)"));
        int returnVal = this.fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File selectedFile = this.fileChooser.getSelectedFile();
            this.openFile(selectedFile);
            FileController.getInstance().setCurrentDirectory(this.fileChooser.getCurrentDirectory());
        }
        this.setCursor(new Cursor(0));
    }

    private void openFile(File selectedFile) {
        try {
            String name = selectedFile.getName().toLowerCase();
            if (name.endsWith("net")) {
                this.net = new NetIO().load(selectedFile);
            } else if (name.endsWith("xml")) {
                this.net = new XMLBIFIO().load(selectedFile);
            }
            this.net.compile();
            this.metaphorResult.setExplanationNodes(this.net.getExplanationNodes());
            this.metaphorTree = new MetaphorTree();
            this.metaphorTree.setProbabilisticNetwork(this.net);
            this.metaphorTree.expandTree();
            JScrollPane jScrollPane3 = new JScrollPane(this.metaphorTree);
            this.jPanel3.removeAll();
            this.jPanel3.add((Component)jScrollPane3, "Center");
            this.jPanel3.updateUI();
            this.jTabbedPane1.setSelectedIndex(0);
            this.statusBar.setText("File opened successfully");
        }
        catch (Exception e) {
            this.net = null;
            System.err.print(e.getMessage());
            this.statusBar.setText(e.getMessage());
        }
    }
}

