/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.io.mebn;

import edu.stanford.smi.protegex.owl.ProtegeOWL;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import unbbayes.io.mebn.PROWLModelUser;
import unbbayes.io.mebn.exceptions.IOMebnException;
import unbbayes.prs.mebn.BuiltInRV;
import unbbayes.prs.mebn.ContextNode;
import unbbayes.prs.mebn.InputNode;
import unbbayes.prs.mebn.MFrag;
import unbbayes.prs.mebn.MultiEntityBayesianNetwork;
import unbbayes.prs.mebn.MultiEntityNode;
import unbbayes.prs.mebn.OrdinaryVariable;
import unbbayes.prs.mebn.ResidentNode;
import unbbayes.prs.mebn.ResidentNodePointer;
import unbbayes.prs.mebn.context.EnumSubType;
import unbbayes.prs.mebn.context.EnumType;
import unbbayes.prs.mebn.context.NodeFormulaTree;
import unbbayes.prs.mebn.entity.BooleanStateEntity;
import unbbayes.prs.mebn.entity.CategoricalStateEntity;
import unbbayes.prs.mebn.entity.Entity;
import unbbayes.prs.mebn.entity.ObjectEntity;
import unbbayes.prs.mebn.entity.ObjectEntityInstance;
import unbbayes.prs.mebn.entity.StateLink;
import unbbayes.util.Debug;

public class SaverPrOwlIO
extends PROWLModelUser {
    private HashMap<String, OWLIndividual> mapBuiltInOwlIndividual = new HashMap();
    private HashMap<String, OWLIndividual> mapMetaEntity = new HashMap();
    private HashMap<Entity, OWLIndividual> mapCategoricalStates = new HashMap();
    private HashMap<ObjectEntity, OWLNamedClass> mapObjectEntityClasses = new HashMap();
    private HashMap<BooleanStateEntity, OWLIndividual> mapBooleanStatesEntity = new HashMap();
    private HashMap<MFrag, OWLIndividual> mapMFrag = new HashMap();
    private HashMap<OrdinaryVariable, OWLIndividual> mapOrdinaryVariable = new HashMap();
    private HashMap<ContextNode, OWLIndividual> mapContext = new HashMap();
    private HashMap<InputNode, OWLIndividual> mapGenerativeInput = new HashMap();
    private HashMap<ResidentNode, OWLIndividual> mapDomainResident = new HashMap();
    private ArrayList<ContextNode> auxContextNodeList = new ArrayList();
    private JenaOWLModel owlModel = null;
    private static final String SCOPE_SEPARATOR = ".";
    private static final String NUMBER_SEPARATOR = "_";
    private static final String META_ENTITY_SUFIX = "_Label";
    private static final String DECLARATIVE_DISTRO_SUFIX = "_Table";
    private static final String INNER_SUFIX = "_Inner";
    private MultiEntityBayesianNetwork mebn;
    private final ResourceBundle resource = ResourceBundle.getBundle("unbbayes.io.mebn.resources.IoMebnResources");

    public void saveMebn(File file, MultiEntityBayesianNetwork _mebn) throws IOException, IOMebnException {
        this.mebn = _mebn;
        if (this.owlModel == null) {
            this.owlModel = ProtegeOWL.createJenaOWLModel();
            this.loadPrOwlModel(this.owlModel);
            Debug.println("-> Model pr-owl load sucess ");
        }
        this.loadMetaEntities();
        this.loadObjectEntitiesClasses();
        this.loadBooleanRVStates();
        this.loadCategoricalStates();
        this.loadBuiltInRV();
        Debug.println("-> Definitions load sucess ");
        this.loadMTheory();
        Debug.println("-> MTheory load sucess ");
        this.loadDomainResidentNodes();
        Debug.println("-> Domain Resident Nodes load sucess ");
        this.loadContextNode();
        Debug.println("-> Context Node load sucess ");
        this.loadGenerativeInputNode();
        Debug.println("-> Generative Input Node load sucess ");
        this.loadEntityIndividuals();
        Debug.println("-> Entity Individuals load sucess ");
        this.clearAuxiliaryLists();
        ArrayList errors = new ArrayList();
        this.owlModel.save(file.toURI(), "RDF/XML-ABBREV", errors);
        Debug.println("File saved with " + errors.size() + " errors.");
        for (String error : errors) {
            Debug.println(" > " + error);
        }
        Debug.println("\n");
    }

    public void saveMebn(File file, MultiEntityBayesianNetwork _mebn, OWLModel owlmodel) throws IOException, IOMebnException {
        this.setOWLModelToUse(owlmodel);
        this.saveMebn(file, _mebn);
    }

    private void loadMetaEntities() {
        ArrayList<String> metaEntitiesDefault = new ArrayList<String>();
        OWLNamedClass metaEntityClass = this.owlModel.getOWLNamedClass("MetaEntity");
        Collection instances = metaEntityClass.getInstances(false);
        OWLIndividual rootLabel = null;
        for (Object instance : instances) {
            OWLIndividual metaEntityInstance = (OWLIndividual)instance;
            this.mapMetaEntity.put(metaEntityInstance.getBrowserText(), metaEntityInstance);
            metaEntitiesDefault.add(metaEntityInstance.getBrowserText());
            if (!metaEntityInstance.getName().equals("TypeLabel")) continue;
            rootLabel = metaEntityInstance;
        }
        if (rootLabel == null) {
            Debug.println("Error: the meta entity TypeLabel don't exists in the model");
        }
        List<String> listMetaEntities = this.mebn.getTypeContainer().getTypesNames();
        for (String state : listMetaEntities) {
            if (metaEntitiesDefault.contains(state)) continue;
            OWLIndividual stateIndividual = metaEntityClass.createOWLIndividual(state);
            stateIndividual.addPropertyValue((RDFProperty)this.owlModel.getOWLObjectProperty("hasType"), (Object)rootLabel);
            stateIndividual.setPropertyValue((RDFProperty)this.owlModel.getOWLDatatypeProperty("hasUID"), (Object)("!" + state));
            this.mapMetaEntity.put(state, stateIndividual);
        }
    }

    private void loadBooleanRVStates() {
        OWLNamedClass booleanRVStates = this.owlModel.getOWLNamedClass("BooleanRVState");
        Collection instances = booleanRVStates.getInstances(false);
        for (Object instance : instances) {
            OWLIndividual stateOwl = (OWLIndividual)instance;
            if (stateOwl.getBrowserText().equals("true")) {
                this.mapBooleanStatesEntity.put(this.mebn.getBooleanStatesEntityContainer().getTrueStateEntity(), stateOwl);
                continue;
            }
            if (stateOwl.getBrowserText().equals("false")) {
                this.mapBooleanStatesEntity.put(this.mebn.getBooleanStatesEntityContainer().getFalseStateEntity(), stateOwl);
                continue;
            }
            if (!stateOwl.getBrowserText().equals("absurd")) continue;
            this.mapBooleanStatesEntity.put(this.mebn.getBooleanStatesEntityContainer().getAbsurdStateEntity(), stateOwl);
        }
    }

    private void loadCategoricalStates() {
        OWLNamedClass categoricalStateClass = this.owlModel.getOWLNamedClass("CategoricalRVState");
        OWLObjectProperty hasType = this.owlModel.getOWLObjectProperty("hasType");
        OWLIndividual categoryLabel = this.mapMetaEntity.get("CategoryLabel");
        for (CategoricalStateEntity entity : this.mebn.getCategoricalStatesEntityContainer().getListEntity()) {
            if (entity.getName().equals("absurd")) continue;
            OWLIndividual categoricalStateIndividual = categoricalStateClass.createOWLIndividual(entity.getName());
            categoricalStateIndividual.addPropertyValue((RDFProperty)hasType, (Object)categoryLabel);
            this.mapCategoricalStates.put(entity, categoricalStateIndividual);
        }
    }

    private void loadBuiltInRV() {
        OWLNamedClass builtInPr = this.owlModel.getOWLNamedClass("BuiltInRV");
        Collection instances = builtInPr.getInstances(false);
        for (OWLIndividual individualOne : instances) {
            this.mapBuiltInOwlIndividual.put(individualOne.getBrowserText(), individualOne);
        }
    }

    private void loadObjectEntitiesClasses() {
        OWLNamedClass entityClass = this.owlModel.getOWLNamedClass("ObjectEntity");
        for (ObjectEntity entity : this.mebn.getObjectEntityContainer().getListEntity()) {
            OWLNamedClass newEntityClass = this.owlModel.createOWLNamedSubclass(entity.getName(), entityClass);
            this.mapObjectEntityClasses.put(entity, newEntityClass);
        }
    }

    private void loadMTheory() {
        OWLNamedClass mTheoryClass = this.owlModel.getOWLNamedClass("MTheory");
        OWLIndividual mTheoryIndividual = mTheoryClass.createOWLIndividual(this.mebn.getName());
        Debug.println("MTheory = " + this.mebn.getName());
        if (this.mebn.getDescription() != null) {
            mTheoryIndividual.addComment(this.mebn.getDescription());
        }
        OWLObjectProperty hasMFragProperty = this.owlModel.getOWLObjectProperty("hasMFrag");
        List<MFrag> listDomainMFrag = this.mebn.getDomainMFragList();
        for (MFrag domainMFrag : listDomainMFrag) {
            OWLNamedClass domainMFragClass = this.owlModel.getOWLNamedClass("Domain_MFrag");
            Debug.println("Domain_MFrag = " + domainMFrag.getName());
            OWLIndividual domainMFragIndividual = domainMFragClass.createOWLIndividual(domainMFrag.getName());
            this.mapMFrag.put(domainMFrag, domainMFragIndividual);
            mTheoryIndividual.addPropertyValue((RDFProperty)hasMFragProperty, (Object)domainMFragIndividual);
            if (domainMFrag.getDescription() != null) {
                domainMFragIndividual.addComment(domainMFrag.getDescription());
            }
            OWLObjectProperty hasResidentNodeProperty = this.owlModel.getOWLObjectProperty("hasResidentNode");
            OWLNamedClass domainResClass = this.owlModel.getOWLNamedClass("Domain_Res");
            for (ResidentNode residentNode : domainMFrag.getResidentNodeList()) {
                Debug.println("Domain_Res = " + residentNode.getName());
                OWLIndividual domainResIndividual = domainResClass.createOWLIndividual(residentNode.getName());
                domainMFragIndividual.addPropertyValue((RDFProperty)hasResidentNodeProperty, (Object)domainResIndividual);
                this.mapDomainResident.put(residentNode, domainResIndividual);
            }
            OWLObjectProperty hasInputNodeProperty = this.owlModel.getOWLObjectProperty("hasInputNode");
            OWLNamedClass generativeInputClass = this.owlModel.getOWLNamedClass("Generative_input");
            for (InputNode inputNode : domainMFrag.getInputNodeList()) {
                Debug.println("Generative_input = " + inputNode.getName());
                OWLIndividual generativeInputIndividual = generativeInputClass.createOWLIndividual(inputNode.getName());
                domainMFragIndividual.addPropertyValue((RDFProperty)hasInputNodeProperty, (Object)generativeInputIndividual);
                this.mapGenerativeInput.put(inputNode, generativeInputIndividual);
            }
            OWLObjectProperty hasContextNodeProperty = this.owlModel.getOWLObjectProperty("hasContextNode");
            OWLNamedClass contextClass = this.owlModel.getOWLNamedClass("Context");
            for (ContextNode contextNode : domainMFrag.getContextNodeList()) {
                OWLIndividual contextIndividual = contextClass.createOWLIndividual(contextNode.getName());
                domainMFragIndividual.addPropertyValue((RDFProperty)hasContextNodeProperty, (Object)contextIndividual);
                this.mapContext.put(contextNode, contextIndividual);
            }
            OWLObjectProperty hasOVariableProperty = this.owlModel.getOWLObjectProperty("hasOVariable");
            OWLNamedClass oVariableClass = this.owlModel.getOWLNamedClass("OVariable");
            OWLObjectProperty isSubsByProperty = this.owlModel.getOWLObjectProperty("isSubsBy");
            for (OrdinaryVariable oVariable : domainMFrag.getOrdinaryVariableList()) {
                OWLIndividual oVariableIndividual = oVariableClass.createOWLIndividual(String.valueOf(oVariable.getMFrag().getName()) + SCOPE_SEPARATOR + oVariable.getName());
                domainMFragIndividual.addPropertyValue((RDFProperty)hasOVariableProperty, (Object)oVariableIndividual);
                if (oVariable.getValueType() != null) {
                    oVariableIndividual.addPropertyValue((RDFProperty)isSubsByProperty, (Object)this.mapMetaEntity.get(oVariable.getValueType().getName()));
                }
                if (oVariable.getDescription() != null) {
                    oVariableIndividual.addComment(oVariable.getDescription());
                }
                this.mapOrdinaryVariable.put(oVariable, oVariableIndividual);
            }
        }
    }

    private void loadDomainResidentNodes() {
        for (MFrag mfrag : this.mebn.getDomainMFragList()) {
            for (ResidentNode residentNode : mfrag.getResidentNodeList()) {
                OWLIndividual domainResIndividual = this.mapDomainResident.get(residentNode);
                Debug.println("Verifying arguments");
                List<OrdinaryVariable> ordVariableList = residentNode.getOrdinaryVariableList();
                int argumentNumber = 1;
                for (OrdinaryVariable argument : ordVariableList) {
                    this.saveSimpleArgRelationship(argument, domainResIndividual, residentNode.getName(), argumentNumber);
                    ++argumentNumber;
                }
                Debug.println("Verifying parents");
                OWLObjectProperty hasParentProperty = this.owlModel.getOWLObjectProperty("hasParent");
                for (ResidentNode residentNodeFather : residentNode.getResidentNodeFatherList()) {
                    OWLIndividual residentNodeFatherIndividual = this.mapDomainResident.get(residentNodeFather);
                    domainResIndividual.addPropertyValue((RDFProperty)hasParentProperty, (Object)residentNodeFatherIndividual);
                }
                for (InputNode inputNodeFather : residentNode.getInputNodeFatherList()) {
                    OWLIndividual inputNodeFatherIndividual = this.mapGenerativeInput.get(inputNodeFather);
                    domainResIndividual.addPropertyValue((RDFProperty)hasParentProperty, (Object)inputNodeFatherIndividual);
                }
                Debug.println("Verifying possible values");
                this.loadResidentPossibleValues(domainResIndividual, residentNode);
                Debug.println("Verifying input instances");
                OWLObjectProperty hasInputInstanceProperty = this.owlModel.getOWLObjectProperty("hasInputInstance");
                for (InputNode inputInstance : residentNode.getInputInstanceFromList()) {
                    OWLIndividual inputInstanceIndividual = this.mapGenerativeInput.get(inputInstance);
                    if (inputInstanceIndividual == null) continue;
                    domainResIndividual.addPropertyValue((RDFProperty)hasInputInstanceProperty, (Object)inputInstanceIndividual);
                }
                Debug.println("Verifying probability distros");
                OWLObjectProperty hasProbDist = this.owlModel.getOWLObjectProperty("hasProbDist");
                OWLNamedClass declarativeDist = this.owlModel.getOWLNamedClass("DeclarativeDist");
                OWLIndividual declarativeDistThisNode = declarativeDist.createOWLIndividual(String.valueOf(residentNode.getName()) + DECLARATIVE_DISTRO_SUFIX);
                OWLDatatypeProperty hasDeclaration = this.owlModel.getOWLDatatypeProperty("hasDeclaration");
                if (residentNode.getTableFunction() != null) {
                    declarativeDistThisNode.addPropertyValue((RDFProperty)hasDeclaration, (Object)residentNode.getTableFunction());
                    domainResIndividual.addPropertyValue((RDFProperty)hasProbDist, (Object)declarativeDistThisNode);
                }
                if (residentNode.getDescription() == null) continue;
                domainResIndividual.addComment(residentNode.getDescription());
            }
        }
    }

    private void loadResidentPossibleValues(OWLIndividual residentNodeIndividual, ResidentNode node) {
        OWLObjectProperty hasPossibleValues = this.owlModel.getOWLObjectProperty("hasPossibleValues");
        OWLObjectProperty isGloballyExclusive = this.owlModel.getOWLObjectProperty("isGloballyExclusive");
        for (StateLink stateLink : node.getPossibleValueLinkList()) {
            OWLIndividual owlState;
            Entity state = stateLink.getState();
            if (state instanceof CategoricalStateEntity) {
                owlState = this.mapCategoricalStates.get(state);
                residentNodeIndividual.addPropertyValue((RDFProperty)hasPossibleValues, (Object)owlState);
                if (!stateLink.isGloballyExclusive()) continue;
                owlState.addPropertyValue((RDFProperty)isGloballyExclusive, (Object)residentNodeIndividual);
                continue;
            }
            if (state instanceof BooleanStateEntity) {
                owlState = this.mapBooleanStatesEntity.get(state);
                residentNodeIndividual.addPropertyValue((RDFProperty)hasPossibleValues, (Object)owlState);
                if (!stateLink.isGloballyExclusive()) continue;
                owlState.addPropertyValue((RDFProperty)isGloballyExclusive, (Object)residentNodeIndividual);
                continue;
            }
            if (state instanceof ObjectEntity) {
                owlState = this.mapMetaEntity.get(((ObjectEntity)state).getType().getName());
                residentNodeIndividual.addPropertyValue((RDFProperty)hasPossibleValues, (Object)owlState);
                if (!stateLink.isGloballyExclusive()) continue;
                owlState.addPropertyValue((RDFProperty)isGloballyExclusive, (Object)residentNodeIndividual);
                continue;
            }
            Debug.print("Error: Invalid State - " + state.getName());
        }
    }

    private void saveSimpleArgRelationship(OrdinaryVariable argument, OWLIndividual individual, String name, int argNumber) {
        OWLObjectProperty hasArgumentProperty = this.owlModel.getOWLObjectProperty("hasArgument");
        OWLNamedClass argumentClass = this.owlModel.getOWLNamedClass("SimpleArgRelationship");
        OWLIndividual argumentIndividual = argumentClass.createOWLIndividual(String.valueOf(name) + NUMBER_SEPARATOR + argNumber);
        individual.addPropertyValue((RDFProperty)hasArgumentProperty, (Object)argumentIndividual);
        OWLObjectProperty hasArgTerm = this.owlModel.getOWLObjectProperty("hasArgTerm");
        if (argument != null) {
            OWLIndividual oVariableIndividual = this.mapOrdinaryVariable.get(argument);
            argumentIndividual.addPropertyValue((RDFProperty)hasArgTerm, (Object)oVariableIndividual);
        }
        OWLDatatypeProperty hasArgNumber = this.owlModel.getOWLDatatypeProperty("hasArgNumber");
        argumentIndividual.setPropertyValue((RDFProperty)hasArgNumber, (Object)argNumber);
    }

    private void loadGenerativeInputNode() {
        for (MFrag mfrag : this.mebn.getDomainMFragList()) {
            for (InputNode generativeInputNode : mfrag.getInputNodeList()) {
                OWLIndividual generativeInputNodeIndividual = this.mapGenerativeInput.get(generativeInputNode);
                if (generativeInputNode.getInputInstanceOf() != null && generativeInputNode.getInputInstanceOf() instanceof ResidentNode) {
                    ResidentNodePointer pointer = generativeInputNode.getResidentNodePointer();
                    OrdinaryVariable[] ovArray = pointer.getOrdinaryVariableArray();
                    int i = 0;
                    while (i < ovArray.length) {
                        this.saveSimpleArgRelationship(ovArray[i], generativeInputNodeIndividual, generativeInputNode.getName(), i + 1);
                        ++i;
                    }
                }
                if (generativeInputNode.getInputInstanceOf() != null && generativeInputNode.getInputInstanceOf() instanceof ResidentNode) {
                    ResidentNode residentNode = (ResidentNode)generativeInputNode.getInputInstanceOf();
                    for (Entity state : residentNode.getPossibleValueList()) {
                        this.loadInputPossibleValues(generativeInputNodeIndividual, residentNode);
                    }
                }
                if (generativeInputNode.getDescription() == null) continue;
                generativeInputNodeIndividual.addComment(generativeInputNode.getDescription());
            }
        }
    }

    private void loadInputPossibleValues(OWLIndividual nodeIndividual, ResidentNode node) {
        OWLObjectProperty hasPossibleValues = this.owlModel.getOWLObjectProperty("hasPossibleValues");
        for (Entity state : node.getPossibleValueList()) {
            if (state instanceof CategoricalStateEntity) {
                OWLIndividual stateIndividual = this.mapCategoricalStates.get(state);
                nodeIndividual.addPropertyValue((RDFProperty)hasPossibleValues, (Object)stateIndividual);
                continue;
            }
            if (state instanceof BooleanStateEntity) {
                nodeIndividual.addPropertyValue((RDFProperty)hasPossibleValues, (Object)this.mapBooleanStatesEntity.get(state));
                continue;
            }
            if (state instanceof ObjectEntity) {
                nodeIndividual.addPropertyValue((RDFProperty)hasPossibleValues, (Object)this.mapMetaEntity.get(((ObjectEntity)state).getType().getName()));
                continue;
            }
            Debug.print("Error: Invalid State - " + state.getName());
        }
    }

    private void loadContextNode() {
        for (MFrag mfrag : this.mebn.getDomainMFragList()) {
            for (ContextNode contextNode : mfrag.getContextNodeList()) {
                OWLIndividual contextNodeIndividual = this.mapContext.get(contextNode);
                NodeFormulaTree formulaNode = contextNode.getFormulaTree();
                if (formulaNode != null) {
                    this.loadContextNodeFormula(formulaNode, contextNodeIndividual, contextNode);
                }
                this.saveContextPossibleValues(contextNodeIndividual, contextNode);
                if (contextNode.getDescription() == null) continue;
                contextNodeIndividual.addComment(contextNode.getDescription());
            }
        }
    }

    private void saveCategoricalStateArgRelationship(CategoricalStateEntity argument, OWLIndividual individual, String name, int argNumber) {
        OWLObjectProperty hasArgumentProperty = this.owlModel.getOWLObjectProperty("hasArgument");
        OWLNamedClass argumentClass = this.owlModel.getOWLNamedClass("ArgRelationship");
        OWLIndividual argumentIndividual = argumentClass.createOWLIndividual(String.valueOf(name) + NUMBER_SEPARATOR + argNumber);
        individual.addPropertyValue((RDFProperty)hasArgumentProperty, (Object)argumentIndividual);
        OWLObjectProperty hasArgTerm = this.owlModel.getOWLObjectProperty("hasArgTerm");
        if (argument != null) {
            OWLIndividual categoricalStateIndividual = this.mapCategoricalStates.get(argument);
            argumentIndividual.addPropertyValue((RDFProperty)hasArgTerm, (Object)categoricalStateIndividual);
        }
        OWLDatatypeProperty hasArgNumber = this.owlModel.getOWLDatatypeProperty("hasArgNumber");
        argumentIndividual.setPropertyValue((RDFProperty)hasArgNumber, (Object)argNumber);
    }

    private void saveBooleanArgRelationship(BooleanStateEntity argument, OWLIndividual individual, String name, int argNumber) {
        OWLObjectProperty hasArgumentProperty = this.owlModel.getOWLObjectProperty("hasArgument");
        OWLNamedClass argumentClass = this.owlModel.getOWLNamedClass("ArgRelationship");
        OWLIndividual argumentIndividual = argumentClass.createOWLIndividual(String.valueOf(name) + NUMBER_SEPARATOR + argNumber);
        individual.addPropertyValue((RDFProperty)hasArgumentProperty, (Object)argumentIndividual);
        OWLObjectProperty hasArgTerm = this.owlModel.getOWLObjectProperty("hasArgTerm");
        if (argument != null) {
            OWLIndividual booleanStateIndividual = this.mapBooleanStatesEntity.get(argument);
            argumentIndividual.addPropertyValue((RDFProperty)hasArgTerm, (Object)booleanStateIndividual);
        }
        OWLDatatypeProperty hasArgNumber = this.owlModel.getOWLDatatypeProperty("hasArgNumber");
        argumentIndividual.setPropertyValue((RDFProperty)hasArgNumber, (Object)argNumber);
    }

    private void saveBuiltInArgRelationship(OWLIndividual individual, MultiEntityNode node, int argNumber, NodeFormulaTree root) {
        OWLObjectProperty hasArgumentProperty = this.owlModel.getOWLObjectProperty("hasArgument");
        OWLNamedClass argumentClass = this.owlModel.getOWLNamedClass("ArgRelationship");
        OWLIndividual argumentIndividual = argumentClass.createOWLIndividual(String.valueOf(node.getName()) + NUMBER_SEPARATOR + argNumber);
        individual.addPropertyValue((RDFProperty)hasArgumentProperty, (Object)argumentIndividual);
        OWLDatatypeProperty hasArgNumber = this.owlModel.getOWLDatatypeProperty("hasArgNumber");
        argumentIndividual.setPropertyValue((RDFProperty)hasArgNumber, (Object)argNumber);
        OWLNamedClass contextNodeClass = this.owlModel.getOWLNamedClass("Context");
        String innerContextName = String.valueOf(node.getName()) + NUMBER_SEPARATOR + argNumber + INNER_SUFIX;
        OWLIndividual innerContextNode = contextNodeClass.createOWLIndividual(innerContextName);
        ContextNode contextAux = new ContextNode(innerContextName, node.getMFrag());
        this.auxContextNodeList.add(contextAux);
        OWLObjectProperty isInnerTermOf = this.owlModel.getOWLObjectProperty("isInnerTermOf");
        innerContextNode.addPropertyValue((RDFProperty)isInnerTermOf, (Object)individual);
        OWLObjectProperty isContextNodeIn = this.owlModel.getOWLObjectProperty("isContextNodeIn");
        innerContextNode.addPropertyValue((RDFProperty)isContextNodeIn, (Object)this.mapMFrag.get(node.getMFrag()));
        this.loadContextNodeFormula(root, innerContextNode, contextAux);
        OWLObjectProperty hasArgTerm = this.owlModel.getOWLObjectProperty("hasArgTerm");
        argumentIndividual.addPropertyValue((RDFProperty)hasArgTerm, (Object)innerContextNode);
    }

    private void saveEmptySimpleArgRelationship(OWLIndividual individual, String name, int argNumber) {
        OWLObjectProperty hasArgumentProperty = this.owlModel.getOWLObjectProperty("hasArgument");
        OWLNamedClass argumentClass = this.owlModel.getOWLNamedClass("SimpleArgRelationship");
        OWLIndividual argumentIndividual = argumentClass.createOWLIndividual(String.valueOf(name) + NUMBER_SEPARATOR + argNumber);
        individual.addPropertyValue((RDFProperty)hasArgumentProperty, (Object)argumentIndividual);
        OWLDatatypeProperty hasArgNumber = this.owlModel.getOWLDatatypeProperty("hasArgNumber");
        argumentIndividual.setPropertyValue((RDFProperty)hasArgNumber, (Object)argNumber);
    }

    private void saveResidentNodeArgRelationship(ResidentNodePointer argument, OWLIndividual individual, MultiEntityNode node, int argNumber) {
        OWLObjectProperty hasArgumentProperty = this.owlModel.getOWLObjectProperty("hasArgument");
        OWLNamedClass argumentClass = this.owlModel.getOWLNamedClass("ArgRelationship");
        OWLIndividual argumentIndividual = argumentClass.createOWLIndividual(String.valueOf(node.getName()) + NUMBER_SEPARATOR + argNumber);
        individual.addPropertyValue((RDFProperty)hasArgumentProperty, (Object)argumentIndividual);
        OWLDatatypeProperty hasArgNumber = this.owlModel.getOWLDatatypeProperty("hasArgNumber");
        argumentIndividual.setPropertyValue((RDFProperty)hasArgNumber, (Object)argNumber);
        OWLNamedClass contextNodeClass = this.owlModel.getOWLNamedClass("Context");
        OWLIndividual innerContextNode = contextNodeClass.createOWLIndividual(String.valueOf(node.getName()) + NUMBER_SEPARATOR + argNumber + "_inner");
        OWLObjectProperty isInnerTermOf = this.owlModel.getOWLObjectProperty("isInnerTermOf");
        innerContextNode.addPropertyValue((RDFProperty)isInnerTermOf, (Object)individual);
        OWLObjectProperty isContextNodeIn = this.owlModel.getOWLObjectProperty("isContextNodeIn");
        innerContextNode.addPropertyValue((RDFProperty)isContextNodeIn, (Object)this.mapMFrag.get(node.getMFrag()));
        OWLObjectProperty isContextInstanceOf = this.owlModel.getOWLObjectProperty("isContextInstanceOf");
        innerContextNode.addPropertyValue((RDFProperty)isContextInstanceOf, (Object)this.mapDomainResident.get(argument.getResidentNode()));
        this.loadResidentPossibleValues(innerContextNode, argument.getResidentNode());
        OrdinaryVariable[] oVariableArray = argument.getOrdinaryVariableArray();
        int i = 0;
        while (i < oVariableArray.length) {
            if (oVariableArray[i] == null) {
                this.saveEmptySimpleArgRelationship(innerContextNode, innerContextNode.getName(), i + 1);
            } else {
                this.saveSimpleArgRelationship(oVariableArray[i], innerContextNode, innerContextNode.getName(), i + 1);
            }
            ++i;
        }
        OWLObjectProperty hasArgTerm = this.owlModel.getOWLObjectProperty("hasArgTerm");
        argumentIndividual.addPropertyValue((RDFProperty)hasArgTerm, (Object)innerContextNode);
    }

    private void loadContextNodeFormula(NodeFormulaTree _formulaNode, OWLIndividual contextNodeIndividual, ContextNode contextNode) {
        block16: {
            NodeFormulaTree formulaNode;
            block15: {
                formulaNode = _formulaNode;
                if (formulaNode.getTypeNode() != EnumType.SIMPLE_OPERATOR && formulaNode.getTypeNode() != EnumType.QUANTIFIER_OPERATOR) break block15;
                if (!(formulaNode.getNodeVariable() instanceof BuiltInRV)) break block16;
                OWLObjectProperty isContextInstanceOf = this.owlModel.getOWLObjectProperty("isContextInstanceOf");
                OWLIndividual builtInIndividual = this.mapBuiltInOwlIndividual.get(((BuiltInRV)formulaNode.getNodeVariable()).getName());
                contextNodeIndividual.setPropertyValue((RDFProperty)isContextInstanceOf, (Object)builtInIndividual);
                List<NodeFormulaTree> childrenList = formulaNode.getChildren();
                int argNumber = 0;
                block6: for (NodeFormulaTree child : childrenList) {
                    ++argNumber;
                    if (child.getTypeNode() == EnumType.OPERAND) {
                        switch (child.getSubTypeNode()) {
                            case NOTHING: {
                                this.saveEmptySimpleArgRelationship(contextNodeIndividual, contextNode.getName(), argNumber);
                                break;
                            }
                            case OVARIABLE: {
                                this.saveSimpleArgRelationship((OrdinaryVariable)child.getNodeVariable(), contextNodeIndividual, contextNode.getName(), argNumber);
                                break;
                            }
                            case NODE: {
                                if (!(child.getNodeVariable() instanceof ResidentNodePointer)) continue block6;
                                this.saveResidentNodeArgRelationship((ResidentNodePointer)child.getNodeVariable(), contextNodeIndividual, contextNode, argNumber);
                                break;
                            }
                            case ENTITY: {
                                if (child.getNodeVariable() instanceof CategoricalStateEntity) {
                                    this.saveCategoricalStateArgRelationship((CategoricalStateEntity)child.getNodeVariable(), contextNodeIndividual, contextNode.getName(), argNumber);
                                    break;
                                }
                                if (!(child.getNodeVariable() instanceof BooleanStateEntity)) continue block6;
                                this.saveBooleanArgRelationship((BooleanStateEntity)child.getNodeVariable(), contextNodeIndividual, contextNode.getName(), argNumber);
                                break;
                            }
                            default: {
                                this.saveEmptySimpleArgRelationship(contextNodeIndividual, contextNode.getName(), argNumber);
                                break;
                            }
                        }
                        continue;
                    }
                    if (child.getTypeNode() == EnumType.SIMPLE_OPERATOR) {
                        this.saveBuiltInArgRelationship(contextNodeIndividual, contextNode, argNumber, child);
                        continue;
                    }
                    if (child.getTypeNode() == EnumType.QUANTIFIER_OPERATOR) {
                        this.saveBuiltInArgRelationship(contextNodeIndividual, contextNode, argNumber, child);
                        continue;
                    }
                    this.saveEmptySimpleArgRelationship(contextNodeIndividual, contextNode.getName(), argNumber);
                }
                break block16;
            }
            if (formulaNode.getTypeNode() == EnumType.OPERAND && formulaNode.getSubTypeNode() == EnumSubType.NODE) {
                OWLObjectProperty isContextInstanceOf = this.owlModel.getOWLObjectProperty("isContextInstanceOf");
                ResidentNodePointer pointer = (ResidentNodePointer)formulaNode.getNodeVariable();
                contextNodeIndividual.addPropertyValue((RDFProperty)isContextInstanceOf, (Object)this.mapDomainResident.get(pointer.getResidentNode()));
                this.loadResidentPossibleValues(contextNodeIndividual, pointer.getResidentNode());
                OrdinaryVariable[] oVariableArray = pointer.getOrdinaryVariableArray();
                int i = 0;
                while (i < oVariableArray.length) {
                    if (oVariableArray[i] == null) {
                        this.saveEmptySimpleArgRelationship(contextNodeIndividual, contextNodeIndividual.getName(), i + 1);
                    } else {
                        this.saveSimpleArgRelationship(oVariableArray[i], contextNodeIndividual, contextNodeIndividual.getName(), i + 1);
                    }
                    ++i;
                }
            }
        }
    }

    private void saveContextPossibleValues(OWLIndividual individual, MultiEntityNode node) {
        OWLObjectProperty hasPossibleValuesProperty = this.owlModel.getOWLObjectProperty("hasPossibleValues");
        for (Entity possibleValue : node.getPossibleValueList()) {
            if (possibleValue instanceof CategoricalStateEntity) {
                individual.addPropertyValue((RDFProperty)hasPossibleValuesProperty, (Object)this.mapCategoricalStates.get(possibleValue));
                continue;
            }
            individual.addPropertyValue((RDFProperty)hasPossibleValuesProperty, (Object)this.mapBooleanStatesEntity.get(possibleValue));
        }
    }

    private void clearAuxiliaryLists() {
        for (ContextNode context : this.auxContextNodeList) {
            context.delete();
        }
    }

    private void loadEntityIndividuals() {
        OWLIndividual individual = null;
        OWLNamedClass currentOWLEntity = null;
        for (ObjectEntity entity : this.mebn.getObjectEntityContainer().getListEntity()) {
            currentOWLEntity = this.mapObjectEntityClasses.get(entity);
            if (currentOWLEntity == null) continue;
            for (ObjectEntityInstance entityInstance : entity.getInstanceList()) {
                individual = currentOWLEntity.createOWLIndividual(entityInstance.getName());
                individual.addPropertyValue((RDFProperty)this.owlModel.getOWLObjectProperty("hasType"), (Object)this.mapMetaEntity.get(entityInstance.getType().getName()));
                individual.addPropertyValue((RDFProperty)this.owlModel.getOWLDatatypeProperty("hasUID"), (Object)("!" + entityInstance.getName()));
            }
        }
    }

    public OWLModel getLastOWLModel() {
        return this.owlModel;
    }

    public void setOWLModelToUse(OWLModel model) throws IOMebnException {
        JenaOWLModel jenamodel = null;
        try {
            jenamodel = (JenaOWLModel)model;
        }
        catch (ClassCastException cce) {
            return;
        }
        this.owlModel = jenamodel;
    }
}

