/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.io;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import unbbayes.io.LogManager;
import unbbayes.prs.Node;
import unbbayes.prs.bn.Clique;
import unbbayes.prs.bn.JunctionTree;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.Separator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkCompilationLogManager
extends LogManager {
    @Override
    public void reset() {
        this.clear();
        this.append(resource.getString("logHeader"));
    }

    public void finishLog(JunctionTree tree, ArrayList<Node> nodes) {
        int c2;
        Node node;
        int c22;
        PotentialTable auxTab;
        Clique auxClique;
        List<Clique> clicks = tree.getCliques();
        DecimalFormat df = new DecimalFormat();
        this.append(resource.getString("cliqueHeader"));
        int sizeclicks1 = clicks.size();
        int c = 0;
        while (c < sizeclicks1) {
            auxClique = clicks.get(c);
            int sizenodes1 = auxClique.getNodes().size();
            this.append(String.valueOf(resource.getString("cliqueName")) + c + "\n");
            int c23 = 0;
            while (c23 < sizenodes1) {
                this.append(String.valueOf(auxClique.getNodes().get(c23).getName()) + "-");
                ++c23;
            }
            this.append(resource.getString("potentialTableName"));
            auxTab = auxClique.getPotentialTable();
            int sizeDados = auxTab.tableSize();
            c22 = 0;
            while (c22 < sizeDados) {
                this.append(String.valueOf(df.format(auxTab.getValue(c22))) + " ");
                ++c22;
            }
            this.append(resource.getString("utilityTableName"));
            auxTab = auxClique.getUtilityTable();
            sizeDados = auxTab.tableSize();
            c22 = 0;
            while (c22 < sizeDados) {
                this.append(String.valueOf(df.format(auxTab.getValue(c22))) + " ");
                ++c22;
            }
            this.append("\n\n");
            ++c;
        }
        this.append(resource.getString("separatorHeader"));
        int sizeseparators = tree.getSeparatorsSize();
        int c3 = 0;
        while (c3 < sizeseparators) {
            Separator auxSep = tree.getSeparatorAt(c3);
            this.append(String.valueOf(resource.getString("separatorName")) + c3 + " ");
            this.append(String.valueOf(resource.getString("betweenName")) + clicks.indexOf(auxSep.getClique1()) + resource.getString("andName") + clicks.indexOf(auxSep.getClique2()) + "\n");
            this.append(resource.getString("nodeName"));
            int sizenodes2 = auxSep.getNodes().size();
            c22 = 0;
            while (c22 < sizenodes2) {
                node = auxSep.getNodes().get(c22);
                this.append(String.valueOf(node.getName()) + "-");
                ++c22;
            }
            this.append("\n");
            auxTab = auxSep.getPotentialTable();
            if (auxTab != null) {
                int sizeDados = auxTab.tableSize();
                c2 = 0;
                while (c2 < sizeDados) {
                    this.append(String.valueOf(df.format(auxTab.getValue(c2))) + " ");
                    ++c2;
                }
                this.append("\n\n");
            }
            ++c3;
        }
        this.append(resource.getString("potentialAssociatedHeader"));
        int sizenodes3 = nodes.size();
        int c4 = 0;
        while (c4 < sizenodes3) {
            node = nodes.get(c4);
            int sizeclicks = clicks.size();
            c2 = 0;
            while (c2 < sizeclicks) {
                auxClique = clicks.get(c2);
                if (auxClique.getAssociatedProbabilisticNodes().contains(node) || auxClique.getAssociatedUtilityNodes().contains(node)) {
                    this.append(String.valueOf(resource.getString("nodeName")) + node.getName() + resource.getString("cliqueLabel") + c2 + "\n");
                    break;
                }
                ++c2;
            }
            ++c4;
        }
    }
}

