/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.oobn;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.TransferHandler;
import unbbayes.controller.oobn.OOBNClassController;
import unbbayes.gui.GraphPane;
import unbbayes.gui.oobn.node.OOBNNodeGraphicalWrapper;
import unbbayes.prs.Node;
import unbbayes.prs.oobn.IOOBNClass;
import unbbayes.prs.oobn.IOOBNNode;
import unbbayes.util.Debug;

public class OOBNGraphPane
extends GraphPane {
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.gui.oobn.resources.OOBNGuiResource");
    private OOBNClassController controller = null;
    private JPopupMenu oobnOnNodePopup = null;
    private boolean bMoveNode = false;
    private Dimension visibleDimension = null;

    protected OOBNGraphPane(OOBNClassController controller, JViewport graphViewport) {
        super(controller, graphViewport);
        this.setController(controller);
    }

    public static OOBNGraphPane newInstance(OOBNClassController controller, JViewport graphViewport) {
        OOBNGraphPane ret = new OOBNGraphPane(controller, graphViewport);
        ret.setOobnOnNodePopup(new JPopupMenu(resource.getString("OOBNPopupMenuMessage")));
        ret.setUpPopupMenu();
        ret.setUpTransferHundler();
        ret.setVisibleDimension(new Dimension());
        ret.setToolTipText(resource.getString("leftClickToChangeNodeType"));
        return ret;
    }

    protected void setUpPopupMenu() {
        JMenuItem itemChangeNodeToInput = new JMenuItem(resource.getString("changeNodeToInput"));
        itemChangeNodeToInput.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                OOBNNodeGraphicalWrapper node = null;
                try {
                    node = (OOBNNodeGraphicalWrapper)OOBNGraphPane.this.getSelected();
                    node.getWrappedNode().setType(4);
                    Debug.println(this.getClass(), "I'm setting the node as an input");
                    OOBNGraphPane.this.update();
                }
                catch (IllegalArgumentException iae) {
                    JOptionPane.showMessageDialog(OOBNGraphPane.this.getController().getScreen(), iae.getMessage(), resource.getString("changeNodeToInput"), 0);
                }
                catch (Exception e) {
                    Debug.println(this.getClass(), "The selected node does not look like a valid wrapped OOBN node", e);
                    throw new IllegalArgumentException(e);
                }
            }
        });
        JMenuItem itemChangeNodeToOutput = new JMenuItem(resource.getString("changeNodeToOutput"));
        itemChangeNodeToOutput.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                OOBNNodeGraphicalWrapper node = null;
                try {
                    node = (OOBNNodeGraphicalWrapper)OOBNGraphPane.this.getSelected();
                    node.getWrappedNode().setType(1);
                    Debug.println(this.getClass(), "I'm setting the node as an output");
                    OOBNGraphPane.this.update();
                }
                catch (Exception e) {
                    Debug.println(this.getClass(), "The selected node does not look like a valid wrapped OOBN node", e);
                    throw new IllegalArgumentException(e);
                }
            }
        });
        JMenuItem itemChangeNodeToPrivate = new JMenuItem(resource.getString("changeNodeToPrivate"));
        itemChangeNodeToPrivate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                OOBNNodeGraphicalWrapper node = null;
                try {
                    node = (OOBNNodeGraphicalWrapper)OOBNGraphPane.this.getSelected();
                    node.getWrappedNode().setType(2);
                    Debug.println(this.getClass(), "I'm setting the node as private");
                    OOBNGraphPane.this.update();
                }
                catch (Exception e) {
                    Debug.println(this.getClass(), "The selected node does not look like a valid wrapped OOBN node", e);
                    throw new IllegalArgumentException(e);
                }
            }
        });
        this.getOobnOnNodePopup().add(itemChangeNodeToInput);
        this.getOobnOnNodePopup().add(itemChangeNodeToOutput);
        this.getOobnOnNodePopup().add(itemChangeNodeToPrivate);
        this.getOobnOnNodePopup().setLabel(resource.getString("OOBNPopupMenuMessage"));
        this.getOobnOnNodePopup().setToolTipText(resource.getString("OOBNPopupMenuTooltipMessage"));
    }

    public void setUpTransferHundler() {
        this.setTransferHandler(new TransferHandler(){

            public boolean canImport(TransferHandler.TransferSupport support) {
                try {
                    boolean ret = support.isDataFlavorSupported(new DataFlavor("application/x-java-jvm-local-objectref"));
                    return ret;
                }
                catch (Exception e) {
                    try {
                        Debug.println(this.getClass(), "Could not support data transfer from " + support.getComponent().getName(), e);
                    }
                    catch (Exception newe) {
                        Debug.println(this.getClass(), "Could not support data transfer using drag/drop or copy/paste", e);
                    }
                    return false;
                }
            }

            public boolean importData(TransferHandler.TransferSupport support) {
                IOOBNClass oobnClass;
                TransferHandler.DropLocation location;
                block4: {
                    Debug.println(this.getClass(), "Importing data from dragndrop: " + support.toString());
                    if (!this.canImport(support)) {
                        return false;
                    }
                    try {
                        location = support.getDropLocation();
                        Transferable transfer = support.getTransferable();
                        oobnClass = (IOOBNClass)transfer.getTransferData(new DataFlavor("application/x-java-jvm-local-objectref"));
                        if (oobnClass != null) break block4;
                        Debug.println(this.getClass(), "Nothing was extracted from drag n drop");
                        return false;
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(OOBNGraphPane.this.getController().getScreen(), e.getMessage(), resource.getString("CannotDragNDrop"), 0);
                        throw new RuntimeException(resource.getString("CannotDragNDrop"), e);
                    }
                }
                OOBNGraphPane.this.getController().insertInstanceNode(oobnClass, location.getDropPoint().getX(), location.getDropPoint().getY());
                Debug.println(this.getClass(), "It seems that we added the class " + oobnClass.getClassName() + "at position (" + location.getDropPoint().getX() + "," + location.getDropPoint().getY() + ")");
                super.importData(support);
                OOBNGraphPane.this.repaint();
                return true;
            }
        });
    }

    public void paint(Graphics g) {
        try {
            super.paint(g);
        }
        catch (Exception e) {
            Debug.println(this.getClass(), "Failure on paint", e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void mousePressed(MouseEvent e) {
        switch (OOBNGraphPane.$SWITCH_TABLE$unbbayes$gui$GraphAction()[this.getAction().ordinal()]) {
            case 1: {
                this.setBMoveNode(true);
                try {
                    node = (OOBNNodeGraphicalWrapper)this.getNode(e.getX(), e.getY());
                    this.describeOOBNNode(node);
                    if (node == null) ** break;
                    v0 = node.getWrappedNode().getType();
                    node.getWrappedNode();
                    if (v0 != 12) {
                        v1 = node.getWrappedNode().getType();
                        node.getWrappedNode();
                        if (v1 != 9) ** break;
                    }
                    return;
                    break;
                }
                catch (Exception t) {
                    Debug.println(this.getClass(), "You clicked at a non-OOBN node", t);
                }
            }
        }
        super.mousePressed(e);
    }

    public void mouseReleased(MouseEvent e) {
        switch (this.getAction()) {
            case NONE: {
                this.setBMoveNode(false);
                this.setCursor(new Cursor(0));
                break;
            }
        }
        super.mouseReleased(e);
        if (e.getModifiers() == 4 && this.getSelected() != null && this.getSelected() instanceof OOBNNodeGraphicalWrapper) {
            this.showNodeTypeChangePopup(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void mouseClicked(MouseEvent e) {
        Node node = this.getNode(e.getX(), e.getY());
        try {
            if (node != null && (((OOBNNodeGraphicalWrapper)node).getWrappedNode().getType() & 8) != 0) {
                return;
            }
        }
        catch (Exception ex) {
            Debug.println(this.getClass(), "The node was not in an expected format", ex);
        }
        super.mouseClicked(e);
    }

    public void mouseEntered(MouseEvent e) {
        if (!this.isBMoveNode()) {
            try {
                this.setVisibleDimension(new Dimension((int)this.controller.getScreen().getJspGraph().getSize().getWidth(), (int)this.controller.getScreen().getJspGraph().getSize().getHeight()));
            }
            catch (Exception exc) {
                Debug.println(this.getClass(), "Not able to set new visible dimension", exc);
            }
        }
        super.mouseEntered(e);
    }

    public OOBNClassController getController() {
        return this.controller;
    }

    public void setController(OOBNClassController controller) {
        this.controller = controller;
    }

    public JPopupMenu getOobnOnNodePopup() {
        return this.oobnOnNodePopup;
    }

    public void setOobnOnNodePopup(JPopupMenu oobnOnNodePopup) {
        this.oobnOnNodePopup = oobnOnNodePopup;
    }

    public Rectangle getRectangleRepaint() {
        if (this.isBMoveNode() && this.getSelected() instanceof OOBNNodeGraphicalWrapper) {
            Node noAux2;
            OOBNNodeGraphicalWrapper noAux = (OOBNNodeGraphicalWrapper)this.getSelected();
            double maiorX = noAux.getPosition().getX();
            double menorX = noAux.getPosition().getX();
            double maiorY = noAux.getPosition().getY();
            double menorY = noAux.getPosition().getY();
            int i = 0;
            while (i < noAux.getParents().size()) {
                noAux2 = noAux.getParents().get(i);
                if (maiorX < noAux2.getPosition().getX()) {
                    maiorX = noAux2.getPosition().getX();
                } else if (menorX > noAux2.getPosition().getX()) {
                    menorX = noAux2.getPosition().getX();
                }
                if (maiorY < noAux2.getPosition().getY()) {
                    maiorY = noAux2.getPosition().getY();
                } else if (menorY > noAux2.getPosition().getY()) {
                    menorY = noAux2.getPosition().getY();
                }
                ++i;
            }
            i = 0;
            while (i < noAux.getChildren().size()) {
                noAux2 = noAux.getChildren().get(i);
                if (maiorX < noAux2.getPosition().getX()) {
                    maiorX = noAux2.getPosition().getX();
                } else if (menorX > noAux2.getPosition().getX()) {
                    menorX = noAux2.getPosition().getX();
                }
                if (maiorY < noAux2.getPosition().getY()) {
                    maiorY = noAux2.getPosition().getY();
                } else if (menorY > noAux2.getPosition().getY()) {
                    menorY = noAux2.getPosition().getY();
                }
                ++i;
            }
            long width = noAux.getThisWidth() / 2;
            long height = noAux.getThisWidth() / 2;
            return new Rectangle((int)(menorX - (double)(6L * width)), (int)(menorY - (double)(6L * height)), (int)(maiorX - menorX + (double)(12L * width)), (int)(maiorY - menorY + (double)(12L * height)));
        }
        return super.getRectangleRepaint();
    }

    protected boolean isBMoveNode() {
        return this.bMoveNode;
    }

    protected void setBMoveNode(boolean moveNode) {
        this.bMoveNode = moveNode;
    }

    protected Dimension getVisibleDimension() {
        return this.visibleDimension;
    }

    protected void setVisibleDimension(Dimension visibleDimension) {
        this.visibleDimension = visibleDimension;
    }

    protected void describeOOBNNode(OOBNNodeGraphicalWrapper node) {
        try {
            Debug.println(this.getClass(), "Node " + node.getName() + " pressed.");
            Debug.println(this.getClass(), "Wrapped node name is " + node.getWrappedNode().getName());
            String[] types = new String[]{"0", "output", "private", "3", "input", "5", "6", "7", "instance", "Instance Output", "10", "11", "Instance Input"};
            Debug.println(this.getClass(), "Wrapped node type is " + types[node.getWrappedNode().getType()]);
            Debug.println(this.getClass(), "States are " + node.getWrappedNode().getStateNames());
            Debug.println(this.getClass(), "Original class node is " + (node.getWrappedNode().getOriginalClassNode() != null ? node.getWrappedNode().getOriginalClassNode().getName() : "null"));
            Debug.println(this.getClass(), "Upper instance node is " + (node.getWrappedNode().getUpperInstanceNode() != null ? node.getWrappedNode().getUpperInstanceNode().getName() : "null"));
            Debug.println(this.getClass(), "Parent class is " + (node.getWrappedNode().getParentClass() != null ? node.getWrappedNode().getParentClass().getClassName() : "null"));
            if (node.getWrappedNode().getInnerNodes() != null) {
                for (IOOBNNode iOOBNNode : node.getWrappedNode().getInnerNodes()) {
                    Debug.println(this.getClass(), "Inner node is " + iOOBNNode.getName() + " of type " + types[iOOBNNode.getType()]);
                }
            }
            if (node.getInnerNodes() != null) {
                for (OOBNNodeGraphicalWrapper oOBNNodeGraphicalWrapper : node.getInnerNodes()) {
                    Debug.println(this.getClass(), "Graphical Inner node is " + oOBNNodeGraphicalWrapper.getName() + " of type " + types[oOBNNodeGraphicalWrapper.getType()]);
                }
            }
            Debug.println(this.getClass(), "Parents are:");
            for (IOOBNNode iOOBNNode : node.getWrappedNode().getOOBNParents()) {
                Debug.println(this.getClass(), "\t" + iOOBNNode.getName());
            }
            Debug.println(this.getClass(), "Children are:");
            for (IOOBNNode iOOBNNode : node.getWrappedNode().getOOBNChildren()) {
                Debug.println(this.getClass(), "\t" + iOOBNNode.getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showNodeTypeChangePopup(Component invoker, int x, int y) {
        if ((((OOBNNodeGraphicalWrapper)this.getSelected()).getWrappedNode().getType() & 8) == 0) {
            this.getOobnOnNodePopup().setEnabled(true);
            this.getOobnOnNodePopup().show(invoker, x, y);
        }
    }
}

