/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.mebn.finding;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import unbbayes.controller.IconController;
import unbbayes.controller.MEBNController;
import unbbayes.gui.ParcialStateException;
import unbbayes.gui.mebn.auxiliary.ListCellRenderer;
import unbbayes.gui.mebn.finding.FindingArgumentPane;
import unbbayes.gui.mebn.util.OrganizerUtils;
import unbbayes.prs.mebn.RandomVariableFinding;
import unbbayes.prs.mebn.ResidentNode;
import unbbayes.prs.mebn.entity.Entity;
import unbbayes.prs.mebn.entity.ObjectEntityInstance;

public class RandomVariableFindingEdtitionPane
extends JPanel {
    private RandomVariableListPane randomVariableListPane;
    private RandomVariableInstanceEditionPane randomVariableInstanceEditionPane;
    private RandomVariableInstanceListPane randomVariableInstanceListPane;
    private MEBNController mebnController;
    private IconController iconController = IconController.getInstance();
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.gui.resources.GuiResources");
    private static final String SELECTION_PANE = "SelectionPane";
    private static final String EDITION_PANE = "EditionPane";
    private RandomVariableFinding instanceSelected = null;
    private ResidentNode residentSelected = null;
    private boolean editingInstance = false;
    private JPanel upperPanel;
    private JPanel downPanel;

    public RandomVariableFindingEdtitionPane() {
    }

    public RandomVariableFindingEdtitionPane(MEBNController mebnController) {
        super(new BorderLayout());
        this.mebnController = mebnController;
        this.upperPanel = new JPanel(new BorderLayout());
        this.randomVariableListPane = new RandomVariableListPane();
        this.upperPanel.add((Component)this.randomVariableListPane, "Center");
        this.downPanel = new JPanel(new BorderLayout());
        this.downPanel.add((Component)new RandomVariableInstanceListPane(), "Center");
        this.add((Component)this.upperPanel, "Center");
        this.add((Component)this.downPanel, "Last");
    }

    public void showRandomVariableInstanceListPane(ResidentNode node) {
        this.downPanel.removeAll();
        this.randomVariableInstanceListPane = new RandomVariableInstanceListPane(node);
        this.downPanel.add((Component)this.randomVariableInstanceListPane, "Center");
        this.downPanel.validate();
    }

    public void showRandomVariableEditionPane(ResidentNode node) {
        this.upperPanel.removeAll();
        this.upperPanel.add((Component)new RandomVariableInstanceEditionPane(node), "Center");
        this.upperPanel.validate();
    }

    public void showRandomVariableListPane() {
        this.upperPanel.removeAll();
        this.randomVariableListPane = new RandomVariableListPane();
        this.upperPanel.add((Component)this.randomVariableListPane, "Center");
        this.upperPanel.validate();
    }

    private class RandomVariableInstanceEditionPane
    extends JPanel {
        private final ResidentNode residentNode;
        private JLabel nodeName;
        private JComboBox comboState;
        private JPanel paneArguments;
        private FindingArgumentPane findingArgumentPane;
        private JButton btnInsert;
        private JButton btnBack;
        private JToolBar jtbOptions;
        private JToolBar jtbName;

        public RandomVariableInstanceEditionPane(ResidentNode _residentNode) {
            super(new BorderLayout());
            this.residentNode = _residentNode;
            this.nodeName = new JLabel(this.residentNode.getName());
            this.nodeName.setAlignmentX(0.5f);
            this.nodeName.setBackground(Color.YELLOW);
            this.findingArgumentPane = new FindingArgumentPane(this.residentNode, RandomVariableFindingEdtitionPane.this.mebnController);
            this.btnBack = new JButton(RandomVariableFindingEdtitionPane.this.iconController.getEditUndo());
            this.btnInsert = new JButton(RandomVariableFindingEdtitionPane.this.iconController.getMoreIcon());
            this.btnBack.setToolTipText(resource.getString("backToNodeSelectionTip"));
            this.btnInsert.setToolTipText(resource.getString("addFindingTip"));
            this.jtbOptions = new JToolBar();
            this.jtbOptions.setLayout(new GridLayout(1, 4));
            this.jtbOptions.add(new JPanel());
            this.jtbOptions.add(this.btnBack);
            this.jtbOptions.add(this.btnInsert);
            this.jtbOptions.add(new JPanel());
            this.jtbOptions.setFloatable(false);
            this.btnBack.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    RandomVariableFindingEdtitionPane.this.showRandomVariableListPane();
                }
            });
            this.btnInsert.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        ObjectEntityInstance[] arguments = RandomVariableInstanceEditionPane.this.findingArgumentPane.getArguments();
                        Entity state = RandomVariableInstanceEditionPane.this.findingArgumentPane.getState();
                        if (state == null) {
                            JOptionPane.showMessageDialog(RandomVariableFindingEdtitionPane.this.mebnController.getMebnEditionPane(), resource.getString("stateUnmarked"), resource.getString("error"), 0);
                        } else {
                            RandomVariableFindingEdtitionPane.this.mebnController.createRandomVariableFinding(RandomVariableInstanceEditionPane.this.residentNode, arguments, state);
                            RandomVariableFindingEdtitionPane.this.showRandomVariableInstanceListPane(RandomVariableInstanceEditionPane.this.residentNode);
                        }
                    }
                    catch (ParcialStateException e1) {
                        JOptionPane.showMessageDialog(RandomVariableFindingEdtitionPane.this.mebnController.getMebnEditionPane(), resource.getString("argumentMissing"), resource.getString("error"), 0);
                    }
                }
            });
            this.add((Component)new JScrollPane(this.findingArgumentPane), "Center");
            this.add((Component)this.jtbOptions, "Last");
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLUE), String.valueOf(resource.getString("AddFinding")) + ": " + this.residentNode.getName());
            titledBorder.setTitleColor(Color.BLUE);
            titledBorder.setTitleJustification(2);
            this.setBorder(titledBorder);
        }
    }

    private class RandomVariableInstanceListPane
    extends JPanel {
        private ResidentNode residentNode;
        private JList jlistFindings;
        private JScrollPane scrollListObjectEntity;
        private List<RandomVariableFinding> listInstances;
        private DefaultListModel listModel;

        public RandomVariableInstanceListPane() {
            super(new BorderLayout());
            this.listInstances = new ArrayList<RandomVariableFinding>();
            this.listModel = new DefaultListModel();
            this.jlistFindings = new JList(this.listModel);
            this.scrollListObjectEntity = new JScrollPane(this.jlistFindings);
            this.add((Component)this.scrollListObjectEntity, "Center");
        }

        public RandomVariableInstanceListPane(ResidentNode residentNode) {
            super(new BorderLayout());
            this.residentNode = residentNode;
            this.listInstances = new ArrayList<RandomVariableFinding>();
            this.listModel = new DefaultListModel();
            for (RandomVariableFinding finding : residentNode.getRandomVariableFindingList()) {
                this.listInstances.add(finding);
                this.listModel.addElement(finding);
            }
            this.jlistFindings = new JList(this.listModel);
            this.scrollListObjectEntity = new JScrollPane(this.jlistFindings);
            this.jlistFindings.setCellRenderer(new ListCellRenderer(RandomVariableFindingEdtitionPane.this.iconController.getEntityInstanceIcon()));
            this.jlistFindings.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    RandomVariableFindingEdtitionPane.this.editingInstance = true;
                    RandomVariableFindingEdtitionPane.this.instanceSelected = (RandomVariableFinding)RandomVariableInstanceListPane.this.jlistFindings.getSelectedValue();
                    if (RandomVariableFindingEdtitionPane.this.randomVariableListPane != null) {
                        RandomVariableFindingEdtitionPane.this.randomVariableListPane.enableBtnRemoveInstance();
                    }
                }
            });
            this.add((Component)this.scrollListObjectEntity, "Center");
        }
    }

    private class RandomVariableListPane
    extends JPanel {
        private JList jlistResident;
        private JScrollPane scrollListObjectEntity;
        private DefaultListModel listModel;
        private JButton btnAddInstance;
        private JButton btnRemoveInstance;
        private JToolBar jtbOptions;

        public RandomVariableListPane() {
            super(new BorderLayout());
            this.listModel = new DefaultListModel();
            List<ResidentNode> listResident = OrganizerUtils.createOrderedResidentNodeList(RandomVariableFindingEdtitionPane.this.mebnController.getMultiEntityBayesianNetwork());
            for (ResidentNode node : listResident) {
                System.out.println(node);
                this.listModel.addElement(new ResidentNodeJacket(node));
            }
            this.jlistResident = new JList(this.listModel);
            this.scrollListObjectEntity = new JScrollPane(this.jlistResident);
            this.jlistResident.setCellRenderer(new ListCellRenderer(RandomVariableFindingEdtitionPane.this.iconController.getYellowNodeIcon()));
            this.jlistResident.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    if (RandomVariableListPane.this.jlistResident.getSelectedValue() != null) {
                        RandomVariableFindingEdtitionPane.this.editingInstance = false;
                        RandomVariableListPane.this.btnRemoveInstance.setEnabled(false);
                        RandomVariableFindingEdtitionPane.this.residentSelected = ((ResidentNodeJacket)RandomVariableListPane.this.jlistResident.getSelectedValue()).getResidentNode();
                        RandomVariableFindingEdtitionPane.this.showRandomVariableInstanceListPane(((ResidentNodeJacket)RandomVariableListPane.this.jlistResident.getSelectedValue()).getResidentNode());
                    }
                }
            });
            this.jtbOptions = new JToolBar();
            this.jtbOptions.setLayout(new GridLayout(1, 4));
            this.jtbOptions.setFloatable(false);
            this.btnAddInstance = new JButton(RandomVariableFindingEdtitionPane.this.iconController.getEdit());
            this.btnRemoveInstance = new JButton(RandomVariableFindingEdtitionPane.this.iconController.getLessIcon());
            this.btnAddInstance.setToolTipText(resource.getString("editNodeFindingTip"));
            this.btnRemoveInstance.setToolTipText(resource.getString("removeFindingTip"));
            this.btnAddInstance.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (RandomVariableListPane.this.jlistResident.getSelectedValue() != null) {
                        RandomVariableFindingEdtitionPane.this.showRandomVariableEditionPane(((ResidentNodeJacket)RandomVariableListPane.this.jlistResident.getSelectedValue()).getResidentNode());
                    }
                }
            });
            this.btnRemoveInstance.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (RandomVariableFindingEdtitionPane.this.residentSelected != null && RandomVariableFindingEdtitionPane.this.instanceSelected != null) {
                        RandomVariableFindingEdtitionPane.this.residentSelected.removeRandomVariableFinding(RandomVariableFindingEdtitionPane.this.instanceSelected);
                        RandomVariableFindingEdtitionPane.this.instanceSelected = null;
                        RandomVariableFindingEdtitionPane.this.showRandomVariableInstanceListPane(RandomVariableFindingEdtitionPane.this.residentSelected);
                    }
                }
            });
            this.jtbOptions.add(new JPanel());
            this.jtbOptions.add(this.btnAddInstance);
            this.jtbOptions.add(this.btnRemoveInstance);
            this.jtbOptions.add(new JPanel());
            this.add((Component)this.scrollListObjectEntity, "Center");
            this.add((Component)this.jtbOptions, "Last");
        }

        public void enableBtnRemoveInstance() {
            this.btnRemoveInstance.setEnabled(true);
        }

        public void unableBtnRemoveInstance() {
            this.btnRemoveInstance.setEnabled(false);
        }

        class ResidentNodeJacket {
            private ResidentNode resident;

            public ResidentNodeJacket(ResidentNode resident) {
                this.resident = resident;
            }

            public String toString() {
                return "<html>" + this.resident.toString() + "<font color=blue>" + " (" + this.resident.getRandomVariableFindingList().size() + ")" + "</font></style>";
            }

            public ResidentNode getResidentNode() {
                return this.resident;
            }
        }
    }
}

