/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.mebn.cpt;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.StyledDocument;
import unbbayes.gui.mebn.cpt.StyleTable;
import unbbayes.prs.mebn.InputNode;
import unbbayes.prs.mebn.OrdinaryVariable;
import unbbayes.prs.mebn.ResidentNode;
import unbbayes.prs.mebn.entity.StateLink;

public class ColloringUtils {
    private List<String> fatherList;
    private List<String> statesFatherList;
    private List<String> argumentsList;
    private StyleTable styleTable;
    private ResidentNode residentNode;

    public ColloringUtils(ResidentNode _residentNode, StyleTable _styleTable) {
        this.residentNode = _residentNode;
        this.styleTable = _styleTable;
        this.buildAuxiliaryLists();
    }

    public void turnTextColor(String text, int initialPosition, StyledDocument doc) {
        int i = 0;
        int length = text.length();
        while (i < length) {
            String subString;
            int start;
            char charRead = text.charAt(i);
            if (Character.isLetter(charRead)) {
                start = i++;
                if (i < length) {
                    charRead = text.charAt(i);
                    while (Character.isLetter(charRead) || Character.isDigit(charRead)) {
                        if (++i >= length) break;
                        charRead = text.charAt(i);
                    }
                }
                subString = text.substring(start, i);
                this.writeWord(subString, initialPosition + start, doc);
                continue;
            }
            if (Character.isDigit(charRead)) {
                start = i++;
                if (i < length) {
                    charRead = text.charAt(i);
                    while (Character.isDigit(charRead) || charRead == '.') {
                        if (++i >= length) break;
                        charRead = text.charAt(i);
                    }
                }
                subString = text.substring(start, i);
                this.writeNumber(subString, initialPosition + start, doc);
                continue;
            }
            this.writeCharacter(charRead, initialPosition + i, doc);
            ++i;
        }
    }

    private void writeWord(String word, int position, StyledDocument doc) {
        try {
            if (this.isIfWord(word)) {
                doc.insertString(position, word, this.styleTable.getIfStyle());
                return;
            }
            if (this.isAnyWord(word)) {
                doc.insertString(position, word, this.styleTable.getAnyStyle());
                return;
            }
            if (this.isFunctionWord(word)) {
                doc.insertString(position, word, this.styleTable.getFunctionStyle());
                return;
            }
            if (this.isExpansionWord(word)) {
                doc.insertString(position, word, this.styleTable.getDescriptionStyle());
                return;
            }
            if (this.isStateNode(word)) {
                doc.insertString(position, word, this.styleTable.getStateNodeStyle());
                return;
            }
            if (this.isFather(word)) {
                doc.insertString(position, word, this.styleTable.getFatherStyle());
                return;
            }
            if (this.isStateFather(word)) {
                doc.insertString(position, word, this.styleTable.getStateFatherStyle());
                return;
            }
            if (this.isArgument(word)) {
                doc.insertString(position, word, this.styleTable.getArgumentStyle());
                return;
            }
            doc.insertString(position, word, this.styleTable.getDefaultStyle());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isLogicCharacter(Character c) {
        if (c.equals(Character.valueOf('&'))) {
            return true;
        }
        if (c.equals(Character.valueOf('|'))) {
            return true;
        }
        return c.equals(Character.valueOf('~'));
    }

    private boolean isIfWord(String word) {
        if (word.compareTo("if") == 0) {
            return true;
        }
        if (word.compareTo("else") == 0) {
            return true;
        }
        return word.compareTo("then") == 0;
    }

    private boolean isAnyWord(String word) {
        if (word.compareTo("any") == 0) {
            return true;
        }
        if (word.compareTo("all") == 0) {
            return true;
        }
        return word.compareTo("have") == 0;
    }

    private boolean isFunctionWord(String word) {
        if (word.compareTo("max") == 0) {
            return true;
        }
        if (word.compareTo("min") == 0) {
            return true;
        }
        if (word.compareTo("cardinality") == 0) {
            return true;
        }
        return word.compareTo("number") == 0;
    }

    private boolean isExpansionWord(String word) {
        if (word.compareTo("node") == 0) {
            return true;
        }
        if (word.compareTo("nodestate") == 0) {
            return true;
        }
        if (word.compareTo("formula") == 0) {
            return true;
        }
        if (word.compareTo("paramSubSet") == 0) {
            return true;
        }
        if (word.compareTo("booleanFunction") == 0) {
            return true;
        }
        if (word.compareTo("op1") == 0) {
            return true;
        }
        if (word.compareTo("op2") == 0) {
            return true;
        }
        return word.compareTo("op") == 0;
    }

    private boolean isStateNode(String word) {
        return this.residentNode.hasPossibleValue(word);
    }

    private boolean isStateFather(String word) {
        for (String state : this.statesFatherList) {
            if (state.compareTo(word) != 0) continue;
            return true;
        }
        return false;
    }

    private boolean isArgument(String word) {
        for (String argument : this.argumentsList) {
            if (argument.compareTo(word) != 0) continue;
            return true;
        }
        return false;
    }

    private boolean isFather(String word) {
        for (String father : this.fatherList) {
            if (father.compareTo(word) != 0) continue;
            return true;
        }
        return false;
    }

    private void writeNumber(String number, int position, StyledDocument doc) {
        try {
            doc.insertString(position, number, this.styleTable.getNumberStyle());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeCharacter(char character, int position, StyledDocument doc) {
        try {
            if (this.isLogicCharacter(Character.valueOf(character))) {
                doc.insertString(position, "" + character, this.styleTable.getBooleanStyle());
            } else {
                doc.insertString(position, "" + character, this.styleTable.getDefaultStyle());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void buildAuxiliaryLists() {
        this.fatherList = new ArrayList<String>();
        this.statesFatherList = new ArrayList<String>();
        this.argumentsList = new ArrayList<String>();
        for (ResidentNode resident : this.residentNode.getResidentNodeFatherList()) {
            this.fatherList.add(resident.getName());
            ResidentNode domainResidentNode = resident;
            for (StateLink state : domainResidentNode.getPossibleValueLinkList()) {
                this.statesFatherList.add(state.getState().getName());
            }
        }
        for (InputNode input : this.residentNode.getInputNodeFatherList()) {
            ResidentNode resident;
            if (!(input.getInputInstanceOf() instanceof ResidentNode) || (resident = (ResidentNode)input.getInputInstanceOf()) == null) continue;
            this.fatherList.add(resident.getName());
            for (StateLink state : resident.getPossibleValueLinkList()) {
                this.statesFatherList.add(state.getState().getName());
            }
        }
        for (OrdinaryVariable ov : this.residentNode.getOrdinaryVariableList()) {
            this.argumentsList.add(ov.getName());
        }
    }
}

