/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.mebn;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import unbbayes.controller.IconController;
import unbbayes.controller.MEBNController;
import unbbayes.controller.exception.InconsistentArgumentException;
import unbbayes.gui.ParcialStateException;
import unbbayes.gui.UnBBayesFrame;
import unbbayes.gui.mebn.QueryArgumentsPane;
import unbbayes.gui.mebn.auxiliary.ListCellRenderer;
import unbbayes.gui.mebn.util.OrganizerUtils;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.mebn.ResidentNode;
import unbbayes.prs.mebn.entity.ObjectEntityInstance;
import unbbayes.prs.mebn.exception.MEBNException;
import unbbayes.prs.mebn.ssbn.exception.ImplementationRestrictionException;
import unbbayes.prs.mebn.ssbn.exception.SSBNNodeGeneralException;

public class QueryPanel
extends JDialog {
    private MEBNController mebnController;
    private ResidentNode residentSelected;
    private IconController iconController = IconController.getInstance();
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.gui.resources.GuiResources");

    public QueryPanel(MEBNController mebnController) {
        super(UnBBayesFrame.getIUnBBayes());
        this.setTitle(resource.getString("queryPanelTitle"));
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.mebnController = mebnController;
        this.showRandonVariableListPane();
    }

    public void showArgumentsSelection(ResidentNode _residentNode) {
        QueryArgumentsEditionPane contentPane = new QueryArgumentsEditionPane(_residentNode);
        this.setContentPane(contentPane);
        this.validate();
        this.pack();
    }

    public void showRandonVariableListPane() {
        JPanel contentPane = new JPanel(new BorderLayout());
        JButton btnSelect = new JButton(resource.getString("queryBtnSelect"));
        btnSelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                QueryPanel.this.showArgumentsSelection(QueryPanel.this.residentSelected);
            }
        });
        JButton btnClose = new JButton(resource.getString("closeButton"));
        btnClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                QueryPanel.this.exit();
            }
        });
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.setLayout(new GridLayout());
        toolBar.add(new JLabel());
        toolBar.add(btnSelect);
        toolBar.add(btnClose);
        RandonVariableListPane randonVariableListPane = new RandonVariableListPane();
        JLabel label = new JLabel(String.valueOf(resource.getString("selectOneVariable")) + "               ");
        contentPane.add((Component)label, "First");
        contentPane.add((Component)randonVariableListPane, "Center");
        contentPane.add((Component)toolBar, "Last");
        this.setContentPane(contentPane);
        this.validate();
        this.pack();
    }

    public void exit() {
        this.dispose();
    }

    public void makeInvisible() {
        this.setVisible(false);
    }

    private class QueryArgumentsEditionPane
    extends JPanel {
        private final ResidentNode residentNode;
        private JLabel nodeName;
        private QueryArgumentsPane queryArgumentsPane;
        private JButton btnBack;
        private JButton btnExecute;
        private JButton btnClose;
        private JToolBar jtbOptions;

        public QueryArgumentsEditionPane(ResidentNode _residentNode) {
            super(new BorderLayout());
            this.residentNode = _residentNode;
            this.nodeName = new JLabel(this.residentNode.getName());
            this.nodeName.setAlignmentX(0.5f);
            this.nodeName.setBackground(Color.YELLOW);
            this.queryArgumentsPane = new QueryArgumentsPane(this.residentNode, QueryPanel.this.mebnController);
            this.btnBack = new JButton(resource.getString("queryBtnBack"));
            this.btnExecute = new JButton(resource.getString("queryBtnExecute"));
            this.btnClose = new JButton(resource.getString("closeButton"));
            this.jtbOptions = new JToolBar();
            this.jtbOptions.setLayout(new GridLayout(1, 3));
            this.jtbOptions.add(this.btnBack);
            this.jtbOptions.add(this.btnExecute);
            this.jtbOptions.add(this.btnClose);
            this.jtbOptions.setFloatable(false);
            this.btnBack.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    QueryPanel.this.showRandonVariableListPane();
                }
            });
            this.btnExecute.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    QueryPanel.this.makeInvisible();
                    try {
                        ObjectEntityInstance[] arguments = QueryArgumentsEditionPane.this.queryArgumentsPane.getArguments();
                        QueryArgumentsEditionPane.this.setVisible(false);
                        QueryPanel.this.mebnController.getScreen().setCursor(new Cursor(3));
                        ProbabilisticNetwork network = QueryPanel.this.mebnController.executeQuery(QueryArgumentsEditionPane.this.residentNode, arguments);
                        QueryPanel.this.mebnController.getScreen().setCursor(new Cursor(0));
                        QueryPanel.this.exit();
                    }
                    catch (MEBNException e0) {
                        e0.printStackTrace();
                        JOptionPane.showMessageDialog(QueryPanel.this.mebnController.getScreen(), e0.getMessage(), resource.getString("error"), 0);
                    }
                    catch (ParcialStateException e1) {
                        e1.printStackTrace();
                        JOptionPane.showMessageDialog(QueryPanel.this.mebnController.getScreen(), resource.getString("argumentFault"), resource.getString("error"), 0);
                    }
                    catch (InconsistentArgumentException iae) {
                        iae.printStackTrace();
                        JOptionPane.showMessageDialog(QueryPanel.this.mebnController.getScreen(), resource.getString("inconsistentArgument"), resource.getString("error"), 0);
                    }
                    catch (SSBNNodeGeneralException e2) {
                        e2.printStackTrace();
                        JOptionPane.showMessageDialog(QueryPanel.this.mebnController.getScreen(), e2.getMessage(), resource.getString("error"), 0);
                    }
                    catch (ImplementationRestrictionException e3) {
                        e3.printStackTrace();
                        JOptionPane.showMessageDialog(QueryPanel.this.mebnController.getScreen(), e3.getMessage(), resource.getString("error"), 0);
                    }
                    catch (Exception e4) {
                        e4.printStackTrace();
                        JOptionPane.showMessageDialog(QueryPanel.this.mebnController.getScreen(), e4.getMessage(), resource.getString("error"), 0);
                    }
                }
            });
            this.btnClose.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    QueryPanel.this.exit();
                }
            });
            this.add(new JLabel("Selecione os valores dos argumentos:   "));
            this.add((Component)new JScrollPane(this.queryArgumentsPane), "Center");
            this.add((Component)this.jtbOptions, "Last");
        }
    }

    private class RandonVariableListPane
    extends JPanel {
        private JList jlistResident;
        private JScrollPane scrollListObjectEntity;
        private DefaultListModel listModel;

        public RandonVariableListPane() {
            super(new BorderLayout());
            this.listModel = new DefaultListModel();
            List<ResidentNode> listResident = OrganizerUtils.createOrderedResidentNodeList(QueryPanel.this.mebnController.getMultiEntityBayesianNetwork());
            for (ResidentNode node : listResident) {
                this.listModel.addElement(node);
            }
            this.jlistResident = new JList(this.listModel);
            this.scrollListObjectEntity = new JScrollPane(this.jlistResident);
            this.jlistResident.setCellRenderer(new ListCellRenderer(QueryPanel.this.iconController.getYellowNodeIcon()));
            this.jlistResident.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    if (RandonVariableListPane.this.jlistResident.getSelectedValue() != null) {
                        QueryPanel.this.residentSelected = (ResidentNode)RandonVariableListPane.this.jlistResident.getSelectedValue();
                    }
                }
            });
            this.add((Component)this.scrollListObjectEntity, "Center");
        }
    }
}

