/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.mebn;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import unbbayes.controller.IconController;
import unbbayes.controller.MEBNController;
import unbbayes.prs.mebn.MFrag;
import unbbayes.prs.mebn.MultiEntityBayesianNetwork;
import unbbayes.prs.mebn.OrdinaryVariable;
import unbbayes.util.ArrayMap;

public abstract class OVariableTree
extends JTree {
    private MultiEntityBayesianNetwork net;
    protected ArrayMap<Object, OrdinaryVariable> ordinaryVariableMap = new ArrayMap();
    private List<OrdinaryVariable> ordinaryVariableList = new ArrayList<OrdinaryVariable>();
    private MFrag mfragActive;
    protected IconController iconController = IconController.getInstance();
    protected final MEBNController controller;

    public OVariableTree(MEBNController controller) {
        this.controller = controller;
        this.net = controller.getMultiEntityBayesianNetwork();
        this.mfragActive = this.net.getCurrentMFrag();
        this.setCellRenderer(new OrdinaryVariableTreeCellRenderer());
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(this.mfragActive.getName());
        DefaultTreeModel model = new DefaultTreeModel(root);
        this.setModel(model);
        this.createTree();
        this.addListeners();
    }

    private void createTree() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        this.ordinaryVariableList = this.net.getCurrentMFrag().getOrdinaryVariableList();
        for (OrdinaryVariable ordinaryVariable : this.ordinaryVariableList) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(String.valueOf(ordinaryVariable.getName()) + " (" + ordinaryVariable.getValueType() + ")");
            this.ordinaryVariableMap.put(node, ordinaryVariable);
            root.add(node);
        }
        this.expandRow(0);
    }

    public void updateTree() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        root.removeAllChildren();
        this.ordinaryVariableMap.clear();
        this.ordinaryVariableList = this.mfragActive.getOrdinaryVariableList();
        for (OrdinaryVariable ordinaryVariable : this.ordinaryVariableList) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(String.valueOf(ordinaryVariable.getName()) + " (" + ordinaryVariable.getValueType() + ")");
            this.ordinaryVariableMap.put(node, ordinaryVariable);
            root.add(node);
        }
        ((DefaultTreeModel)this.getModel()).reload(root);
        this.expandRow(0);
    }

    private DefaultMutableTreeNode findUserObject(String treeNode, DefaultMutableTreeNode root) {
        Enumeration<TreeNode> e = root.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (!node.getUserObject().toString().equals(treeNode)) continue;
            return node;
        }
        return null;
    }

    protected abstract void addListeners();

    private class OrdinaryVariableTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 0L;
        private ImageIcon grayBorderBox;
        private ImageIcon orangeNodeIcon;

        private OrdinaryVariableTreeCellRenderer() {
            this.grayBorderBox = OVariableTree.this.iconController.getGrayBorderBoxIcon();
            this.orangeNodeIcon = OVariableTree.this.iconController.getOrangeNodeIcon();
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            OrdinaryVariable obj = OVariableTree.this.ordinaryVariableMap.get((DefaultMutableTreeNode)value);
            if (leaf) {
                if (obj != null) {
                    this.setIcon(this.grayBorderBox);
                }
            } else {
                this.setIcon(this.orangeNodeIcon);
            }
            return this;
        }
    }
}

