/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.mebn;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import unbbayes.controller.MEBNController;
import unbbayes.gui.mebn.ArgumentsTypedPane;
import unbbayes.gui.mebn.InputInstanceOfTree;
import unbbayes.gui.mebn.auxiliary.MebnToolkit;
import unbbayes.prs.mebn.InputNode;

public class InputNodePane
extends JPanel {
    private InputNode inputNode;
    private InputInstanceOfTree inputInstanceOfTree;
    private JScrollPane inputInstanceOfTreeScroll;
    private JPanel argumentsPane;
    private MEBNController controller;
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.gui.resources.GuiResources");

    public InputNodePane() {
    }

    public InputNodePane(MEBNController _controller, InputNode _inputNode) {
        this.controller = _controller;
        this.inputNode = _inputNode;
        this.setBorder(MebnToolkit.getBorderForTabPanel(String.valueOf(resource.getString("InputTabTitle")) + ": "));
        JToolBar jtbInputInstanceOf = new JToolBar();
        JLabel jlInputInstanceOf = new JLabel(resource.getString("inputOf"));
        jtbInputInstanceOf.setFloatable(false);
        jtbInputInstanceOf.add(jlInputInstanceOf);
        this.inputInstanceOfTree = new InputInstanceOfTree(this.controller);
        this.inputInstanceOfTreeScroll = new JScrollPane(this.inputInstanceOfTree);
        this.inputInstanceOfTreeScroll.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), "Resident List"));
        this.argumentsPane = _inputNode.getResidentNodePointer() != null ? new ArgumentsTypedPane(this.inputNode, _inputNode.getResidentNodePointer(), this.controller) : new JPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)jtbInputInstanceOf, "North");
        this.add((Component)this.argumentsPane, "South");
        this.add((Component)this.inputInstanceOfTreeScroll, "Center");
        this.setVisible(true);
    }

    public void updateArgumentPane() {
        this.remove(this.argumentsPane);
        this.argumentsPane = new ArgumentsTypedPane(this.inputNode, this.inputNode.getResidentNodePointer(), this.controller);
        this.add((Component)this.argumentsPane, "South");
        this.validate();
        this.repaint();
    }
}

