/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.mebn;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import unbbayes.controller.IconController;
import unbbayes.controller.MEBNController;
import unbbayes.util.ResourceController;

public class DescriptionPane
extends JPanel {
    private final IconController iconController = IconController.getInstance();
    private static ResourceBundle resource = ResourceController.RS_GUI;
    public static final int DESCRIPTION_PANE_RESIDENT = 1;
    public static final int DESCRIPTION_PANE_INPUT = 2;
    public static final int DESCRIPTION_PANE_CONTEXT = 3;
    public static final int DESCRIPTION_PANE_OVARIABLE = 4;
    public static final int DESCRIPTION_PANE_MFRAG = 5;
    public static final int DESCRIPTION_PANE_MTHEORY = 6;
    private JTextArea textArea;
    private JToolBar toolBar;
    private final MEBNController mebnController;

    public DescriptionPane(MEBNController mebnController) {
        super(new BorderLayout());
        this.mebnController = mebnController;
        this.textArea = new JTextArea(5, 10);
        JScrollPane scrollPane = new JScrollPane(this.textArea, 20, 32);
        this.textArea.setEditable(true);
        this.textArea.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                DescriptionPane.this.mebnController.setDescriptionTextForSelectedObject(DescriptionPane.this.textArea.getText());
            }
        });
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        this.toolBar.setBackground(Color.white);
        JLabel labelDescription = new JLabel(" " + resource.getString("descriptionLabel"));
        labelDescription.setBackground(Color.WHITE);
        this.toolBar.add(labelDescription);
        this.add((Component)scrollPane, "Center");
        this.add((Component)this.toolBar, "First");
    }

    public void setDescriptionText(String description, int type) {
        this.textArea.setText(description);
        JButton btn = new JButton();
        switch (type) {
            case 1: {
                btn = new JButton(this.iconController.getResidentNodeIcon());
                break;
            }
            case 2: {
                btn = new JButton(this.iconController.getInputNodeIcon());
                break;
            }
            case 3: {
                btn = new JButton(this.iconController.getContextNodeIcon());
                break;
            }
            case 4: {
                btn = new JButton(this.iconController.getOVariableNodeIcon());
                break;
            }
            case 5: {
                btn = new JButton(this.iconController.getMFragIcon());
                break;
            }
            case 6: {
                btn = new JButton(this.iconController.getMTheoryNodeIcon());
                break;
            }
        }
        btn.setBackground(Color.WHITE);
        btn.setSize(20, 20);
        JLabel labelDescription = new JLabel(" " + resource.getString("descriptionLabel"));
        labelDescription.setBackground(Color.WHITE);
        this.toolBar.removeAll();
        this.toolBar.add(btn);
        this.toolBar.add(labelDescription);
    }

    public String getDescriptionText() {
        return this.textArea.getText();
    }
}

