/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.mebn;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import unbbayes.controller.IconController;
import unbbayes.controller.MEBNController;
import unbbayes.prs.mebn.OrdinaryVariable;
import unbbayes.prs.mebn.ResidentNodePointer;
import unbbayes.prs.mebn.exception.OVDontIsOfTypeExpected;

public class ArgumentsTypedPane
extends JPanel {
    private ResidentNodePointer pointer;
    private MEBNController mebnController;
    private Object node;
    private IconController iconController = IconController.getInstance();
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.gui.resources.GuiResources");

    public ArgumentsTypedPane(Object _node, ResidentNodePointer _pointer, MEBNController _mebnController) {
        this.pointer = _pointer;
        this.mebnController = _mebnController;
        this.node = _node;
        if (this.pointer.getNumberArguments() > 5) {
            this.setLayout(new GridLayout(this.pointer.getNumberArguments() + 1, 1));
        } else {
            this.setLayout(new GridLayout(6, 1));
        }
        JComboBox[] argument = new JComboBox[this.pointer.getNumberArguments()];
        JLabel residentNodeName = new JLabel(String.valueOf(resource.getString("nodeLabel")) + " = " + this.pointer.getResidentNode().getName());
        residentNodeName.setOpaque(true);
        residentNodeName.setHorizontalAlignment(0);
        residentNodeName.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        JButton btnOpenResidentNode = new JButton(this.iconController.getResidentNodeIcon());
        btnOpenResidentNode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ArgumentsTypedPane.this.mebnController.openPanel(ArgumentsTypedPane.this.pointer.getResidentNode());
            }
        });
        btnOpenResidentNode.setToolTipText(resource.getString("openTip"));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)residentNodeName, "Center");
        panel.add((Component)btnOpenResidentNode, "After");
        this.add(panel);
        boolean listEmpty = this.pointer.getOrdinaryVariableList().size() == 0;
        ArrayList ovList = (ArrayList)this.mebnController.getCurrentMFrag().getOrdinaryVariableList();
        int i = 0;
        while (i < this.pointer.getNumberArguments()) {
            JToolBar tbArgX = new JToolBar();
            Vector<OrdinaryVariable> list = new Vector<OrdinaryVariable>();
            list.add(null);
            for (OrdinaryVariable ov : ovList) {
                if (!ov.getValueType().equals(this.pointer.getTypeOfArgument(i))) continue;
                list.add(ov);
            }
            argument[i] = new JComboBox(list);
            argument[i].addItemListener(new ComboListener(i));
            int indexSelected = 0;
            if (this.pointer.getArgument(i) != null) {
                int j = 1;
                for (OrdinaryVariable ov : list) {
                    if (ov == null) continue;
                    if (ov.equals(this.pointer.getArgument(i))) {
                        indexSelected = j;
                        break;
                    }
                    ++j;
                }
            } else {
                indexSelected = 0;
            }
            argument[i].setSelectedIndex(indexSelected);
            JButton btnArgXNumber = new JButton("" + i);
            btnArgXNumber.setBackground(new Color(193, 207, 180));
            JButton btnArgXType = new JButton(this.pointer.getTypeOfArgument(i).getName());
            btnArgXType.setBackground(new Color(193, 210, 205));
            tbArgX.add(btnArgXNumber);
            tbArgX.add(btnArgXType);
            tbArgX.add(argument[i]);
            tbArgX.setFloatable(false);
            this.add(tbArgX);
            ++i;
        }
    }

    class ComboListener
    implements ItemListener {
        int indice;

        public ComboListener(int i) {
            this.indice = i;
        }

        public void itemStateChanged(ItemEvent e) {
            JComboBox combo = (JComboBox)e.getSource();
            if (combo.getSelectedItem() != null) {
                OrdinaryVariable ov = (OrdinaryVariable)combo.getSelectedItem();
                try {
                    ArgumentsTypedPane.this.pointer.addOrdinaryVariable(ov, this.indice);
                    ArgumentsTypedPane.this.mebnController.updateArgumentsOfObject(ArgumentsTypedPane.this.node);
                }
                catch (OVDontIsOfTypeExpected ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

