/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui.mebn;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.text.BadLocationException;
import unbbayes.controller.IconController;
import unbbayes.controller.MEBNController;
import unbbayes.gui.mebn.OVariableTreeForArgumentEdition;
import unbbayes.gui.mebn.OrdinaryVariableListPanel;
import unbbayes.gui.mebn.ResidentOVariableTree;
import unbbayes.gui.mebn.ResidentPaneOptions;
import unbbayes.gui.mebn.auxiliary.MebnToolkit;
import unbbayes.prs.mebn.MFrag;
import unbbayes.prs.mebn.OrdinaryVariable;
import unbbayes.prs.mebn.ResidentNode;
import unbbayes.prs.mebn.exception.ArgumentNodeAlreadySetException;
import unbbayes.prs.mebn.exception.DuplicatedNameException;
import unbbayes.prs.mebn.exception.OVariableAlreadyExistsInArgumentList;
import unbbayes.prs.mebn.exception.ReservedWordException;

public class ArgumentEditionPane2
extends JPanel {
    OrdinaryVariable ordinaryVariableSelected;
    boolean treeResidentActive = true;
    OVariableTreeForArgumentEdition treeMFrag;
    ResidentOVariableTree treeResident;
    JToolBar jtbInformation;
    JScrollPane jspTreeMFrag;
    JScrollPane jspTreeResident;
    JToolBar jtbDown;
    JToolBar jtbOptions;
    JToolBar jtbMFrag;
    JToolBar jtbResident;
    MEBNController mebnController;
    MFrag mFrag;
    ResidentNode residentNode;
    JButton btnNew;
    JButton btnDel;
    JButton btnDown;
    JLabel labelName;
    JTextField txtName;
    JLabel labelType;
    JTextField txtType;
    private final IconController iconController = IconController.getInstance();
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.gui.resources.GuiResources");
    private final Pattern wordPattern = Pattern.compile("[a-zA-Z_0-9]*");
    private Matcher matcher;

    public ArgumentEditionPane2(MEBNController _controller, ResidentNode resident) {
        this.setBorder(MebnToolkit.getBorderForTabPanel(resource.getString("ArgumentTitle")));
        this.mebnController = _controller;
        this.mFrag = this.mebnController.getCurrentMFrag();
        this.residentNode = resident;
        this.treeMFrag = new OVariableTreeForArgumentEdition(_controller);
        this.jspTreeMFrag = new JScrollPane(this.treeMFrag);
        this.treeResident = new ResidentOVariableTree(_controller, resident);
        this.jspTreeResident = new JScrollPane(this.treeResident);
        this.jtbDown = new JToolBar();
        this.jtbDown.setLayout(new GridLayout(1, 0));
        this.btnDown = new JButton(this.iconController.getDownIcon());
        this.btnDown.setToolTipText(resource.getString("downArgumentToolTip"));
        this.jtbDown.add(this.btnDown);
        this.jtbDown.setFloatable(false);
        this.jtbInformation = new JToolBar();
        this.jtbInformation.setLayout(new GridLayout(4, 0));
        this.labelName = new JLabel(resource.getString("nameLabel"));
        this.txtName = new JTextField(10);
        this.labelType = new JLabel(resource.getString("typeLabel"));
        this.txtType = new JTextField(10);
        this.jtbInformation.add(this.labelName);
        this.jtbInformation.add(this.txtName);
        this.jtbInformation.add(this.labelType);
        this.jtbInformation.add(this.txtType);
        this.txtType.setEditable(false);
        this.jtbInformation.setFloatable(false);
        this.jtbOptions = new JToolBar();
        this.jtbOptions.setLayout(new GridLayout(0, 2));
        this.btnNew = new JButton(this.iconController.getMoreIcon());
        this.btnNew.setToolTipText(resource.getString("newArgumentToolTip"));
        this.btnDel = new JButton(this.iconController.getLessIcon());
        this.btnDel.setToolTipText(resource.getString("delArgumentToolTip"));
        this.jtbOptions.add(this.btnNew);
        this.jtbOptions.add(this.btnDel);
        this.jtbOptions.setFloatable(false);
        this.addListenersOptions();
        JPanel panelCenter = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        panelCenter.setLayout(gridbag);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 100.0;
        constraints.weighty = 30.0;
        constraints.fill = 1;
        constraints.anchor = 11;
        OrdinaryVariableListPanel pan = new OrdinaryVariableListPanel("MFrag", resident.getOrdinaryVariableList());
        JScrollPane jsp2 = new JScrollPane(pan);
        gridbag.setConstraints(jsp2, constraints);
        panelCenter.add(jsp2);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 1;
        constraints.anchor = 11;
        gridbag.setConstraints(this.jtbDown, constraints);
        panelCenter.add(this.jtbDown);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 30.0;
        constraints.fill = 1;
        constraints.anchor = 11;
        OrdinaryVariableListPanel pan2 = new OrdinaryVariableListPanel("Resident", resident.getMFrag().getOrdinaryVariableList());
        JScrollPane jsp = new JScrollPane(pan2);
        gridbag.setConstraints(jsp, constraints);
        panelCenter.add(jsp);
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 1;
        constraints.anchor = 11;
        gridbag.setConstraints(this.jtbInformation, constraints);
        panelCenter.add(this.jtbInformation);
        ResidentPaneOptions options = new ResidentPaneOptions(_controller);
        this.setLayout(new BorderLayout());
        this.add((Component)options, "North");
        this.add((Component)panelCenter, "Center");
    }

    public ArgumentEditionPane2() {
    }

    public void addListenersOptions() {
        this.txtName.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && ArgumentEditionPane2.this.txtName.getText().length() > 0) {
                    try {
                        String name = ArgumentEditionPane2.this.txtName.getText(0, ArgumentEditionPane2.this.txtName.getText().length());
                        ArgumentEditionPane2.this.matcher = ArgumentEditionPane2.this.wordPattern.matcher(name);
                        if (ArgumentEditionPane2.this.matcher.matches()) {
                            try {
                                ArgumentEditionPane2.this.mebnController.renameOVariableInArgumentEditionPane(name);
                            }
                            catch (DuplicatedNameException e1) {
                                JOptionPane.showMessageDialog(ArgumentEditionPane2.this.mebnController.getScreen(), resource.getString("nameDuplicated"), resource.getString("nameError"), 0);
                            }
                            catch (ReservedWordException e2) {
                                JOptionPane.showMessageDialog(ArgumentEditionPane2.this.mebnController.getScreen(), resource.getString("nameReserved"), resource.getString("nameError"), 0);
                            }
                        } else {
                            JOptionPane.showMessageDialog(null, resource.getString("nameError"), resource.getString("nameException"), 0);
                            ArgumentEditionPane2.this.txtName.selectAll();
                        }
                    }
                    catch (BadLocationException ble) {
                        System.out.println(ble.getMessage());
                    }
                }
            }
        });
        this.btnDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                OrdinaryVariable ov = ArgumentEditionPane2.this.treeMFrag.getOVariableSelected();
                if (ov != null) {
                    try {
                        ArgumentEditionPane2.this.mebnController.addOrdinaryVariableInResident(ov);
                    }
                    catch (OVariableAlreadyExistsInArgumentList e1) {
                        JOptionPane.showMessageDialog(null, resource.getString("oVariableAlreadyIsArgumentError"), resource.getString("operationError"), 0);
                    }
                    catch (ArgumentNodeAlreadySetException e2) {
                        e2.printStackTrace();
                    }
                }
            }
        });
        this.btnNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    OrdinaryVariable ov = ArgumentEditionPane2.this.mebnController.addNewOrdinaryVariableInResident();
                    ArgumentEditionPane2.this.treeResident.setOVariableSelected(ov);
                    ArgumentEditionPane2.this.txtName.setText(ov.getName());
                    ArgumentEditionPane2.this.txtName.selectAll();
                    ArgumentEditionPane2.this.txtName.requestFocus();
                }
                catch (OVariableAlreadyExistsInArgumentList e1) {
                    JOptionPane.showMessageDialog(null, resource.getString("oVariableAlreadyIsArgumentError"), resource.getString("operationError"), 0);
                }
                catch (ArgumentNodeAlreadySetException e2) {
                    e2.printStackTrace();
                }
            }
        });
        this.btnDel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                OrdinaryVariable ov = ArgumentEditionPane2.this.treeResident.getOVariableSelected();
                if (ov != null) {
                    ArgumentEditionPane2.this.mebnController.removeOrdinaryVariableInResident(ov);
                }
            }
        });
    }

    public void setTxtName(String newName) {
        this.txtName.setText(newName);
    }

    public ResidentOVariableTree getResidentOVariableTree() {
        return this.treeResident;
    }

    public OVariableTreeForArgumentEdition getMFragOVariableTree() {
        return this.treeMFrag;
    }

    public void setTreeResidentActive() {
        this.treeResidentActive = true;
    }

    public void setTreeMFragActive() {
        this.treeResidentActive = false;
    }

    public boolean isTreeResidentActive() {
        return this.treeResidentActive;
    }

    public void update() {
        this.treeMFrag.updateTree();
        this.treeResident.updateTree();
    }
}

