/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import unbbayes.controller.IconController;
import unbbayes.controller.NetworkController;
import unbbayes.gui.EditNet;
import unbbayes.gui.EvidenceTree;
import unbbayes.gui.GraphAction;
import unbbayes.gui.GraphPane;
import unbbayes.gui.HierarchicDefinitionPane;
import unbbayes.gui.IFileExtensionAwareWindow;
import unbbayes.gui.MEBNEditionPane;
import unbbayes.gui.PNCompilationPane;
import unbbayes.gui.PNEditionPane;
import unbbayes.gui.SSBNCompilationPane;
import unbbayes.prs.Network;
import unbbayes.prs.Node;
import unbbayes.prs.bn.SingleEntityNetwork;
import unbbayes.prs.mebn.MultiEntityBayesianNetwork;
import unbbayes.prs.mebn.MultiEntityNode;

public class NetworkWindow
extends JInternalFrame
implements IFileExtensionAwareWindow {
    private static final String[] SUPPORTED_FILE_EXTENSIONS = new String[]{"net", "xml"};
    private static final String[] SUPPORTED_FILE_EXTENSIONS_MEBN = new String[]{"ubf"};
    private static final long serialVersionUID = 0L;
    private JViewport graphViewport = null;
    private GraphPane graphPane = null;
    private NetworkController controller = null;
    private Network net = null;
    private String fileName = null;
    private JScrollPane jspGraph = null;
    private JLabel status = null;
    private boolean bCompiled = false;
    private CardLayout card;
    private PNEditionPane pnEditionPane = null;
    private PNCompilationPane pnCompilationPane = null;
    private SSBNCompilationPane ssbnCompilationPane = null;
    private HierarchicDefinitionPane hierarchyPanel = null;
    private EditNet editNet = null;
    private MEBNEditionPane mebnEditionPane = null;
    public static final Integer PN_MODE = 0;
    public static final Integer MEBN_MODE = 1;
    private Integer mode = null;
    private final String PN_PANE_PN_EDITION_PANE = "pnEditionPane";
    private final String PN_PANE_PN_EDIT_NET = "editNet";
    private final String PN_PANE_PN_COMPILATION_PANE = "pnCompilationPane";
    private final String PN_PANE_HIERARCHY_PANE = "hierarchy";
    private final String PN_PANE_EVALUATION_PANE = "pnEvaluation";
    private final String MEBN_PANE_MEBN_EDITION_PANE = "mebnEditionPane";
    private final String MEBN_PANE_SSBN_COMPILATION_PANE = "ssbnCompilationPane";
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.gui.resources.GuiResources");

    protected NetworkWindow() {
        super("", true, true, true, true);
    }

    public NetworkWindow(Network net) {
        super(net.getName(), true, true, true, true);
        this.net = net;
        this.fileName = null;
        Container contentPane = this.getContentPane();
        this.card = new CardLayout();
        contentPane.setLayout(this.card);
        this.setDefaultCloseOperation(2);
        this.graphViewport = new JViewport();
        if (net instanceof SingleEntityNetwork) {
            this.controller = new NetworkController((SingleEntityNetwork)net, this);
        } else {
            this.controller = new NetworkController((MultiEntityBayesianNetwork)net, this);
            this.mebnEditionPane = this.controller.getMebnController().getMebnEditionPane();
        }
        this.graphPane = new GraphPane(this.controller, this.graphViewport);
        this.jspGraph = new JScrollPane(this.graphViewport);
        this.status = new JLabel(resource.getString("statusReadyLabel"));
        this.bCompiled = false;
        long width = Node.getWidth();
        long height = Node.getHeight();
        this.graphPane.getGraphViewport().reshape(0, 0, (int)(this.graphPane.getBiggestPoint().getX() + (double)width), (int)(this.graphPane.getBiggestPoint().getY() + (double)height));
        this.graphPane.getGraphViewport().setViewSize(new Dimension((int)(this.graphPane.getBiggestPoint().getX() + (double)width), (int)(this.graphPane.getBiggestPoint().getY() + (double)height)));
        this.graphViewport.setView(this.graphPane);
        this.graphViewport.setSize(800, 600);
        this.jspGraph.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                NetworkWindow.this.graphPane.update();
            }
        });
        this.jspGraph.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                NetworkWindow.this.graphPane.update();
            }
        });
        this.jspGraph.setHorizontalScrollBar(this.jspGraph.createHorizontalScrollBar());
        this.jspGraph.setVerticalScrollBar(this.jspGraph.createVerticalScrollBar());
        this.jspGraph.setHorizontalScrollBarPolicy(32);
        this.jspGraph.setVerticalScrollBarPolicy(22);
        if (net instanceof SingleEntityNetwork) {
            this.mode = PN_MODE;
            this.pnEditionPane = new PNEditionPane(this, this.controller);
            this.editNet = new EditNet(this, this.controller);
            this.pnCompilationPane = new PNCompilationPane(this, this.controller);
            this.hierarchyPanel = new HierarchicDefinitionPane((SingleEntityNetwork)net, this);
            contentPane.add((Component)this.pnEditionPane, "pnEditionPane");
            contentPane.add((Component)this.editNet, "editNet");
            contentPane.add((Component)this.pnCompilationPane, "pnCompilationPane");
            contentPane.add((Component)this.hierarchyPanel, "hierarchy");
            this.pnEditionPane.getCenterPanel().setBottomComponent(this.jspGraph);
            this.card.show(this.getContentPane(), "pnEditionPane");
        } else {
            this.mode = MEBN_MODE;
            this.ssbnCompilationPane = new SSBNCompilationPane();
            contentPane.add((Component)this.mebnEditionPane, "mebnEditionPane");
            contentPane.add((Component)this.ssbnCompilationPane, "ssbnCompilationPane");
            this.mebnEditionPane.getGraphPanel().setBottomComponent(this.jspGraph);
            this.card.show(this.getContentPane(), "mebnEditionPane");
        }
        this.setVisible(true);
        this.graphPane.update();
    }

    public void updateTitle() {
        super.setTitle(String.valueOf(this.net.getName()) + " " + "[" + this.fileName + "]");
    }

    public GraphPane getGraphPane() {
        return this.graphPane;
    }

    public EvidenceTree getEvidenceTree() {
        if (this.pnCompilationPane != null) {
            return this.pnCompilationPane.getEvidenceTree();
        }
        if (this.ssbnCompilationPane != null) {
            return this.ssbnCompilationPane.getEvidenceTree();
        }
        return null;
    }

    public JViewport getGraphViewport() {
        return this.graphViewport;
    }

    public JTable getTable() {
        return this.pnEditionPane.getTable();
    }

    public JTextField getTxtDescription() {
        return this.pnEditionPane.getTxtDescription();
    }

    public JTextField getTxtSigla() {
        return this.pnEditionPane.getTxtSigla();
    }

    public void setDistributionPane(JPanel distributionPane) {
        this.pnEditionPane.setDistributionPane(distributionPane);
    }

    public void setTable(JTable table) {
        this.pnEditionPane.setTable(table);
    }

    public JScrollPane getJspGraph() {
        return this.jspGraph;
    }

    public JScrollPane getJspTree() {
        return this.pnCompilationPane.getJspTree();
    }

    public Node getTableOwner() {
        return this.pnEditionPane.getTableOwner();
    }

    public void setTableOwner(Node node) {
        this.pnEditionPane.setTableOwner(node);
    }

    public SingleEntityNetwork getSingleEntityNetwork() {
        return (SingleEntityNetwork)this.controller.getNetwork();
    }

    public MultiEntityBayesianNetwork getMultiEntityBayesianNetwork() {
        return (MultiEntityBayesianNetwork)this.controller.getNetwork();
    }

    public void setStatus(String status) {
        if (this.ssbnCompilationPane != null) {
            this.ssbnCompilationPane.setStatus(status);
        } else {
            this.pnCompilationPane.setStatus(status);
            this.pnEditionPane.setStatus(status);
        }
        this.status.setText(status);
    }

    public void changeToPNCompilationPane() {
        if (this.mode == PN_MODE) {
            this.graphPane.setAction(GraphAction.NONE);
            this.graphPane.removeKeyListener(this.controller);
            this.pnCompilationPane.getCenterPanel().setRightComponent(this.jspGraph);
            this.pnCompilationPane.setStatus(this.status.getText());
            this.pnCompilationPane.getEvidenceTree().setRootVisible(true);
            this.pnCompilationPane.getEvidenceTree().expandRow(0);
            this.pnCompilationPane.getEvidenceTree().setRootVisible(false);
            this.bCompiled = true;
            this.controller.getSingleEntityNetwork().setFirstInitialization(true);
            this.card.show(this.getContentPane(), "pnCompilationPane");
            this.pnCompilationPane.getEvidenceTree().updateTree();
            this.pnCompilationPane.updateToPreferredSize();
        }
    }

    public void changeToPNEvaluationPane(JPanel evaluationPane) {
        if (this.mode == PN_MODE) {
            this.graphPane.setAction(GraphAction.NONE);
            this.graphPane.removeKeyListener(this.controller);
            JPanel leftPane = new JPanel(new BorderLayout());
            JToolBar toolBar = new JToolBar();
            JButton editMode = new JButton(IconController.getInstance().getEditIcon());
            editMode.setToolTipText(resource.getString("editToolTip"));
            editMode.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    NetworkWindow.this.changeToPNEditionPane();
                }
            });
            toolBar.add(editMode);
            leftPane.add((Component)toolBar, "North");
            leftPane.add((Component)evaluationPane, "Center");
            JSplitPane mainPane = new JSplitPane(1, leftPane, this.jspGraph);
            mainPane.setDividerLocation(500);
            this.getContentPane().add((Component)mainPane, "pnEvaluation");
            this.card.show(this.getContentPane(), "pnEvaluation");
        }
    }

    public void changeToMEBNEditionPane() {
        if (this.mode == MEBN_MODE) {
            Node.setSize(MultiEntityNode.getDefaultSize().getX(), MultiEntityNode.getDefaultSize().getY());
            this.graphPane.addKeyListener(this.controller);
            this.controller.getMebnController().setEditionMode();
            this.graphPane.resetGraph();
            this.mebnEditionPane.getGraphPanel().setBottomComponent(this.jspGraph);
            this.card.show(this.getContentPane(), "mebnEditionPane");
        }
    }

    public void changeToSSBNCompilationPane(SingleEntityNetwork ssbn) {
        if (this.mode == MEBN_MODE) {
            Node.setSize(Node.getDefaultSize().getX(), Node.getDefaultSize().getY());
            Container contentPane = this.getContentPane();
            contentPane.remove(this.ssbnCompilationPane);
            this.ssbnCompilationPane = new SSBNCompilationPane(ssbn, this, this.controller);
            this.graphPane.resetGraph();
            this.ssbnCompilationPane.getCenterPanel().setRightComponent(this.jspGraph);
            this.ssbnCompilationPane.setStatus(this.status.getText());
            this.ssbnCompilationPane.getEvidenceTree().setRootVisible(true);
            this.ssbnCompilationPane.getEvidenceTree().expandRow(0);
            this.ssbnCompilationPane.getEvidenceTree().setRootVisible(false);
            this.ssbnCompilationPane.getEvidenceTree().updateTree();
            contentPane.add((Component)this.ssbnCompilationPane, "ssbnCompilationPane");
            this.ssbnCompilationPane.getCenterPanel().setDividerLocation(200);
            CardLayout layout = (CardLayout)contentPane.getLayout();
            layout.show(this.getContentPane(), "ssbnCompilationPane");
        }
    }

    public void changeToPNEditionPane() {
        if (this.mode == PN_MODE) {
            this.graphPane.addKeyListener(this.controller);
            this.pnEditionPane.getCenterPanel().setBottomComponent(this.jspGraph);
            this.pnEditionPane.setStatus(this.status.getText());
            this.bCompiled = false;
            this.controller.getSingleEntityNetwork().setFirstInitialization(true);
            this.card.show(this.getContentPane(), "pnEditionPane");
        }
    }

    public void changeToHierarchy() {
        this.hierarchyPanel.updateExplanationTree();
        this.card.show(this.getContentPane(), "hierarchy");
    }

    public void changeToEditNet() {
        this.card.show(this.getContentPane(), "editNet");
    }

    public boolean isCompiled() {
        return this.bCompiled;
    }

    public PNEditionPane getNetWindowEdition() {
        return this.pnEditionPane;
    }

    public MEBNEditionPane getMebnEditionPane() {
        return this.mebnEditionPane;
    }

    public PNCompilationPane getNetWindowCompilation() {
        return this.pnCompilationPane;
    }

    public HierarchicDefinitionPane getHierarchicDefinitionPanel() {
        return this.hierarchyPanel;
    }

    public NetworkController getNetworkController() {
        return this.controller;
    }

    public EditNet getEditNet() {
        return this.editNet;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
        this.updateTitle();
    }

    public void setAddRemoveStateButtonVisible(boolean visible) {
        this.pnEditionPane.getBtnAddState().setVisible(visible);
        this.pnEditionPane.getBtnRemoveState().setVisible(visible);
    }

    public Integer getMode() {
        return this.mode;
    }

    public void setMode(Integer mode) {
        this.mode = mode;
    }

    public String[] getSupportedFileExtensions() {
        if (this.getMode() == MEBN_MODE) {
            return SUPPORTED_FILE_EXTENSIONS_MEBN;
        }
        return SUPPORTED_FILE_EXTENSIONS;
    }

    public String getSupportedFilesDescription() {
        if (this.getMode() == MEBN_MODE) {
            return resource.getString("netFileFilterSaveMEBN");
        }
        return resource.getString("netFileFilterSave");
    }

    public String getSavingMessage() {
        return resource.getString("saveTitle");
    }
}

