/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.example;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import unbbayes.io.NetIO;
import unbbayes.prs.Edge;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.prs.exception.InvalidParentException;

public class GraphicMode {
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.example.resources.ExampleResources");

    public static void main(String[] args) {
        JFrame frame = new JFrame(resource.getString("exampleTitle"));
        frame.setDefaultCloseOperation(3);
        Container pane = frame.getContentPane();
        pane.setLayout(new FlowLayout());
        JLabel labelArquivo = new JLabel(resource.getString("fileName"));
        final JTextField nomeArquivo = new JTextField(20);
        JButton botao = new JButton(resource.getString("compileTree"));
        pane.add(labelArquivo);
        pane.add(nomeArquivo);
        pane.add(botao);
        botao.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProbabilisticNetwork rede = null;
                try {
                    NetIO io = new NetIO();
                    rede = io.load(new File(nomeArquivo.getText()));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    System.exit(1);
                }
                ProbabilisticNode auxVP = new ProbabilisticNode();
                auxVP.setName(resource.getString("nodeName1"));
                auxVP.setDescription(resource.getString("nodeDescription"));
                auxVP.appendState(resource.getString("stateName0"));
                auxVP.appendState(resource.getString("stateName1"));
                PotentialTable auxTabPot = auxVP.getPotentialTable();
                auxTabPot.addVariable(auxVP);
                auxTabPot.addValueAt(0, 0.3f);
                auxTabPot.addValueAt(1, 0.7f);
                rede.addNode(auxVP);
                ProbabilisticNode auxVP2 = (ProbabilisticNode)rede.getNode("A");
                Edge auxArco = new Edge(auxVP, auxVP2);
                try {
                    rede.addEdge(auxArco);
                }
                catch (InvalidParentException e1) {
                    e1.printStackTrace();
                }
                try {
                    rede.compile();
                }
                catch (Exception ex) {
                    System.out.println(ex.getMessage());
                    System.exit(1);
                }
                float[] likelihood = new float[auxVP.getStatesSize()];
                likelihood[0] = 1.0f;
                likelihood[1] = 0.8f;
                auxVP.addLikeliHood(likelihood);
                try {
                    rede.updateEvidences();
                }
                catch (Exception exc) {
                    System.out.println(exc.getMessage());
                }
            }
        });
        frame.pack();
        frame.setVisible(true);
    }
}

