/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.evaluation.controller;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import unbbayes.evaluation.Evaluation;
import unbbayes.evaluation.exception.EvaluationException;
import unbbayes.evaluation.gui.EvaluationPane;
import unbbayes.prs.Node;
import unbbayes.prs.bn.ProbabilisticNetwork;

public class EvaluationController {
    private EvaluationPane evaluationPane;
    private ProbabilisticNetwork network;
    private Evaluation evaluation;

    public EvaluationController(ProbabilisticNetwork network) {
        this.network = network;
        this.evaluationPane = new EvaluationPane();
        this.evaluation = new Evaluation();
        this.setUpEvaluation();
    }

    public void setUpEvaluation() {
        ArrayList<String> nodeNameList = new ArrayList<String>();
        ArrayList<Node> nodeList = this.network.getNodes();
        for (Node node : nodeList) {
            nodeNameList.add(node.getName());
        }
        this.evaluationPane.fillNodeList(nodeNameList);
        this.evaluationPane.setRunBtnActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                EvaluationController.this.runEvaluation();
            }
        });
    }

    private void validateData() throws EvaluationException {
        StringBuffer errorMsg = new StringBuffer();
        try {
            Integer sampleSize = Integer.valueOf(this.evaluationPane.getSampleSizeText());
            if (sampleSize <= 0) {
                errorMsg.append("Sample size has to be greater than 0. \n");
            }
        }
        catch (NumberFormatException e) {
            errorMsg.append("Sample size has to be greater than 0. \n");
        }
        if (this.evaluationPane.getTargetNodeNameList().size() == 0) {
            errorMsg.append("There must be at least one target node selected. \n");
        }
        if (this.evaluationPane.getEvidenceNodeNameList().size() == 0) {
            errorMsg.append("There must be at least one evidence node selected. \n");
        }
        if (errorMsg.toString().length() > 0) {
            throw new EvaluationException(errorMsg.toString());
        }
    }

    private void runEvaluation() {
        try {
            this.validateData();
        }
        catch (EvaluationException e) {
            JOptionPane.showMessageDialog(this.evaluationPane, e.getMessage(), "Validation Error", 0);
            return;
        }
        List<String> targetNodeNameList = this.evaluationPane.getTargetNodeNameList();
        List<String> evidenceNodeNameList = this.evaluationPane.getEvidenceNodeNameList();
        Integer sampleSize = Integer.valueOf(this.evaluationPane.getSampleSizeText());
        try {
            String output = this.evaluation.evaluate(this.network, targetNodeNameList, evidenceNodeNameList, (int)sampleSize);
            this.evaluationPane.setOutputText(output);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.evaluationPane, e.getMessage(), "Evaluation Error", 0);
            return;
        }
    }

    public JPanel getView() {
        return this.evaluationPane;
    }
}

