/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.draw;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import unbbayes.draw.DrawElement;

public class DrawRectangle
extends DrawElement {
    private Point2D.Double position;
    private Point2D.Double size;

    public DrawRectangle(Point2D.Double position, Point2D.Double size) {
        this.position = position;
        this.size = size;
    }

    public void paint(Graphics2D graphics) {
        graphics.setColor(this.getFillColor());
        graphics.fillRect((int)(this.position.x - this.size.x / 2.0), (int)(this.position.y - this.size.y / 2.0), (int)this.size.x, (int)this.size.y);
        if (this.isSelected()) {
            graphics.setColor(DrawRectangle.getSelectionColor());
            graphics.setStroke(new BasicStroke(2.0f));
        } else {
            graphics.setColor(DrawRectangle.getOutlineColor());
        }
        graphics.drawRect((int)(this.position.x - this.size.x / 2.0), (int)(this.position.y - this.size.y / 2.0), (int)this.size.x, (int)this.size.y);
        graphics.setStroke(new BasicStroke(1.0f));
        super.paint(graphics);
    }
}

