/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.preprocessor.imbalanceddataset;

import java.util.Date;
import java.util.Random;
import unbbayes.datamining.datamanipulation.AttributeStats;
import unbbayes.datamining.datamanipulation.Instance;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.datamanipulation.NearestNeighbors;
import unbbayes.datamining.datamanipulation.Stats;
import unbbayes.datamining.datamanipulation.mtree.MTree;
import unbbayes.datamining.evaluation.batchEvaluation.GlobalBatchParameters;
import unbbayes.datamining.evaluation.batchEvaluation.PreprocessorParameters;
import unbbayes.datamining.preprocessor.imbalanceddataset.Batch;

public class Smote
extends Batch {
    private int[][] nearestNeighborsIDs;
    private int numAttributes;
    private Instance[] instances;
    private int numInstances;
    private MTree mTree;
    private float[][] newInstanceSet;
    private int newInstanceCounter;
    private int classIndex;
    private int counterIndex;
    private byte[] attributeType;
    private static final byte NUMERIC = 0;
    private static final byte NOMINAL = 1;
    private static final byte CYCLIC = 2;
    private float[] attMinValue;
    private float[] attMaxValue;
    private float[] attRangeValue;
    private float[] attHalfRangeValue;
    private int numNN = 5;
    private boolean optionDiscretize;
    private byte optionNominal;
    private boolean optionFixedGap;
    private Random random;
    private NearestNeighbors nearestNeighbors;
    private static boolean useRatio = true;
    private static boolean useK = false;
    private static boolean useOverThresh = false;
    private static boolean usePosThresh = false;
    private static boolean useNegThresh = false;
    private static boolean useCleaning = false;

    public Smote(InstanceSet instanceSet) {
        this(instanceSet, null);
    }

    public Smote(InstanceSet instanceSet, PreprocessorParameters parameters) {
        super(useRatio, useK, useOverThresh, usePosThresh, useNegThresh, useCleaning, instanceSet, parameters);
        this.preprocessorName = "Smote";
        this.initialize();
    }

    public void setMTree(MTree mTree) {
        this.mTree = mTree;
    }

    public void setInstanceSet(InstanceSet instanceSet) {
        this.instanceSet = instanceSet;
        this.instances = instanceSet.instances;
        this.numInstances = instanceSet.numInstances();
        this.counterIndex = instanceSet.counterIndex;
        this.classIndex = instanceSet.classIndex;
    }

    protected void run() {
        int counter = 0;
        int[] instancesIDsTmp = new int[this.numInstances];
        int inst = 0;
        while (inst < this.numInstances) {
            if (this.instances[inst].data[this.classIndex] == (float)this.interestingClass) {
                instancesIDsTmp[counter] = inst;
                ++counter;
            }
            ++inst;
        }
        int[] instancesIDs = new int[counter];
        int i = 0;
        while (i < counter) {
            instancesIDs[i] = instancesIDsTmp[i];
            ++i;
        }
        this.run(instancesIDs);
    }

    public void runAll() {
        int[] instancesIDs = new int[this.numInstances];
        int inst = 0;
        while (inst < this.numInstances) {
            instancesIDs[inst] = inst;
            ++inst;
        }
        this.run(instancesIDs);
    }

    public int[] run(int[] instancesIDs) {
        int numNewInstancesPerInstance;
        if (this.instanceSet.numInstances < 2 || instancesIDs.length < 2) {
            return instancesIDs;
        }
        instancesIDs = (int[])instancesIDs.clone();
        this.numAttributes = this.instanceSet.numAttributes();
        String exceptionMsg = "";
        if (this.instanceSet == null) {
            exceptionMsg = "The instanceSet is null!";
        }
        if (instancesIDs == null) {
            exceptionMsg = "The instancesIDs is null!";
        }
        if (this.proportion < 1.0) {
            exceptionMsg = "proportion must be greater than 1!";
        }
        if (this.numNN < 0) {
            exceptionMsg = "numNN must be greater than 0!";
        }
        if (exceptionMsg != "") {
            throw new IllegalArgumentException(exceptionMsg);
        }
        this.random = new Random(new Date().getTime());
        this.attributeType = this.instanceSet.attributeType;
        this.attMinValue = new float[this.numAttributes];
        this.attMaxValue = new float[this.numAttributes];
        this.attRangeValue = new float[this.numAttributes];
        this.attHalfRangeValue = new float[this.numAttributes];
        AttributeStats[] attributeStats = this.instanceSet.getAttributeStats();
        int att = 0;
        while (att < this.numAttributes) {
            if (this.instanceSet.getClassIndex() != att) {
                Stats stats = attributeStats[att].getNumericStats();
                if (this.attributeType[att] == 2) {
                    this.attMinValue[att] = stats.getMin();
                    this.attMaxValue[att] = stats.getMax();
                    this.attRangeValue[att] = this.attMaxValue[att] - this.attMinValue[att] + 1.0f;
                    this.attHalfRangeValue[att] = this.attRangeValue[att] / 2.0f;
                }
            }
            ++att;
        }
        this.proportion -= 1.0;
        int numInstancesIDs = instancesIDs.length;
        double currentSize = 0.0;
        int i = 0;
        while (i < numInstancesIDs) {
            int inst = instancesIDs[i];
            currentSize += (double)this.instances[inst].data[this.counterIndex];
            ++i;
        }
        int numNewInstances = (int)(this.proportion * currentSize) + 1;
        this.newInstanceSet = new float[numNewInstances][this.numAttributes + 1];
        this.newInstanceCounter = 0;
        if (this.proportion < 1.0) {
            int aux = (int)(currentSize * this.proportion) + 1;
            instancesIDs = this.chooseInstances(instancesIDs, aux);
            numInstancesIDs = instancesIDs.length;
            numNewInstancesPerInstance = 1;
        } else {
            numNewInstancesPerInstance = (int)this.proportion;
        }
        this.populate(numNewInstancesPerInstance, instancesIDs, numNewInstances);
        if (this.newInstanceCounter < numNewInstances) {
            int rest = numNewInstances - this.newInstanceCounter;
            instancesIDs = this.chooseInstances(instancesIDs, rest);
            numInstancesIDs = instancesIDs.length;
            numNewInstancesPerInstance = 1;
            this.populate(numNewInstancesPerInstance, instancesIDs, numNewInstances);
        }
        int[] result = this.instanceSet.insertInstances(this.newInstanceSet);
        return result;
    }

    private void populate(int numNewInstancesPerInstance, int[] instancesIDs, int max) {
        int numInstancesIDs = instancesIDs.length;
        int i = 0;
        while (i < numInstancesIDs) {
            int inst = instancesIDs[i];
            int[] nearestNeighborsIDs = this.nearestNeighborIDs(i);
            int w = 0;
            while ((float)w < this.instances[inst].data[this.counterIndex]) {
                this.populateAux(inst, nearestNeighborsIDs, numNewInstancesPerInstance);
                if (this.newInstanceCounter >= max) break;
                ++w;
            }
            if (this.newInstanceCounter >= max) break;
            ++i;
        }
    }

    private void populateAux(int inst, int[] nearestNeighborsIDs, int numNewInstancesPerInstance) {
        int i = 0;
        while (i < numNewInstancesPerInstance) {
            float[] newInstance = new float[this.numAttributes + 1];
            int chosenNN = this.random.nextInt(nearestNeighborsIDs.length);
            int nearestNeighborIndex = nearestNeighborsIDs[chosenNN];
            double gap = Math.random();
            int att = 0;
            while (att < this.numAttributes) {
                if (att == this.classIndex) {
                    newInstance[att] = this.instances[inst].data[this.classIndex];
                } else if (this.attributeType[att] == 1) {
                    if (this.optionNominal == 0) {
                        newInstance[att] = this.instances[inst].data[att];
                    } else if (this.optionNominal == 1) {
                        newInstance[att] = this.instances[nearestNeighborIndex].data[att];
                    }
                } else {
                    float attValue = this.instances[inst].data[att];
                    double dif = this.instances[nearestNeighborIndex].data[att] - attValue;
                    if (dif == 0.0) {
                        newInstance[att] = this.instances[inst].data[att];
                    } else {
                        if (this.attributeType[att] == 2 && Math.abs(dif) > (double)this.attHalfRangeValue[att]) {
                            dif = dif > 0.0 ? (dif -= (double)this.attRangeValue[att]) : (double)this.attRangeValue[att] - dif;
                        }
                        if (!this.optionFixedGap) {
                            gap = Math.random();
                        }
                        double newAttValue = (double)attValue + (dif *= gap);
                        if (this.attributeType[att] == 2) {
                            if (newAttValue > (double)this.attMaxValue[att]) {
                                newAttValue -= (double)this.attMaxValue[att];
                                newAttValue = (double)this.attMinValue[att] + newAttValue - 1.0;
                            }
                            if (newAttValue < (double)this.attMinValue[att]) {
                                newAttValue = (double)this.attMinValue[att] - newAttValue;
                                newAttValue = (double)this.attMaxValue[att] - newAttValue + 1.0;
                            }
                        }
                        if (this.optionDiscretize) {
                            double frac = newAttValue - (double)((int)newAttValue);
                            frac = frac >= 0.0 && frac < 0.125 ? 0.0 : (frac >= 0.125 && frac < 0.25 ? 0.25 : (frac >= 0.25 && frac < 0.5 ? 0.5 : 0.75));
                            newAttValue = frac + (double)((int)newAttValue);
                        }
                        newInstance[att] = (float)newAttValue;
                    }
                }
                ++att;
            }
            newInstance[this.counterIndex] = 1.0f;
            this.newInstanceSet[this.newInstanceCounter] = newInstance;
            ++this.newInstanceCounter;
            ++i;
        }
    }

    private int[] chooseInstances(int[] instancesIDs, int numNewInstances) {
        int[] instancesIDsAux = (int[])instancesIDs.clone();
        int numInstances = instancesIDsAux.length;
        int aux = numNewInstances;
        if (numNewInstances > numInstances) {
            aux = numInstances;
        }
        int[] indexesChosen = new int[aux];
        Random random = new Random(new Date().getTime());
        int counter = 0;
        int index = 0;
        while (counter < numNewInstances) {
            int last;
            int instIDs = random.nextInt(numInstances);
            int inst = instancesIDsAux[instIDs];
            counter = (int)((float)counter + this.instanceSet.instances[inst].data[this.counterIndex]);
            indexesChosen[index] = inst;
            ++index;
            instancesIDsAux[instIDs] = last = instancesIDsAux[numInstances - 1];
            --numInstances;
        }
        int[] result = new int[index];
        int i = 0;
        while (i < index) {
            result[i] = indexesChosen[i];
            ++i;
        }
        return result;
    }

    private int[] nearestNeighborIDs(int instanceID) {
        int index = -1;
        int count = 0;
        int i = 0;
        while (i < this.numNN) {
            try {
                index = this.nearestNeighborsIDs[instanceID][i];
            }
            catch (Exception e) {
                boolean bl = true;
            }
            if (index > 0) {
                ++count;
            }
            ++i;
        }
        if (count == 0) {
            i = 1;
        }
        int[] nearestNeighborIDs = new int[count];
        count = 0;
        int i2 = 0;
        while (i2 < this.numNN) {
            index = this.nearestNeighborsIDs[instanceID][i2];
            if (index > 0) {
                nearestNeighborIDs[count] = index;
                ++count;
            }
            ++i2;
        }
        return nearestNeighborIDs;
    }

    public void buildNearestNeighbors() throws Exception {
        if (this.nearestNeighborsIDs == null) {
            this.nearestNeighbors = new NearestNeighbors(this.instanceSet);
            this.nearestNeighborsIDs = this.nearestNeighbors.build(this.interestingClass);
        }
    }

    public void setOptionDiscretize(boolean optionDiscretize) {
        this.optionDiscretize = optionDiscretize;
    }

    public void setOptionNominal(byte optionNominal) {
        this.optionNominal = optionNominal;
    }

    public void setOptionFixedGap(boolean optionFixedGap) {
        this.optionFixedGap = optionFixedGap;
    }

    public void setNearestNeighborsIDs(int[][] nearestNeighborsIDs) {
        this.nearestNeighborsIDs = nearestNeighborsIDs;
    }

    public boolean isNearestNeighborsIDsBuilt() {
        return this.nearestNeighborsIDs != null;
    }

    public void initialize() {
        GlobalBatchParameters.getInstance().initializeSmote(this);
    }

    protected void initializeBatch(InstanceSet instanceSet) throws Exception {
        this.initialize();
        this.setInstanceSet(instanceSet);
        this.setInterestingClass(this.positiveClass);
        this.buildNearestNeighbors();
    }
}

