/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.preprocessor.imbalanceddataset;

import java.util.Random;
import unbbayes.datamining.datamanipulation.Instance;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.evaluation.batchEvaluation.PreprocessorParameters;
import unbbayes.datamining.preprocessor.imbalanceddataset.Batch;
import unbbayes.datamining.preprocessor.imbalanceddataset.Utils;

public class RandomOversampling
extends Batch {
    private static boolean useRatio = true;
    private static boolean useK = false;
    private static boolean useOverThresh = false;
    private static boolean usePosThresh = false;
    private static boolean useNegThresh = false;
    private static boolean useCleaning = false;

    public RandomOversampling(InstanceSet instanceSet) {
        this(instanceSet, null);
    }

    public RandomOversampling(InstanceSet instanceSet, PreprocessorParameters parameters) {
        super(useRatio, useK, useOverThresh, usePosThresh, useNegThresh, useCleaning, instanceSet, parameters);
        this.preprocessorName = "Oversampling";
    }

    public void runAll() {
        int numInstances = this.instanceSet.numInstances;
        int[] instancesIDs = new int[numInstances];
        int i = 0;
        while (i < numInstances) {
            instancesIDs[i] = i;
            ++i;
        }
        this.run(instancesIDs);
    }

    protected void run() throws Exception {
        Instance[] instances = this.instanceSet.instances;
        int numInstances = this.instanceSet.numInstances;
        int counter = 0;
        int[] instancesIDsTmp = new int[numInstances];
        int classIndex = this.instanceSet.classIndex;
        int inst = 0;
        while (inst < numInstances) {
            if (instances[inst].data[classIndex] == (float)this.interestingClass) {
                instancesIDsTmp[counter] = inst;
                ++counter;
            }
            ++inst;
        }
        int[] instancesIDs = new int[counter];
        int i = 0;
        while (i < counter) {
            instancesIDs[i] = instancesIDsTmp[i];
            ++i;
        }
        this.run(instancesIDs);
    }

    public void run(int[] instancesIDs) {
        if (this.instanceSet.numInstances < 1 || instancesIDs.length < 1) {
            return;
        }
        if (this.instanceSet.isCompacted()) {
            instancesIDs = Utils.uncompactInstancesIDs(instancesIDs, this.instanceSet);
        }
        int counterIndex = this.instanceSet.counterIndex;
        int numInstances = instancesIDs.length;
        int inst = 0;
        int currentSize = 0;
        int i = 0;
        while (i < numInstances) {
            inst = instancesIDs[i];
            currentSize = (int)((float)currentSize + this.instanceSet.instances[inst].data[counterIndex]);
            ++i;
        }
        int increaseSize = (int)((this.proportion - 1.0) * (double)currentSize) + 1;
        Random randomizer = new Random();
        int i2 = 0;
        while (i2 < increaseSize) {
            inst = instancesIDs[randomizer.nextInt(numInstances)];
            int n = counterIndex;
            this.instanceSet.instances[inst].data[n] = this.instanceSet.instances[inst].data[n] + 1.0f;
            ++this.instanceSet.numWeightedInstances;
            ++i2;
        }
        this.instanceSet.getClassDistribution(true);
    }

    public void setInstanceSet(InstanceSet instanceSet) {
        this.instanceSet = instanceSet;
    }

    protected void initializeBatch(InstanceSet instanceSet) {
        this.setInstanceSet(instanceSet);
        this.setInterestingClass(this.positiveClass);
    }
}

