/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.preprocessor.imbalanceddataset;

import unbbayes.datamining.datamanipulation.Instance;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.evaluation.batchEvaluation.PreprocessorParameters;
import unbbayes.datamining.preprocessor.imbalanceddataset.Batch;

public class Baseline
extends Batch {
    private boolean remove;
    private boolean[] deleteIndex;
    private int limit;
    private static boolean useRatio = true;
    private static boolean useK = false;
    private static boolean useOverThresh = false;
    private static boolean usePosThresh = false;
    private static boolean useNegThresh = false;
    private static boolean useCleaning = false;

    public Baseline(InstanceSet instanceSet, PreprocessorParameters parameters) {
        super(useRatio, useK, useOverThresh, usePosThresh, useNegThresh, useCleaning, instanceSet, parameters);
        this.preprocessorName = "Baseline";
    }

    public Baseline(InstanceSet instanceSet) {
        this(instanceSet, null);
    }

    public void runAll() {
        this.interestingClass = -1;
        this.run();
    }

    protected void run() {
        Instance[] instances = this.instanceSet.instances;
        int numInstances = this.instanceSet.numInstances;
        int counter = 0;
        int[] instancesIDsTmp = new int[numInstances];
        int classIndex = this.instanceSet.classIndex;
        int inst = 0;
        while (inst < numInstances) {
            if (instances[inst].data[classIndex] == (float)this.interestingClass) {
                instancesIDsTmp[counter] = inst;
                ++counter;
            }
            ++inst;
        }
        int[] instancesIDs = new int[counter];
        int i = 0;
        while (i < counter) {
            instancesIDs[i] = instancesIDsTmp[i];
            ++i;
        }
        this.run(instancesIDs);
    }

    public void run(int[] instancesIDs) {
        int classIndex = this.instanceSet.classIndex;
        int counterIndex = this.instanceSet.counterIndex;
        int numInstancesIDs = instancesIDs.length;
        boolean delete = false;
        int i = 0;
        while (i < numInstancesIDs) {
            int inst = instancesIDs[i];
            Instance instance = this.instanceSet.instances[inst];
            if (instance.data[classIndex] == (float)this.interestingClass || this.interestingClass == -1) {
                double difference = instance.data[counterIndex] - (float)this.limit;
                if (difference > 0.0) {
                    this.instanceSet.numWeightedInstances = (int)((double)this.instanceSet.numWeightedInstances - difference);
                    instance.data[counterIndex] = this.limit;
                } else {
                    this.deleteIndex[inst] = true;
                    delete = true;
                }
            }
            ++i;
        }
        if (delete && this.remove) {
            this.instanceSet.removeInstances(this.deleteIndex);
        }
    }

    public void run(InstanceSet instanceSet, int limit, int interestingClass) {
    }

    public void setInstanceSet(InstanceSet instanceSet) {
        this.instanceSet = instanceSet;
    }

    public void setRemove(boolean remove) {
        this.remove = remove;
    }

    public void setDeleteIndex(boolean[] deleteIndex) {
        this.deleteIndex = deleteIndex;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    protected void initializeBatch(InstanceSet instanceSet) throws Exception {
        this.setInstanceSet(instanceSet);
    }
}

