/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.gui.preprocessor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import unbbayes.controller.FileController;
import unbbayes.controller.IconController;
import unbbayes.controller.JavaHelperController;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.gui.preprocessor.PreprocessPanel;
import unbbayes.datamining.gui.preprocessor.PreprocessorParameters;
import unbbayes.gui.FileIcon;
import unbbayes.gui.SimpleFileFilter;

public class PreprocessorMain
extends JInternalFrame {
    private static final long serialVersionUID = 0L;
    private ResourceBundle resource;
    private JPanel contentPane;
    private JMenuBar jMenuBar1 = new JMenuBar();
    private JMenu jMenuFile = new JMenu();
    private JMenu jMenuHelp = new JMenu();
    private JMenuItem jMenuHelpAbout = new JMenuItem();
    private JToolBar jToolBar = new JToolBar();
    private JButton openButton = new JButton();
    private JButton saveButton = new JButton();
    private JButton helpButton = new JButton();
    private ImageIcon openIcon;
    private ImageIcon saveIcon;
    private ImageIcon helpIcon;
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel jPanel41 = new JPanel();
    private TitledBorder titledBorder5;
    private Border border5;
    private PreprocessPanel jPanel1 = new PreprocessPanel(this);
    private JLabel statusBar = new JLabel();
    private BorderLayout borderLayout2 = new BorderLayout();
    private InstanceSet inst;
    private JMenuItem jMenuFileOpen = new JMenuItem();
    private JMenuItem jMenuFileTestTrainingSet = new JMenuItem();
    private JMenuItem jMenuBuildSample = new JMenuItem();
    private JMenuItem jMenuFileExit = new JMenuItem();
    private JFileChooser fileChooser;
    private JPanel jPanel3 = new JPanel();
    private BorderLayout borderLayout3 = new BorderLayout();
    protected IconController iconController = IconController.getInstance();
    JMenuItem jMenuFileSave = new JMenuItem();

    public PreprocessorMain() {
        super("InitializePreprocessors", true, true, true, true);
        this.resource = ResourceBundle.getBundle("unbbayes.datamining.gui.preprocessor.resources.PreprocessorResource");
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.openIcon = this.iconController.getOpenIcon();
        this.saveIcon = this.iconController.getSaveIcon();
        this.helpIcon = this.iconController.getHelpIcon();
        this.contentPane = (JPanel)this.getContentPane();
        this.titledBorder5 = new TitledBorder(this.border5, this.resource.getString("selectProgram"));
        this.border5 = BorderFactory.createLineBorder(new Color(153, 153, 153), 1);
        this.contentPane.setLayout(this.borderLayout1);
        this.setSize(new Dimension(640, 480));
        this.jMenuFile.setMnemonic(((Character)this.resource.getObject("fileMnemonic")).charValue());
        this.jMenuFile.setText(this.resource.getString("file"));
        this.jMenuHelp.setMnemonic(((Character)this.resource.getObject("helpMnemonic")).charValue());
        this.jMenuHelp.setText(this.resource.getString("help"));
        this.jMenuHelpAbout.setIcon(this.helpIcon);
        this.jMenuHelpAbout.setMnemonic(((Character)this.resource.getObject("helpTopicsMnemonic")).charValue());
        this.jMenuHelpAbout.setText(this.resource.getString("helpTopics"));
        this.jMenuHelpAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreprocessorMain.this.jMenuHelpAbout_actionPerformed(e);
            }
        });
        this.openButton.setIcon(this.openIcon);
        this.openButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreprocessorMain.this.openButton_actionPerformed(e);
            }
        });
        this.openButton.setToolTipText(this.resource.getString("openFile"));
        this.saveButton.setIcon(this.saveIcon);
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreprocessorMain.this.saveButton_actionPerformed(e);
            }
        });
        this.saveButton.setEnabled(false);
        this.saveButton.setToolTipText(this.resource.getString("saveFile"));
        this.helpButton.setIcon(this.helpIcon);
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreprocessorMain.this.helpButton_actionPerformed(e);
            }
        });
        this.helpButton.setToolTipText(this.resource.getString("help"));
        this.jPanel41.setLayout(this.borderLayout2);
        this.jToolBar.setFloatable(false);
        this.jPanel41.setBorder(this.titledBorder5);
        this.titledBorder5.setTitle(this.resource.getString("status"));
        this.statusBar.setText(this.resource.getString("welcome"));
        this.jMenuFileOpen.setIcon(this.openIcon);
        this.jMenuFileOpen.setMnemonic(((Character)this.resource.getObject("openMnemonic")).charValue());
        this.jMenuFileOpen.setText(this.resource.getString("open"));
        this.jMenuFileOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreprocessorMain.this.jMenuFileOpen_actionPerformed(e);
            }
        });
        this.jMenuFileExit.setMnemonic(((Character)this.resource.getObject("fileExitMnemonic")).charValue());
        this.jMenuFileExit.setText(this.resource.getString("exit"));
        this.jMenuFileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreprocessorMain.this.jMenuFileExit_actionPerformed(e);
            }
        });
        this.jPanel3.setLayout(this.borderLayout3);
        this.jMenuFileSave.setEnabled(false);
        this.jMenuFileSave.setIcon(this.saveIcon);
        this.jMenuFileSave.setMnemonic(((Character)this.resource.getObject("saveMnemonic")).charValue());
        this.jMenuFileSave.setText(this.resource.getString("save"));
        this.jMenuFileSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreprocessorMain.this.saveButton_actionPerformed(e);
            }
        });
        this.jMenuFileTestTrainingSet.setEnabled(false);
        this.jMenuFileTestTrainingSet.setMnemonic(((Character)this.resource.getObject("fileTestTrainingMnemonic")).charValue());
        this.jMenuFileTestTrainingSet.setText(this.resource.getString("fileTestTraining"));
        this.jMenuFileTestTrainingSet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreprocessorMain.this.jMenuFileTestTrainingSet_actionPerformed(e);
            }
        });
        this.jMenuBuildSample.setEnabled(false);
        this.jMenuBuildSample.setMnemonic(((Character)this.resource.getObject("sampleMnemonic")).charValue());
        this.jMenuBuildSample.setText(this.resource.getString("sample"));
        this.jMenuBuildSample.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreprocessorMain.this.jMenuBuildSample_actionPerformed(e);
            }
        });
        this.jToolBar.add(this.openButton);
        this.jToolBar.add(this.saveButton);
        this.jToolBar.add(this.helpButton);
        this.jMenuFile.add(this.jMenuFileOpen);
        this.jMenuFile.add(this.jMenuFileSave);
        this.jMenuFile.add(this.jMenuFileTestTrainingSet);
        this.jMenuFile.add(this.jMenuBuildSample);
        this.jMenuFile.add(this.jMenuFileExit);
        this.jMenuHelp.add(this.jMenuHelpAbout);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuBar1.add(this.jMenuHelp);
        this.setJMenuBar(this.jMenuBar1);
        this.contentPane.add((Component)this.jToolBar, "North");
        this.contentPane.add((Component)this.jPanel41, "South");
        this.jPanel41.add((Component)this.statusBar, "Center");
        this.contentPane.add((Component)this.jPanel3, "Center");
        this.jPanel3.add((Component)this.jPanel1, "Center");
    }

    private void removeAttributes() {
        int[] selectedAttributes = this.jPanel1.getAttributePanel().getSelectedAttributes();
        int numAttributes = this.inst.numAttributes;
        int counter = 0;
        ArrayList<Boolean> removeAtt = new ArrayList<Boolean>(numAttributes);
        int i = 0;
        while (i < numAttributes) {
            removeAtt.add(true);
            ++i;
        }
        i = 0;
        while (i < selectedAttributes.length) {
            removeAtt.set(selectedAttributes[i], false);
            ++i;
        }
        int att = 0;
        int classIndex = this.inst.getClassIndex();
        while (att < numAttributes) {
            if (((Boolean)removeAtt.get(att)).booleanValue()) {
                this.inst.removeAttribute(att);
                removeAtt.remove(att);
                --numAttributes;
                if (classIndex == -1) continue;
                --classIndex;
                continue;
            }
            ++att;
        }
        this.inst.setClassIndex(classIndex);
        selectedAttributes = new int[counter];
        int i2 = 0;
        while (i2 < counter) {
            selectedAttributes[i2] = i2;
            ++i2;
        }
    }

    private void jMenuBuildSample_actionPerformed(ActionEvent e) {
        String saveDialogTitle = this.resource.getString("saveSample");
        File sampleFile = this.getFileFromUser(saveDialogTitle);
        if (sampleFile == null) {
            return;
        }
        this.setCursor(new Cursor(3));
        PreprocessorParameters askUser = new PreprocessorParameters(this, this.inst, true);
        float proportion = askUser.getSampleSize();
        proportion /= (float)this.inst.numWeightedInstances;
        boolean compact = askUser.isCompact();
        boolean canceled = askUser.isCanceled();
        int classIndex = askUser.getClassIndex();
        askUser = null;
        if (canceled) {
            return;
        }
        this.inst.buildSample(proportion, compact, classIndex);
        this.removeAttributes();
        this.jPanel1.setBaseInstances(this.inst);
        int[] selectedAttributes = this.jPanel1.getAttributePanel().getSelectedAttributes();
        this.saveFile(sampleFile, selectedAttributes, this.inst);
        File dir = this.fileChooser.getCurrentDirectory();
        FileController.getInstance().setCurrentDirectory(dir);
        this.jPanel1.setBaseInstances(this.inst);
        String fileName = sampleFile.getName();
        this.setTitle(String.valueOf(this.resource.getString("preprocessorTitle")) + fileName);
        this.statusBar.setText(this.resource.getString("sampleCreated"));
        this.setCursor(new Cursor(0));
    }

    private void jMenuFileTestTrainingSet_actionPerformed(ActionEvent e) {
        String saveDialogTitle = this.resource.getString("saveTrainingFile");
        File trainingFile = this.getFileFromUser(saveDialogTitle);
        if (trainingFile == null) {
            return;
        }
        saveDialogTitle = this.resource.getString("saveTestFile");
        File testFile = this.getFileFromUser(saveDialogTitle);
        if (testFile == null) {
            return;
        }
        this.setCursor(new Cursor(3));
        PreprocessorParameters askUser = new PreprocessorParameters(this, this.inst, false);
        float proportion = askUser.getSampleSize();
        boolean compact = askUser.isCompact();
        boolean canceled = askUser.isCanceled();
        int classIndex = askUser.getClassIndex();
        askUser = null;
        if (canceled) {
            return;
        }
        this.removeAttributes();
        InstanceSet trainSet = this.inst;
        this.jPanel1.setBaseInstances(trainSet);
        InstanceSet testSet = trainSet.buildTrainTestSet(proportion, compact, classIndex);
        int[] selectedAttributes = this.jPanel1.getAttributePanel().getSelectedAttributes();
        this.saveFile(trainingFile, selectedAttributes, trainSet);
        this.saveFile(testFile, selectedAttributes, testSet);
        File dir = this.fileChooser.getCurrentDirectory();
        FileController.getInstance().setCurrentDirectory(dir);
        this.jPanel1.setBaseInstances(trainSet);
        String fileName = trainingFile.getName();
        this.setTitle(String.valueOf(this.resource.getString("preprocessorTitle")) + fileName);
        this.statusBar.setText(this.resource.getString("fileTestTrainingCreated"));
        this.setCursor(new Cursor(0));
    }

    public void jMenuFileExit_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    public void jMenuHelpAbout_actionPerformed(ActionEvent e) {
        try {
            JavaHelperController.getInstance().openHelp(this);
        }
        catch (Exception evt) {
            this.statusBar.setText(String.valueOf(this.resource.getString("errorException")) + evt.getMessage() + " " + this.getClass().getName());
        }
    }

    void saveButton_actionPerformed(ActionEvent e) {
        int[] selectedAttributes = this.jPanel1.getAttributePanel().getSelectedAttributes();
        if (selectedAttributes.length == 0) {
            this.statusBar.setText("Nenhum atributo selecionado");
            return;
        }
        String SaveDialogTitle = this.resource.getString("saveFile");
        File selectedFile = this.getFileFromUser(SaveDialogTitle);
        if (selectedFile != null) {
            this.saveFile(selectedFile, selectedAttributes, this.inst);
            FileController.getInstance().setCurrentDirectory(this.fileChooser.getCurrentDirectory());
        }
    }

    private File getFileFromUser(String dialogTitle) {
        this.setCursor(new Cursor(3));
        String[] s1 = new String[]{"ARFF"};
        String[] s2 = new String[]{"TXT"};
        this.fileChooser = new JFileChooser(FileController.getInstance().getCurrentDirectory());
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setFileView(new FileIcon(this));
        this.fileChooser.setDialogTitle(dialogTitle);
        this.fileChooser.addChoosableFileFilter(new SimpleFileFilter(s2, "TxtFiles (*.txt)"));
        this.fileChooser.addChoosableFileFilter(new SimpleFileFilter(s1, "ArffFiles (*.arff)"));
        int returnVal = this.fileChooser.showSaveDialog(this);
        File selectedFile = returnVal == 0 ? this.fileChooser.getSelectedFile() : null;
        this.setCursor(new Cursor(0));
        return selectedFile;
    }

    private void saveFile(File selectedFile, int[] selectedAttributes, InstanceSet instanceSet) {
        try {
            String fileName = selectedFile.getName();
            String selectedFilter = this.fileChooser.getFileFilter().getDescription();
            if (selectedFilter.equals("TxtFiles (*.txt)")) {
                if (!fileName.regionMatches(true, fileName.length() - 4, ".txt", 0, 4)) {
                    selectedFile = new File(String.valueOf(selectedFile.getAbsolutePath()) + ".txt");
                }
            } else if (selectedFilter.equals("ArffFiles (*.arff)") && !fileName.regionMatches(true, fileName.length() - 5, ".arff", 0, 5)) {
                selectedFile = new File(String.valueOf(selectedFile.getAbsolutePath()) + ".arff");
            }
            FileController.getInstance().saveInstanceSet(selectedFile, instanceSet, selectedAttributes);
            this.statusBar.setText("Arquivo salvo com sucesso");
        }
        catch (IOException ioe) {
            this.statusBar.setText(String.valueOf(this.resource.getString("errorWritingFile")) + selectedFile.getName() + " " + ioe.getMessage());
        }
    }

    void openButton_actionPerformed(ActionEvent e) {
        this.setCursor(new Cursor(3));
        String[] s1 = new String[]{"ARFF"};
        String[] s2 = new String[]{"TXT"};
        this.fileChooser = new JFileChooser(FileController.getInstance().getCurrentDirectory());
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setFileView(new FileIcon(this));
        this.fileChooser.addChoosableFileFilter(new SimpleFileFilter(s2, "TxtFiles (*.txt)"));
        this.fileChooser.addChoosableFileFilter(new SimpleFileFilter(s1, "ArffFiles (*.arff)"));
        int returnVal = this.fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File selectedFile = this.fileChooser.getSelectedFile();
            this.openFile(selectedFile);
            FileController.getInstance().setCurrentDirectory(this.fileChooser.getCurrentDirectory());
        }
        this.setCursor(new Cursor(0));
    }

    private void openFile(File selectedFile) {
        try {
            this.saveButton.setEnabled(false);
            this.jMenuFileSave.setEnabled(false);
            this.jMenuFileTestTrainingSet.setEnabled(false);
            this.jMenuBuildSample.setEnabled(false);
            this.inst = FileController.getInstance().getInstanceSet(selectedFile, this);
            if (this.inst != null) {
                String fileName = selectedFile.getName();
                this.jPanel1.setBaseInstances(this.inst);
                this.statusBar.setText(this.resource.getString("fileOpened"));
                this.setTitle(String.valueOf(this.resource.getString("preprocessorTitle")) + fileName);
                this.saveButton.setEnabled(true);
                this.jMenuFileSave.setEnabled(true);
                this.jMenuFileTestTrainingSet.setEnabled(true);
                this.jMenuBuildSample.setEnabled(true);
            } else {
                this.statusBar.setText("Opera\ufffd\ufffdo cancelada");
            }
        }
        catch (FileNotFoundException fnfe) {
            this.statusBar.setText(String.valueOf(this.resource.getString("fileNotFound")) + selectedFile.getName() + " " + fnfe.getMessage());
        }
        catch (IOException ioe) {
            this.statusBar.setText(String.valueOf(this.resource.getString("errorOpen")) + selectedFile.getName() + " " + ioe.getMessage());
        }
        catch (Exception ex) {
            this.statusBar.setText(String.valueOf(this.resource.getString("error")) + ex.getMessage());
        }
    }

    public void updateInstances(InstanceSet inst) {
        this.inst = inst;
        this.jPanel1.setBaseInstances(inst);
    }

    public void setStatusBar(String text) {
        this.statusBar.setText(text);
    }

    void jMenuFileOpen_actionPerformed(ActionEvent e) {
        this.openButton_actionPerformed(e);
    }

    void helpButton_actionPerformed(ActionEvent e) {
        this.jMenuHelpAbout_actionPerformed(e);
    }
}

