/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.gui.preprocessor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import unbbayes.datamining.datamanipulation.InstanceSet;

public class AttributeSelectionPanel
extends JPanel {
    private static final long serialVersionUID = 0L;
    private ResourceBundle resource;
    protected JTable m_Table = new JTable();
    protected AttributeTableModel m_Model;

    public AttributeSelectionPanel() {
        this.resource = ResourceBundle.getBundle("unbbayes.datamining.gui.preprocessor.resources.PreprocessorResource");
        this.m_Table.setSelectionMode(0);
        this.m_Table.getTableHeader().setReorderingAllowed(false);
        this.m_Table.getTableHeader().setResizingAllowed(false);
        this.m_Table.setColumnSelectionAllowed(false);
        this.m_Table.setPreferredScrollableViewportSize(new Dimension(250, 150));
        this.m_Table.setToolTipText(this.resource.getString("selectedAttributes"));
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.m_Table), "Center");
    }

    public void setInstances(InstanceSet newInstances) {
        if (this.m_Model == null) {
            this.m_Model = new AttributeTableModel(newInstances);
            this.m_Table.setModel(this.m_Model);
            TableColumnModel tcm = this.m_Table.getColumnModel();
            tcm.getColumn(0).setMaxWidth(60);
            tcm.getColumn(1).setMaxWidth(tcm.getColumn(1).getMinWidth());
            tcm.getColumn(2).setMinWidth(100);
        } else {
            this.m_Model.setInstances(newInstances);
            this.m_Table.clearSelection();
        }
        this.m_Table.sizeColumnsToFit(2);
        this.m_Table.revalidate();
        this.m_Table.repaint();
    }

    public int[] getSelectedAttributes() {
        return this.m_Model.getSelectedAttributes();
    }

    public ListSelectionModel getSelectionModel() {
        return this.m_Table.getSelectionModel();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AttributeTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 0L;
        protected InstanceSet m_Instances;
        protected boolean[] m_Selected;

        public AttributeTableModel(InstanceSet instances) {
            this.setInstances(instances);
        }

        public void setInstances(InstanceSet instances) {
            this.m_Instances = instances;
            this.m_Selected = new boolean[this.m_Instances.numAttributes()];
            int i = 0;
            while (i < this.m_Selected.length) {
                this.m_Selected[i] = true;
                ++i;
            }
        }

        @Override
        public int getRowCount() {
            return this.m_Selected.length;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return new Integer(row + 1);
                }
                case 1: {
                    return new Boolean(this.m_Selected[row]);
                }
                case 2: {
                    return this.m_Instances.getAttribute(row).getAttributeName();
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return new String("No.");
                }
                case 1: {
                    return new String("");
                }
                case 2: {
                    return new String(AttributeSelectionPanel.this.resource.getString("name2"));
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 1) {
                this.m_Selected[row] = (Boolean)value;
            }
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return this.getValueAt(0, col).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        public int[] getSelectedAttributes() {
            int[] r1 = new int[this.getRowCount()];
            int selCount = 0;
            int i = 0;
            while (i < this.getRowCount()) {
                if (this.m_Selected[i]) {
                    r1[selCount++] = i;
                }
                ++i;
            }
            int[] result = new int[selCount];
            System.arraycopy(r1, 0, result, 0, selCount);
            return result;
        }
    }
}

