/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.gui.neuralnetwork;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import ptolemy.plot.Plot;
import unbbayes.controller.IconController;
import unbbayes.datamining.classifiers.neuralnetwork.MeanSquaredError;

public class TrainingPanel
extends JPanel
implements MeanSquaredError {
    private static final long serialVersionUID = 0L;
    private ResourceBundle resource;
    private ImageIcon fillIcon;
    private ImageIcon resetSizeIcon;
    private ImageIcon gridIcon;
    private ImageIcon printIcon;
    private IconController iconController = IconController.getInstance();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel trainingPanel = new JPanel();
    private BorderLayout borderLayout2 = new BorderLayout();
    private Plot chart = new Plot();
    private boolean firstPoint = true;
    private JToolBar jToolBar1 = new JToolBar();
    private JButton buttonFill = new JButton();
    private JButton buttonPrint = new JButton();
    private JButton buttonGrid = new JButton();
    private JButton buttonReset = new JButton();
    private JLabel spaceLabel = new JLabel();

    public TrainingPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.resource = ResourceBundle.getBundle("unbbayes.datamining.gui.neuralnetwork.resources.NeuralNetworkResource");
        this.fillIcon = this.iconController.getFillIcon();
        this.resetSizeIcon = this.iconController.getResetSizeIcon();
        this.gridIcon = this.iconController.getGridIcon();
        this.printIcon = this.iconController.getPrintIcon();
        this.setLayout(this.borderLayout1);
        this.trainingPanel.setLayout(this.borderLayout2);
        this.buttonFill.setToolTipText(this.resource.getString("fillToolTip"));
        this.buttonFill.setIcon(this.fillIcon);
        this.buttonFill.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TrainingPanel.this.buttonFill_actionPerformed(e);
            }
        });
        this.jToolBar1.setBorder(BorderFactory.createEtchedBorder());
        this.jToolBar1.setFloatable(false);
        this.buttonPrint.setToolTipText(this.resource.getString("printToolTip"));
        this.buttonPrint.setIcon(this.printIcon);
        this.buttonPrint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TrainingPanel.this.buttonPrint_actionPerformed(e);
            }
        });
        this.buttonGrid.setToolTipText(this.resource.getString("gridToolTip"));
        this.buttonGrid.setIcon(this.gridIcon);
        this.buttonGrid.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TrainingPanel.this.buttonGrid_actionPerformed(e);
            }
        });
        this.buttonReset.setToolTipText(this.resource.getString("resetButtonToolTip"));
        this.buttonReset.setIcon(this.resetSizeIcon);
        this.buttonReset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TrainingPanel.this.buttonReset_actionPerformed(e);
            }
        });
        this.spaceLabel.setText("  ");
        this.jToolBar1.add((Component)this.buttonFill, null);
        this.jToolBar1.add((Component)this.buttonReset, null);
        this.jToolBar1.add((Component)this.buttonGrid, null);
        this.jToolBar1.add((Component)this.spaceLabel, null);
        this.jToolBar1.add((Component)this.buttonPrint, null);
        this.add((Component)this.trainingPanel, "Center");
        this.trainingPanel.add((Component)this.chart, "Center");
        this.trainingPanel.add((Component)this.jToolBar1, "North");
        this.chart.setSize(400, 300);
        this.chart.setTitle(this.resource.getString("chartTitle"));
        this.chart.setYRange(0.0, 0.5);
        this.chart.setXRange(0.0, 1000.0);
        this.chart.setYLabel(this.resource.getString("YAxisTitle"));
        this.chart.setXLabel(this.resource.getString("XAxisTitle"));
        this.chart.fillPlot();
    }

    public void setMeanSquaredError(int epoch, double meanSquaredError) {
        this.addPoint(epoch, meanSquaredError);
    }

    private void addPoint(double x, double y) {
        if (this.firstPoint) {
            this.chart.addPoint(0, x, y, false);
            this.firstPoint = false;
        } else {
            this.chart.addPoint(0, x, y, true);
        }
    }

    public void clear() {
        this.chart.clear(true);
        this.firstPoint = true;
    }

    void buttonFill_actionPerformed(ActionEvent e) {
        this.chart.fillPlot();
    }

    void buttonReset_actionPerformed(ActionEvent e) {
        this.chart.resetAxes();
    }

    void buttonGrid_actionPerformed(ActionEvent e) {
        this.chart.setGrid(!this.chart.getGrid());
        this.chart.repaint();
    }

    void buttonPrint_actionPerformed(ActionEvent e) {
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat format = job.pageDialog(job.defaultPage());
        job.setPrintable((Printable)this.chart, format);
        if (job.printDialog()) {
            try {
                job.print();
            }
            catch (Exception ex) {
                Container ancestor = this.getTopLevelAncestor();
                JOptionPane.showMessageDialog(ancestor, String.valueOf(this.resource.getString("printingFailed")) + "\n" + ex.toString(), "Print Error", 2);
            }
        }
    }
}

