/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.gui.neuralnetwork;

import java.awt.Cursor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ResourceBundle;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import unbbayes.controller.FileController;
import unbbayes.controller.JavaHelperController;
import unbbayes.datamining.classifiers.NeuralNetwork;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.gui.neuralnetwork.NeuralNetworkMain;
import unbbayes.gui.FileIcon;
import unbbayes.gui.SimpleFileFilter;

public class NeuralNetworkController {
    private ResourceBundle resource = ResourceBundle.getBundle("unbbayes.datamining.gui.neuralnetwork.resources.NeuralNetworkResource");
    private NeuralNetwork bpn = null;
    private NeuralNetworkMain mainScreen = new NeuralNetworkMain();
    private JFileChooser fileChooser;
    private InstanceSet instanceSet;
    private File file;
    private int hiddenLayerSize;

    public NeuralNetworkController() {
        this.mainScreen.setController(this);
    }

    public JInternalFrame getMainFrame() {
        return this.mainScreen;
    }

    public void help() throws Exception {
        JavaHelperController.getInstance().openHelp(this.mainScreen);
    }

    public void learn() throws Exception {
        this.mainScreen.setCursor(new Cursor(3));
        if (this.instanceSet != null) {
            float learningRate = this.mainScreen.optionsPanel.getLearningRate();
            boolean learningRateDecay = this.mainScreen.advancedOptionsPanel.getLearningRateDecayEnabled();
            float momentum = this.mainScreen.optionsPanel.getMomentum();
            int hiddenSize = this.mainScreen.advancedOptionsPanel.getHiddenLayerSize();
            int activationFunction = this.mainScreen.optionsPanel.getSelectedActivationFunction();
            int trainningTime = this.mainScreen.advancedOptionsPanel.getTrainningTime();
            int numerialInputNormalization = this.mainScreen.advancedOptionsPanel.getNumericalInputNormalization();
            float activationFunctionSteep = (float)this.mainScreen.advancedOptionsPanel.getActivationFunctionSteep();
            float minimumErrorVariation = (float)this.mainScreen.advancedOptionsPanel.getMinimumErrorVariation();
            this.bpn = new NeuralNetwork(learningRate, learningRateDecay, momentum, hiddenSize, activationFunction, trainningTime, numerialInputNormalization, activationFunctionSteep, minimumErrorVariation);
            this.bpn.setMeanSquaredErrorOutput(this.mainScreen.chartPanel);
            this.bpn.buildClassifier(this.instanceSet);
            this.mainScreen.inferencePanel.setNetwork(this.bpn);
        }
        this.mainScreen.setCursor(new Cursor(0));
    }

    public boolean openFile() throws Exception {
        this.mainScreen.setCursor(new Cursor(3));
        String[] arff = new String[]{"ARFF"};
        String[] txt = new String[]{"TXT"};
        boolean fileOpenSuccess = false;
        this.fileChooser = new JFileChooser(FileController.getInstance().getCurrentDirectory());
        this.fileChooser.setDialogTitle(this.resource.getString("openFile2"));
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setFileView(new FileIcon(this.mainScreen));
        this.fileChooser.addChoosableFileFilter(new SimpleFileFilter(txt, String.valueOf(this.resource.getString("txtFiles")) + " (*.txt)"));
        this.fileChooser.addChoosableFileFilter(new SimpleFileFilter(arff, String.valueOf(this.resource.getString("arffFiles")) + " (*.arff)"));
        int returnValue = this.fileChooser.showOpenDialog(this.mainScreen);
        if (returnValue == 0) {
            File selectedFile = this.fileChooser.getSelectedFile();
            this.openSelectedFile(selectedFile);
            this.file = selectedFile;
            FileController.getInstance().setCurrentDirectory(this.fileChooser.getCurrentDirectory());
            fileOpenSuccess = true;
        }
        this.mainScreen.setCursor(new Cursor(0));
        return fileOpenSuccess;
    }

    private void openSelectedFile(File selectedFile) throws Exception {
        this.instanceSet = FileController.getInstance().getInstanceSet(selectedFile, this.mainScreen);
        this.mainScreen.setTitle("Backpropagation Neural Network - " + selectedFile.getName());
        this.mainScreen.attributePanel.setInstances(this.instanceSet);
        this.mainScreen.attributePanel.enableComboBox(true);
        this.hiddenLayerSize = (this.instanceSet.numAttributes() + 1) / 2;
        if (this.hiddenLayerSize < 3) {
            this.hiddenLayerSize = 3;
        }
    }

    public int getHiddenLayerSize() {
        return this.hiddenLayerSize;
    }

    public boolean saveModel() throws Exception {
        this.mainScreen.setCursor(new Cursor(3));
        String[] bpnString = new String[]{"bpn"};
        boolean success = false;
        this.fileChooser = new JFileChooser(FileController.getInstance().getCurrentDirectory());
        this.fileChooser.setDialogTitle(this.resource.getString("saveModel2"));
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setFileView(new FileIcon(this.mainScreen));
        this.fileChooser.addChoosableFileFilter(new SimpleFileFilter(bpnString, "Neural Network (*.bpn)"));
        int returnVal = this.fileChooser.showSaveDialog(this.mainScreen);
        if (returnVal == 0) {
            File selectedFile = this.fileChooser.getSelectedFile();
            String fileName = selectedFile.getName();
            if (!fileName.regionMatches(true, fileName.length() - 4, ".bpn", 0, 4)) {
                selectedFile = new File(String.valueOf(selectedFile.getAbsolutePath()) + ".bpn");
            }
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(selectedFile));
            out.writeObject(this.bpn);
            FileController.getInstance().setCurrentDirectory(this.fileChooser.getCurrentDirectory());
            success = true;
        }
        this.mainScreen.setCursor(new Cursor(0));
        return success;
    }

    public boolean openModel() throws Exception {
        this.mainScreen.setCursor(new Cursor(3));
        String[] neuralNetworkString = new String[]{"bpn"};
        boolean success = false;
        this.fileChooser = new JFileChooser(FileController.getInstance().getCurrentDirectory());
        this.fileChooser.setDialogTitle(this.resource.getString("openModel2"));
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setFileView(new FileIcon(this.mainScreen));
        this.fileChooser.addChoosableFileFilter(new SimpleFileFilter(neuralNetworkString, "Neural Network (*.bpn)"));
        int returnVal = this.fileChooser.showOpenDialog(this.mainScreen);
        if (returnVal == 0) {
            File selectedFile = this.fileChooser.getSelectedFile();
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(selectedFile));
            this.bpn = null;
            this.bpn = (NeuralNetwork)in.readObject();
            this.mainScreen.inferencePanel.setNetwork(this.bpn);
            this.mainScreen.setTitle("Backpropagation Neural Network - " + this.resource.getString("model") + " " + selectedFile.getName());
            FileController.getInstance().setCurrentDirectory(this.fileChooser.getCurrentDirectory());
            this.file = selectedFile;
            success = true;
        }
        this.mainScreen.setCursor(new Cursor(0));
        return success;
    }
}

