/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.gui.evaluation.batchEvaluation.controllers;

import java.awt.Cursor;
import java.io.File;
import java.util.ResourceBundle;
import unbbayes.controller.JavaHelperController;
import unbbayes.datamining.datamanipulation.FileUtils;
import unbbayes.datamining.evaluation.batchEvaluation.BatchEvaluation;
import unbbayes.datamining.gui.evaluation.batchEvaluation.BatchEvaluationMain;

public class BatchEvaluationMainController {
    private static final long serialVersionUID = 1L;
    private ResourceBundle resource;
    private BatchEvaluationMain view;
    private BatchEvaluation model;

    public BatchEvaluationMainController(BatchEvaluationMain view) {
        this.view = view;
        this.resource = view.getResourceBundle();
        this.model = new BatchEvaluation();
    }

    public void fileExit() {
        this.view.dispose();
    }

    public void openScript() {
        String[] returnStatus = new String[1];
        File file = FileUtils.openBevFile(this.view, returnStatus);
        this.view.setStatusBar(returnStatus[0]);
        if (file == null) {
            return;
        }
        String returnValue = this.model.openScript(file);
        if (returnValue == null) {
            this.view.setStatusBar(returnStatus[0]);
        } else {
            this.view.setStatusBar(returnValue);
        }
        this.view.getDatasetsTabController().updateData();
        this.view.getPreprocessorsTabController().updateData();
        this.view.getClassifiersTabController().updateData();
        this.view.getEvaluationsTabController().updateData();
    }

    public void saveScript() {
        String[] returnStatus = new String[1];
        File file = FileUtils.saveBevFile(this.view, returnStatus);
        if (file == null) {
            return;
        }
        String returnValue = this.model.saveScript(file);
        if (returnValue == null) {
            this.view.setStatusBar(returnStatus[0]);
        } else {
            this.view.setStatusBar(returnValue);
        }
    }

    public void runScript() {
        this.view.setCursor(new Cursor(3));
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    BatchEvaluationMainController.this.view.disableFunctions();
                    BatchEvaluationMainController.this.view.setStatusBar(BatchEvaluationMainController.this.resource.getString("runScriptRunning"));
                    BatchEvaluationMainController.this.model.runScript(BatchEvaluationMainController.this.view.getLogsTabController());
                    BatchEvaluationMainController.this.view.setStatusBar(BatchEvaluationMainController.this.resource.getString("runScriptSuccess"));
                }
                catch (Exception e) {
                    BatchEvaluationMainController.this.view.setStatusBar(String.valueOf(BatchEvaluationMainController.this.resource.getString("runScriptError")) + " " + e.getMessage() + ": " + this.getClass().getName());
                    e.printStackTrace();
                }
                BatchEvaluationMainController.this.view.enableFunctions();
            }
        });
        t.start();
        this.view.setCursor(new Cursor(0));
    }

    public ResourceBundle getResourceBundle() {
        return this.resource;
    }

    public BatchEvaluation getModel() {
        if (this.model == null) {
            this.model = new BatchEvaluation();
        }
        return this.model;
    }

    public void help() {
        try {
            JavaHelperController.getInstance().openHelp(this.view);
        }
        catch (Exception evt) {
            this.view.setStatusBar(String.valueOf(this.resource.getString("helpError")) + " " + evt.getMessage() + " " + this.getClass().getName());
        }
    }
}

