/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.gui.evaluation.batchEvaluation;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import net.miginfocom.layout.CC;
import net.miginfocom.swing.MigLayout;
import unbbayes.datamining.evaluation.batchEvaluation.BatchEvaluation;
import unbbayes.datamining.evaluation.batchEvaluation.model.Preprocessors;
import unbbayes.datamining.gui.UtilsGUI;
import unbbayes.datamining.gui.evaluation.batchEvaluation.BatchEvaluationMain;
import unbbayes.datamining.gui.evaluation.batchEvaluation.controllers.PreprocessorsTabController;

public class PreprocessorsTab {
    private String tabTitle;
    private ResourceBundle resource;
    private BatchEvaluationMain mainView;
    private PreprocessorsTabController controller;
    private UtilsGUI utilsGUI;
    private UtilsGUI.EachRowEditor rowEditorPreprocessor;
    private UtilsGUI.EachRowRenderer rowRendererPreprocessor;
    private Preprocessors data;
    private JTable table;

    public PreprocessorsTab(BatchEvaluationMain mainView, BatchEvaluation model) {
        this.mainView = mainView;
        this.utilsGUI = new UtilsGUI();
        this.resource = mainView.getResourceBundle();
        this.tabTitle = this.resource.getString("preprocessorsTabTitle");
        this.controller = new PreprocessorsTabController(this, model);
        this.data = this.controller.getData();
    }

    public String getTabTitle() {
        return this.tabTitle;
    }

    protected JPanel getTabPanel() throws Exception {
        JPanel panel = new JPanel((LayoutManager)new MigLayout());
        this.table = this.gettable();
        JScrollPane dataTableScroll = new JScrollPane(this.table);
        dataTableScroll.setPreferredSize(new Dimension(1000, 150));
        panel.add((Component)dataTableScroll, "North");
        panel.add((Component)new JSeparator(), "growx, wrap, gaptop 10");
        String newButtonText = this.resource.getString("newButtonText");
        JButton newButton = new JButton(newButtonText);
        newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreprocessorsTab.this.controller.insertData(PreprocessorsTab.this.data.getRowCount());
            }
        });
        String deleteButtonText = this.resource.getString("deleteButtonText");
        JButton deleteButton = new JButton(deleteButtonText);
        deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreprocessorsTab.this.removeRow();
            }
        });
        String configButtonText = this.resource.getString("configurationButtonText");
        JButton configButton = new JButton(configButtonText);
        configButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreprocessorsTab.this.controller.preprocessorConfig(PreprocessorsTab.this.table.getSelectedRow());
            }
        });
        panel.add((Component)newButton, new CC().spanX(4).split(4).tag("other"));
        panel.add((Component)deleteButton, new CC().tag("other"));
        panel.add((Component)configButton, new CC().tag("other"));
        return panel;
    }

    public void loadPreprocessorData() {
        UtilsGUI utilsGUI = this.utilsGUI;
        utilsGUI.getClass();
        this.rowEditorPreprocessor = new UtilsGUI.EachRowEditor(utilsGUI, this.table);
        this.rowRendererPreprocessor = new UtilsGUI.EachRowRenderer(this.utilsGUI);
        this.data = this.controller.getData();
        DefaultTableModel PreprocessorModel = (DefaultTableModel)this.table.getModel();
        this.updateColumnModel();
        PreprocessorModel.fireTableDataChanged();
    }

    public void updateColumnModel() {
        int numRows = this.table.getRowCount();
        int row = 0;
        while (row < numRows) {
            String[] preprocessorNames = this.data.getPreprocessorNames();
            this.changeColumnModel(preprocessorNames, row);
            ++row;
        }
    }

    private void changeColumnModel(String[] preprocessorNames, int row) {
        TableColumnModel columnModel = this.table.getColumnModel();
        UtilsGUI utilsGUI = this.utilsGUI;
        utilsGUI.getClass();
        this.rowEditorPreprocessor.setEditorAt(row, new UtilsGUI.ComboBoxEditor(utilsGUI, preprocessorNames));
        UtilsGUI utilsGUI2 = this.utilsGUI;
        utilsGUI2.getClass();
        this.rowRendererPreprocessor.add(row, new UtilsGUI.ComboBoxRenderer(utilsGUI2, preprocessorNames));
        columnModel.getColumn(1).setCellEditor(this.rowEditorPreprocessor);
        columnModel.getColumn(1).setCellRenderer(this.rowRendererPreprocessor);
    }

    public void addRow(Object[] dataTableEntry, String[] preprocessorNames) {
        DefaultTableModel PreprocessorModel = (DefaultTableModel)this.table.getModel();
        PreprocessorModel.addRow(dataTableEntry);
        int row = this.table.getRowCount() - 1;
        this.changeColumnModel(preprocessorNames, row);
        this.table.changeSelection(row, 0, false, false);
        this.table.requestFocusInWindow();
    }

    public void removeRow() {
        if (this.table.getRowCount() > 0) {
            DefaultTableModel PreprocessorModel = (DefaultTableModel)this.table.getModel();
            int row = this.table.getSelectedRow();
            PreprocessorModel.removeRow(row);
            this.rowEditorPreprocessor.remove(row);
            this.rowRendererPreprocessor.remove(row);
            int rowFocus = this.table.getRowCount() - 1;
            this.table.changeSelection(rowFocus, 0, false, false);
            this.table.requestFocusInWindow();
        }
    }

    private JTable gettable() {
        DefaultTableModel PreprocessorModel = new DefaultTableModel(){
            private static final long serialVersionUID = 1L;

            public String getColumnName(int col) {
                return PreprocessorsTab.this.data.getColumnName(col);
            }

            public int getColumnCount() {
                return PreprocessorsTab.this.data.getColumnCount();
            }

            public int getRowCount() {
                return PreprocessorsTab.this.data.getRowCount();
            }

            public void addRow(Object[] rowData) {
                PreprocessorsTab.this.data.addRow(rowData);
                super.fireTableDataChanged();
            }

            public void removeRow(int row) {
                if (row >= 0) {
                    PreprocessorsTab.this.data.removePreprocessor(row);
                    super.fireTableDataChanged();
                }
            }

            public Object getValueAt(int row, int col) {
                return PreprocessorsTab.this.data.getValueAt(row, col);
            }

            public void setValueAt(Object value, int row, int col) {
                PreprocessorsTab.this.data.setValueAt(value, row, col);
                this.fireTableCellUpdated(row, col);
            }

            public boolean isCellEditable(int row, int col) {
                return true;
            }
        };
        JTable table = new JTable(PreprocessorModel);
        UtilsGUI utilsGUI = this.utilsGUI;
        utilsGUI.getClass();
        this.rowEditorPreprocessor = new UtilsGUI.EachRowEditor(utilsGUI, table);
        this.rowRendererPreprocessor = new UtilsGUI.EachRowRenderer(this.utilsGUI);
        TableColumnModel columnModel = table.getColumnModel();
        columnModel.getColumn(0).setCellEditor(new UtilsGUI.CheckBoxEditor());
        columnModel.getColumn(0).setCellRenderer(new UtilsGUI.CheckBoxRenderer(this.utilsGUI));
        table.setAutoResizeMode(0);
        table.setSelectionMode(0);
        int width = 50;
        table.getColumnModel().getColumn(0).setPreferredWidth(width);
        width = 400;
        table.getColumnModel().getColumn(1).setPreferredWidth(width);
        table.getTableHeader().setReorderingAllowed(false);
        table.setRowHeight(table.getRowHeight() + 5);
        return table;
    }

    public PreprocessorsTabController getController() {
        return this.controller;
    }

    public void updateData() {
        UtilsGUI utilsGUI = this.utilsGUI;
        utilsGUI.getClass();
        this.rowEditorPreprocessor = new UtilsGUI.EachRowEditor(utilsGUI, this.table);
        this.rowRendererPreprocessor = new UtilsGUI.EachRowRenderer(this.utilsGUI);
        this.data = this.controller.getData();
        DefaultTableModel datasetModel = (DefaultTableModel)this.table.getModel();
        this.updateColumnModel();
        datasetModel.fireTableDataChanged();
    }

    public BatchEvaluationMain getMainView() {
        return this.mainView;
    }

    public String getSelectedPreprocessorName() {
        return (String)this.table.getValueAt(this.table.getSelectedRow(), 1);
    }
}

