/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.gui.evaluation.batchEvaluation;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import unbbayes.datamining.evaluation.batchEvaluation.PreprocessorParameters;
import unbbayes.datamining.gui.UtilsGUI;
import unbbayes.datamining.gui.evaluation.batchEvaluation.controllers.PreprocessorsTabController;

public class PreprocessorsParameters
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle resource;
    private Component parent;
    private String windowTitle;
    private JTextField ratioStart;
    private JTextField ratioEnd;
    private JTextField ratioStep;
    private JTextField clustersStart;
    private JTextField clustersEnd;
    private JTextField clustersStep;
    private JTextField oversamplingThresholdStart;
    private JTextField oversamplingThresholdEnd;
    private JTextField oversamplingThresholdStep;
    private JTextField positiveThresholdStart;
    private JTextField positiveThresholdEnd;
    private JTextField positiveThresholdStep;
    private JTextField negativeThresholdStart;
    private JTextField negativeThresholdEnd;
    private JTextField negativeThresholdStep;
    private JComboBox cleanType;
    private PreprocessorParameters parameters;

    public PreprocessorsParameters(PreprocessorsTabController controller, Component parent) {
        this.parent = parent;
        resource = controller.getResourceBundle();
        this.windowTitle = resource.getString("preprocessorsOptionsTitle");
    }

    public void run(PreprocessorParameters parameters) {
        this.parameters = parameters;
        JPanel principalPanel = this.buildWindow();
        if (JOptionPane.showInternalConfirmDialog(this.parent, principalPanel, this.windowTitle, 2, -1) == 0) {
            this.setParameters();
        }
    }

    private JPanel buildWindow() {
        JPanel principalPanel = new JPanel((LayoutManager)new MigLayout());
        String ratioLabel = resource.getString("ratio");
        String clustersLabel = resource.getString("cluster");
        String oversamplingThresholdLabel = resource.getString("oversamplingThreshold");
        String positiveThresholdLabel = resource.getString("positiveThreshold");
        String negativeThresholdLabel = resource.getString("negativeThreshold");
        String cleanLabel = resource.getString("cleanType");
        String cleanActivated = resource.getString("cleanActivated");
        String cleanDeactivated = resource.getString("cleanDeactivated");
        String cleanBoth = resource.getString("cleanBoth");
        String startLabel = resource.getString("start");
        String endLabel = resource.getString("end");
        String stepLabel = resource.getString("step");
        UtilsGUI.addSeparator(principalPanel, ratioLabel);
        this.ratioStart = UtilsGUI.createTextField(2);
        this.ratioEnd = UtilsGUI.createTextField(2);
        this.ratioStep = UtilsGUI.createTextField(2);
        principalPanel.add((Component)UtilsGUI.createLabel(startLabel), "gap para");
        principalPanel.add(this.ratioStart);
        principalPanel.add((Component)UtilsGUI.createLabel(endLabel), "gap para");
        principalPanel.add(this.ratioEnd);
        principalPanel.add((Component)UtilsGUI.createLabel(stepLabel), "gap para");
        principalPanel.add((Component)this.ratioStep, "wrap para");
        UtilsGUI.addSeparator(principalPanel, clustersLabel);
        this.clustersStart = UtilsGUI.createTextField(2);
        this.clustersEnd = UtilsGUI.createTextField(2);
        this.clustersStep = UtilsGUI.createTextField(2);
        principalPanel.add((Component)UtilsGUI.createLabel(startLabel), "gap para");
        principalPanel.add(this.clustersStart);
        principalPanel.add((Component)UtilsGUI.createLabel(endLabel), "gap para");
        principalPanel.add(this.clustersEnd);
        principalPanel.add((Component)UtilsGUI.createLabel(stepLabel), "gap para");
        principalPanel.add((Component)this.clustersStep, "wrap para");
        UtilsGUI.addSeparator(principalPanel, oversamplingThresholdLabel);
        this.oversamplingThresholdStart = UtilsGUI.createTextField(2);
        this.oversamplingThresholdEnd = UtilsGUI.createTextField(2);
        this.oversamplingThresholdStep = UtilsGUI.createTextField(2);
        principalPanel.add((Component)UtilsGUI.createLabel(startLabel), "gap para");
        principalPanel.add(this.oversamplingThresholdStart);
        principalPanel.add((Component)UtilsGUI.createLabel(endLabel), "gap para");
        principalPanel.add(this.oversamplingThresholdEnd);
        principalPanel.add((Component)UtilsGUI.createLabel(stepLabel), "gap para");
        principalPanel.add((Component)this.oversamplingThresholdStep, "wrap para");
        UtilsGUI.addSeparator(principalPanel, positiveThresholdLabel);
        this.positiveThresholdStart = UtilsGUI.createTextField(2);
        this.positiveThresholdEnd = UtilsGUI.createTextField(2);
        this.positiveThresholdStep = UtilsGUI.createTextField(2);
        principalPanel.add((Component)UtilsGUI.createLabel(startLabel), "gap para");
        principalPanel.add(this.positiveThresholdStart);
        principalPanel.add((Component)UtilsGUI.createLabel(endLabel), "gap para");
        principalPanel.add(this.positiveThresholdEnd);
        principalPanel.add((Component)UtilsGUI.createLabel(stepLabel), "gap para");
        principalPanel.add((Component)this.positiveThresholdStep, "wrap para");
        UtilsGUI.addSeparator(principalPanel, negativeThresholdLabel);
        this.negativeThresholdStart = UtilsGUI.createTextField(2);
        this.negativeThresholdEnd = UtilsGUI.createTextField(2);
        this.negativeThresholdStep = UtilsGUI.createTextField(2);
        principalPanel.add((Component)UtilsGUI.createLabel(startLabel), "gap para");
        principalPanel.add(this.negativeThresholdStart);
        principalPanel.add((Component)UtilsGUI.createLabel(endLabel), "gap para");
        principalPanel.add(this.negativeThresholdEnd);
        principalPanel.add((Component)UtilsGUI.createLabel(stepLabel), "gap para");
        principalPanel.add((Component)this.negativeThresholdStep, "wrap para");
        UtilsGUI.addSeparator(principalPanel, cleanLabel);
        String[] cleanOptions = new String[]{cleanActivated, cleanDeactivated, cleanBoth};
        this.cleanType = UtilsGUI.createCombo(cleanOptions);
        principalPanel.add((Component)this.cleanType, "gapleft 15, span");
        this.setInitialValues();
        return principalPanel;
    }

    private void setParameters() {
        this.parameters.setRatioStart(Integer.parseInt(this.ratioStart.getText()));
        this.parameters.setRatioEnd(Integer.parseInt(this.ratioEnd.getText()));
        this.parameters.setRatioStep(Integer.parseInt(this.ratioStep.getText()));
        this.parameters.setClusterStart(Integer.parseInt(this.clustersStart.getText()));
        this.parameters.setClusterEnd(Integer.parseInt(this.clustersEnd.getText()));
        this.parameters.setClusterStep(Integer.parseInt(this.clustersStep.getText()));
        this.parameters.setOverThresholdStart(Integer.parseInt(this.oversamplingThresholdStart.getText()));
        this.parameters.setOverThresholdEnd(Integer.parseInt(this.oversamplingThresholdEnd.getText()));
        this.parameters.setOverThresholdStep(Integer.parseInt(this.oversamplingThresholdStep.getText()));
        this.parameters.setPosThresholdStart(Integer.parseInt(this.positiveThresholdStart.getText()));
        this.parameters.setPosThresholdEnd(Integer.parseInt(this.positiveThresholdEnd.getText()));
        this.parameters.setPosThresholdStep(Integer.parseInt(this.positiveThresholdStep.getText()));
        this.parameters.setNegThresholdStart(Integer.parseInt(this.negativeThresholdStart.getText()));
        this.parameters.setNegThresholdEnd(Integer.parseInt(this.negativeThresholdEnd.getText()));
        this.parameters.setNegThresholdStep(Integer.parseInt(this.negativeThresholdStep.getText()));
        this.parameters.setCleanType(this.cleanType.getSelectedIndex());
    }

    public void setInitialValues() {
        this.ratioStart.setText(Integer.toString(this.parameters.getRatioStart()));
        this.ratioEnd.setText(Integer.toString(this.parameters.getRatioEnd()));
        this.ratioStep.setText(Integer.toString(this.parameters.getRatioStep()));
        this.clustersStart.setText(Integer.toString(this.parameters.getClusterStart()));
        this.clustersEnd.setText(Integer.toString(this.parameters.getClusterEnd()));
        this.clustersStep.setText(Integer.toString(this.parameters.getClusterStep()));
        this.oversamplingThresholdStart.setText(Integer.toString(this.parameters.getOverThresholdStart()));
        this.oversamplingThresholdEnd.setText(Integer.toString(this.parameters.getOverThresholdEnd()));
        this.oversamplingThresholdStep.setText(Integer.toString(this.parameters.getOverThresholdStep()));
        this.positiveThresholdStart.setText(Integer.toString(this.parameters.getPosThresholdStart()));
        this.positiveThresholdEnd.setText(Integer.toString(this.parameters.getPosThresholdEnd()));
        this.positiveThresholdStep.setText(Integer.toString(this.parameters.getPosThresholdStep()));
        this.negativeThresholdStart.setText(Integer.toString(this.parameters.getNegThresholdStart()));
        this.negativeThresholdEnd.setText(Integer.toString(this.parameters.getNegThresholdEnd()));
        this.negativeThresholdStep.setText(Integer.toString(this.parameters.getNegThresholdStep()));
        this.cleanType.setSelectedIndex(this.parameters.getCleanType());
    }
}

