/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.gui;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import unbbayes.controller.IconController;
import unbbayes.datamining.datamanipulation.Attribute;
import unbbayes.datamining.datamanipulation.Instance;
import unbbayes.datamining.gui.IInferencePanel;
import unbbayes.util.ArrayMap;

public class AttributesTree
extends JTree {
    private static final long serialVersionUID = 0L;
    public static final int CHECK_YES = 1;
    public static final int CHECK_NO = -1;
    public static final int CHECK_EMPTY = 0;
    private ArrayMap<Object, Object> objectsMap = new ArrayMap();
    private Attribute[] attributeVector;
    private IInferencePanel inferencePanel;
    protected IconController iconController = IconController.getInstance();
    private AttributesTree attributesTree;
    private ResourceBundle resource = ResourceBundle.getBundle("unbbayes.datamining.gui.resources.GuiResource");

    public AttributesTree() {
        this.attributesTree = this;
        this.setShowsRootHandles(true);
        this.setSelectionModel(null);
        this.setRootVisible(true);
        this.setAutoscrolls(true);
        this.setCellRenderer(new CnmTreeCellRenderer());
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                AttributesTree.this.cnmTreeMouseClicked(evt);
            }
        });
        this.setEditable(true);
    }

    public AttributesTree(Attribute[] attributeVector, int classIndex) {
        this();
        this.setAttributes(attributeVector, classIndex);
    }

    public boolean isPathEditable(TreePath path) {
        if (this.isEditable()) {
            return this.getModel().isLeaf(path.getLastPathComponent());
        }
        return false;
    }

    public void setController(IInferencePanel inferencePanel) {
        this.inferencePanel = inferencePanel;
    }

    /*
     * Could not resolve type clashes
     */
    public void setAttributes(Attribute[] attributeVector, int classIndex) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        if (attributeVector == null) {
            this.attributeVector = null;
            root.removeAllChildren();
            this.objectsMap.clear();
            return;
        }
        if (attributeVector.equals(this.attributeVector)) {
            return;
        }
        this.attributeVector = attributeVector;
        root.removeAllChildren();
        this.objectsMap.clear();
        DefaultTreeModel model = new DefaultTreeModel(new DefaultMutableTreeNode());
        model.addTreeModelListener(new MyTreeModelListener());
        this.setModel(model);
        root = (DefaultMutableTreeNode)this.getModel().getRoot();
        int size = attributeVector.length;
        int att = 0;
        while (att < size) {
            if (att != classIndex) {
                Attribute attribute = attributeVector[att];
                DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(attribute.getAttributeName());
                this.objectsMap.put(treeNode, attribute);
                root.add(treeNode);
                if (attribute.isNominal()) {
                    byte numStates = attribute.numValues();
                    numStates = attribute.numValues();
                    byte j = 0;
                    while (j < numStates) {
                        DefaultMutableTreeNode stateNode = new DefaultMutableTreeNode(attribute.value(j));
                        treeNode.add(stateNode);
                        this.objectsMap.put(stateNode, new StateObject(attribute, j, 0));
                        j = (byte)(j + 1);
                    }
                } else {
                    String text = this.resource.getString("clickToChange");
                    DefaultMutableTreeNode realNode = new DefaultMutableTreeNode(text);
                    treeNode.add(realNode);
                    this.objectsMap.put(realNode, new TextInputObject(attribute));
                }
            }
            ++att;
        }
    }

    public Instance getInstance() {
        ArrayList<Object> keys = this.objectsMap.getKeys();
        int keysSize = keys.size();
        Instance instance = new Instance(this.attributeVector.length);
        int i = 0;
        while (i < this.attributeVector.length) {
            instance.setMissing(i);
            ++i;
        }
        i = 0;
        while (i < keysSize) {
            Object obj = this.objectsMap.get(keys.get(i));
            if (obj instanceof StateObject) {
                StateObject state = (StateObject)obj;
                int check = state.getCheck();
                if (check == 1) {
                    instance.setValue(state.getAttribute().getIndex(), (float)state.getAttributeValue());
                }
            } else if (obj instanceof TextInputObject) {
                TextInputObject inputText = (TextInputObject)obj;
                instance.setValue(inputText.getAttribute().getIndex(), inputText.getAttributeValue());
            }
            ++i;
        }
        return instance;
    }

    private void cnmTreeMouseClicked(MouseEvent evt) {
        TreePath clickedPath = this.getPathForLocation(evt.getX(), evt.getY());
        if (clickedPath == null) {
            return;
        }
        DefaultMutableTreeNode clickedNode = (DefaultMutableTreeNode)clickedPath.getLastPathComponent();
        if (clickedNode == null || !clickedNode.isLeaf()) {
            return;
        }
        Object obj = this.objectsMap.get(clickedNode);
        if (obj instanceof StateObject) {
            this.stateNodeClicked(evt, clickedNode, obj);
        } else {
            this.startEditingAtPath(clickedPath);
        }
    }

    private void stateNodeClicked(MouseEvent evt, DefaultMutableTreeNode clickedNode, Object obj) {
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)clickedNode.getParent();
        Enumeration<TreeNode> childrenEnum = parentNode.children();
        StateObject yesChecked = null;
        ArrayList<Object> noCheckeds = new ArrayList<Object>();
        ArrayList<Object> emptyCheckeds = new ArrayList<Object>();
        while (childrenEnum.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)childrenEnum.nextElement();
            if (child.equals(clickedNode)) continue;
            if (((StateObject)this.objectsMap.get(child)).getCheck() == 1) {
                yesChecked = (StateObject)this.objectsMap.get(child);
                continue;
            }
            if (((StateObject)this.objectsMap.get(child)).getCheck() == -1) {
                noCheckeds.add(this.objectsMap.get(child));
                continue;
            }
            emptyCheckeds.add(this.objectsMap.get(child));
        }
        if (SwingUtilities.isLeftMouseButton(evt)) {
            if (((StateObject)obj).getCheck() == 1) {
                ((StateObject)obj).setCheck(0);
                int i = 0;
                while (i < noCheckeds.size()) {
                    ((StateObject)noCheckeds.get(i)).setCheck(0);
                    ++i;
                }
            } else {
                ((StateObject)obj).setCheck(1);
                if (yesChecked != null) {
                    yesChecked.setCheck(-1);
                }
                int i = 0;
                while (i < emptyCheckeds.size()) {
                    ((StateObject)emptyCheckeds.get(i)).setCheck(-1);
                    ++i;
                }
            }
        }
        if (SwingUtilities.isRightMouseButton(evt)) {
            if (((StateObject)obj).getCheck() == -1) {
                ((StateObject)obj).setCheck(0);
                if (yesChecked != null) {
                    yesChecked.setCheck(0);
                }
            } else if (noCheckeds.size() < parentNode.getChildCount() - 1) {
                ((StateObject)obj).setCheck(-1);
                if (noCheckeds.size() == parentNode.getChildCount() - 2) {
                    ((StateObject)emptyCheckeds.get(0)).setCheck(1);
                }
            }
        }
        this.repaint();
        this.inferencePanel.printSelectedAttributes(this.getInstance());
    }

    public void expandTree() {
        int i = 0;
        while (i < this.getRowCount()) {
            this.expandRow(i);
            ++i;
        }
    }

    public void collapseTree() {
        int i = 0;
        while (i < this.getRowCount()) {
            this.collapseRow(i);
            ++i;
        }
    }

    private class CnmTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 0L;
        ImageIcon yesIcon;
        ImageIcon noIcon;
        ImageIcon emptyIcon;
        ImageIcon evidenciasIcon;
        ImageIcon folderSmallIcon;

        private CnmTreeCellRenderer() {
            this.yesIcon = AttributesTree.this.iconController.getYesStateIcon();
            this.noIcon = AttributesTree.this.iconController.getNoStateIcon();
            this.emptyIcon = AttributesTree.this.iconController.getEmptyStateIcon();
            this.evidenciasIcon = AttributesTree.this.iconController.getMoreIcon();
            this.folderSmallIcon = AttributesTree.this.iconController.getFolderSmallIcon();
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
            if (leaf) {
                Object obj = AttributesTree.this.objectsMap.get(treeNode);
                if (obj instanceof StateObject) {
                    StateObject stateObject = (StateObject)obj;
                    int check = stateObject.getCheck();
                    this.setIcon(check == 1 ? this.yesIcon : (check == -1 ? this.noIcon : this.emptyIcon));
                }
            } else {
                Object obj = AttributesTree.this.objectsMap.get(treeNode);
                if (obj instanceof Attribute) {
                    this.setIcon(this.evidenciasIcon);
                }
                this.setOpenIcon(this.folderSmallIcon);
                this.setClosedIcon(this.folderSmallIcon);
            }
            return this;
        }
    }

    private class MyTreeModelListener
    implements TreeModelListener {
        private MyTreeModelListener() {
        }

        public void treeNodesChanged(TreeModelEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getTreePath().getLastPathComponent();
            node = (DefaultMutableTreeNode)node.getChildAt(0);
            Object obj = AttributesTree.this.objectsMap.get(node);
            if (obj instanceof TextInputObject) {
                TextInputObject inputText = (TextInputObject)obj;
                float value = Float.parseFloat(node.toString());
                inputText.setAttributeValue(value);
                AttributesTree.this.inferencePanel.printSelectedAttributes(AttributesTree.this.attributesTree.getInstance());
            }
        }

        public void treeNodesInserted(TreeModelEvent e) {
        }

        public void treeNodesRemoved(TreeModelEvent e) {
        }

        public void treeStructureChanged(TreeModelEvent e) {
        }
    }

    private class StateObject {
        private Attribute attribute;
        private byte attributeValue = (byte)-1;
        private int check = 0;

        public StateObject(Attribute attribute, byte attributeValue, int check) {
            this.attribute = attribute;
            this.attributeValue = attributeValue;
            this.check = check;
        }

        public void setAttributeValue(byte attributeValue) {
            this.attributeValue = attributeValue;
        }

        public void setCheck(int check) {
            this.check = check;
        }

        public byte getAttributeValue() {
            return this.attributeValue;
        }

        public int getCheck() {
            return this.check;
        }

        public Attribute getAttribute() {
            return this.attribute;
        }
    }

    private class TextInputObject {
        private Attribute attribute;
        float attributeValue;

        public TextInputObject(Attribute attribute) {
            this.attribute = attribute;
        }

        public void setAttributeValue(float attributeValue) {
            this.attributeValue = attributeValue;
        }

        public float getAttributeValue() {
            return this.attributeValue;
        }

        public Attribute getAttribute() {
            return this.attribute;
        }
    }
}

