/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.evaluation.batchEvaluation.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.ResourceBundle;
import unbbayes.datamining.evaluation.batchEvaluation.PreprocessorParameters;
import unbbayes.datamining.preprocessor.imbalanceddataset.PreprocessorIDs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Logs
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient ResourceBundle resource;
    private int numColumns;
    private ArrayList<Object[]> dataTable;
    private String[] columnNames;
    private String[] preprocessorNames = PreprocessorIDs.getPreprocessorNames();
    private ArrayList<PreprocessorParameters> preprocessors;
    private int activeColumn = 0;
    private int preprocessorIDColumn = 1;

    public Logs(ResourceBundle resource) {
        this.resource = resource;
        this.buildDataTable();
        this.preprocessors = new ArrayList();
    }

    public void buildDataTable() {
        this.dataTable = new ArrayList();
        String[] columnNames = new String[]{this.resource.getString("activeTableHeader"), this.resource.getString("preprocessorNameTableHeader")};
        this.columnNames = columnNames;
        this.numColumns = columnNames.length;
    }

    public void loadScript(ArrayList<Object[]> dataTable) {
        this.dataTable = dataTable;
    }

    public String getColumnName(int col) {
        return this.columnNames[col].toString();
    }

    public int getColumnCount() {
        return this.numColumns;
    }

    public int getRowCount() {
        return this.dataTable.size();
    }

    public void addRow(Object[] rowData) {
        this.dataTable.add(rowData);
        String preprocessorName = this.getPreprocessorName(this.getLastRow());
        this.addPreprocessor(this.getPreprocessorID(preprocessorName));
    }

    private int getPreprocessorID(String preprocessorName) {
        return PreprocessorIDs.getPreprocessorID(preprocessorName);
    }

    private int getLastRow() {
        return this.dataTable.size() - 1;
    }

    public void removePreprocessor(int row) {
        if (row >= 0) {
            this.dataTable.remove(row);
        }
    }

    public Object getValueAt(int row, int col) {
        return this.dataTable.get(row)[col];
    }

    public void setValueAt(Object value, int row, int col) {
        if (row >= this.dataTable.size()) {
            boolean pau = true;
            return;
        }
        this.dataTable.get((int)row)[col] = value;
        if (col == this.preprocessorIDColumn) {
            this.setPreprocessorID(this.getLastRow(), this.getPreprocessorID((String)value));
        }
        if (col == this.activeColumn) {
            this.setActive(this.getLastRow(), (Boolean)value);
        }
    }

    private void setActive(int pos, boolean active) {
        this.preprocessors.get(pos).setActive(active);
    }

    public boolean isActive(int i) {
        return (Boolean)this.dataTable.get(i)[0];
    }

    public String getPreprocessorName(int row) {
        return (String)this.dataTable.get(row)[this.preprocessorIDColumn];
    }

    public ArrayList<Object[]> getDataTable() {
        return this.dataTable;
    }

    public String[] getPreprocessorNames() {
        if (this.preprocessorNames == null) {
            this.preprocessorNames = PreprocessorIDs.getPreprocessorNames();
        }
        return (String[])this.preprocessorNames.clone();
    }

    private void addPreprocessor(int preprocessorID) {
        this.preprocessors.add(new PreprocessorParameters(preprocessorID));
    }

    private void setPreprocessorID(int pos, int preprocessorID) {
        this.preprocessors.get(pos).setPreprocessorID(preprocessorID);
    }

    public PreprocessorParameters getPreprocessor(int pos) {
        return this.preprocessors.get(pos);
    }

    public PreprocessorParameters[] getActivePreprocessors() {
        int numPreprocessors = this.getNumActivePreprocessors();
        PreprocessorParameters[] preprocessors = new PreprocessorParameters[numPreprocessors];
        int i = 0;
        while (i < this.dataTable.size()) {
            if (this.isActive(i)) {
                preprocessors[i] = this.getPreprocessor(i);
            }
            ++i;
        }
        return preprocessors;
    }

    public int getNumActivePreprocessors() {
        int numPreprocessors = 0;
        int i = 0;
        while (i < this.getRowCount()) {
            if (this.isActive(i)) {
                ++numPreprocessors;
            }
            ++i;
        }
        return numPreprocessors;
    }
}

