/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.evaluation.batchEvaluation;

import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.evaluation.Evaluation;

public class Indexes {
    private int[][][][][] confusionMatrixCross;
    private int[][][][] confusionMatrix;
    private double[][][] globalError;
    private double[][][] globalErrorTemp;
    private double[][][] sensitivity;
    private double[][][] sensitivityTemp;
    private double[][][] specificity;
    private double[][][] specificityTemp;
    private double[][][] SE;
    private double[][][] SETemp;
    private int numSamplings;
    private int numClassifiers;
    private int numRoundsTotal;
    private int numClasses;
    private Evaluation eval;

    public Indexes(InstanceSet instanceSet, int numSamplings, int numClassifiers, int numRoundsTotal) throws Exception {
        this.numSamplings = numSamplings;
        this.numClassifiers = numClassifiers;
        this.numRoundsTotal = numRoundsTotal;
        this.numClasses = instanceSet.numClasses();
        this.confusionMatrix = new int[numSamplings][numClassifiers][this.numClasses][this.numClasses];
        this.confusionMatrixCross = new int[numSamplings][numClassifiers][numRoundsTotal][this.numClasses][this.numClasses];
        this.eval = new Evaluation(instanceSet);
    }

    public void insert(int samplingID, int classfID, int pos, int actualClass, int predictedClass, float weight) {
        int[] nArray = this.confusionMatrix[samplingID][classfID][actualClass];
        int n = predictedClass;
        nArray[n] = (int)((float)nArray[n] + weight);
        int[] nArray2 = this.confusionMatrixCross[samplingID][classfID][pos][actualClass];
        int n2 = predictedClass;
        nArray2[n2] = (int)((float)nArray2[n2] + weight);
    }

    public double truePositiveRate(int samplingID, int classfID, int classID) {
        this.eval.setConfusionMatrix(this.confusionMatrix[samplingID][classfID]);
        return this.eval.truePositiveRate(classID);
    }

    public double falsePositiveRate(int samplingID, int classfID, int classID) {
        this.eval.setConfusionMatrix(this.confusionMatrix[samplingID][classfID]);
        return this.eval.falsePositiveRate(classID);
    }

    public double trueNegativeRate(int samplingID, int classfID, int classID) {
        this.eval.setConfusionMatrix(this.confusionMatrix[samplingID][classfID]);
        return this.eval.trueNegativeRate(classID);
    }

    public double falseNegativeRate(int samplingID, int classfID, int classID) {
        this.eval.setConfusionMatrix(this.confusionMatrix[samplingID][classfID]);
        return this.eval.falseNegativeRate(classID);
    }

    public double getPrecision(int samplingID, int classfID, int classID) {
        this.eval.setConfusionMatrix(this.confusionMatrix[samplingID][classfID]);
        return this.eval.getPrecision(classID);
    }

    public double getRecall(int samplingID, int classfID, int classID) {
        this.eval.setConfusionMatrix(this.confusionMatrix[samplingID][classfID]);
        return this.eval.getRecall(classID);
    }

    public double getAccuracy(int samplingID, int classfID, int classID) {
        this.eval.setConfusionMatrix(this.confusionMatrix[samplingID][classfID]);
        return this.eval.getAccuracy(classID);
    }

    public double getFScore(int samplingID, int classfID, int classID) {
        this.eval.setConfusionMatrix(this.confusionMatrix[samplingID][classfID]);
        return this.eval.getFScore(classID);
    }

    public int[][] getConfusionMatrix(int samplingID, int classfID) {
        this.eval.setConfusionMatrix(this.confusionMatrix[samplingID][classfID]);
        return this.eval.getConfusionMatrix();
    }
}

