/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.evaluation.batchEvaluation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ResourceBundle;
import unbbayes.datamining.evaluation.batchEvaluation.RunScript;
import unbbayes.datamining.evaluation.batchEvaluation.model.Classifiers;
import unbbayes.datamining.evaluation.batchEvaluation.model.Datasets;
import unbbayes.datamining.evaluation.batchEvaluation.model.Evaluations;
import unbbayes.datamining.evaluation.batchEvaluation.model.Logs;
import unbbayes.datamining.evaluation.batchEvaluation.model.Preprocessors;
import unbbayes.datamining.gui.evaluation.batchEvaluation.controllers.LogsTabController;

public class BatchEvaluation {
    private transient ResourceBundle resource = ResourceBundle.getBundle("unbbayes.datamining.evaluation.batchEvaluation.resources.BatchEvaluationResource");
    private Datasets datasetData = new Datasets(this.resource);
    private Preprocessors preprocessorData = new Preprocessors(this.resource);
    private Classifiers classifierData = new Classifiers(this.resource);
    private Evaluations evaluationData = new Evaluations(this.resource);
    private Logs logData = new Logs(this.resource);

    public String openScript(File file) {
        try {
            FileInputStream scriptStream = new FileInputStream(file.getAbsoluteFile());
            ObjectInputStream scriptStreamIn = new ObjectInputStream(scriptStream);
            this.datasetData = (Datasets)scriptStreamIn.readObject();
            this.preprocessorData = (Preprocessors)scriptStreamIn.readObject();
            this.classifierData = (Classifiers)scriptStreamIn.readObject();
            this.evaluationData = (Evaluations)scriptStreamIn.readObject();
            this.logData = (Logs)scriptStreamIn.readObject();
        }
        catch (FileNotFoundException e) {
            return e.getLocalizedMessage();
        }
        catch (IOException e) {
            return e.getLocalizedMessage();
        }
        catch (ClassNotFoundException e) {
            return e.getLocalizedMessage();
        }
        return null;
    }

    public String saveScript(File file) {
        try {
            FileOutputStream scriptStream = new FileOutputStream(file.getAbsoluteFile());
            ObjectOutputStream scriptStreamOut = new ObjectOutputStream(scriptStream);
            scriptStreamOut.writeObject(this.datasetData);
            scriptStreamOut.writeObject(this.preprocessorData);
            scriptStreamOut.writeObject(this.classifierData);
            scriptStreamOut.writeObject(this.evaluationData);
            scriptStreamOut.writeObject(this.logData);
        }
        catch (FileNotFoundException e) {
            return e.getLocalizedMessage();
        }
        catch (IOException e) {
            return e.getLocalizedMessage();
        }
        return null;
    }

    public void runScript(LogsTabController logsWindowController) throws Exception {
        RunScript runScript = new RunScript(this.datasetData, this.preprocessorData, this.evaluationData, logsWindowController, this.resource);
        runScript.run();
    }

    public Datasets getDatasetData() {
        return this.datasetData;
    }

    public Preprocessors getPreprocessorData() {
        return this.preprocessorData;
    }

    public Classifiers getClassifierData() {
        return this.classifierData;
    }

    public Evaluations getEvaluationData() {
        return this.evaluationData;
    }

    public Logs getLogData() {
        return this.logData;
    }
}

