/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.evaluation;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import unbbayes.controller.IProgress;
import unbbayes.datamining.classifiers.Classifier;
import unbbayes.datamining.classifiers.DistributionClassifier;
import unbbayes.datamining.datamanipulation.Instance;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.datamanipulation.Options;
import unbbayes.datamining.datamanipulation.Utils;
import unbbayes.datamining.evaluation.Folds;

public class Evaluation
implements IProgress {
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.datamining.classifiers.resources.ClassifiersResource");
    private int numClasses;
    private int incorrect;
    private int correct;
    private int unclassified;
    private int missingClass;
    private int withClass;
    private boolean classIsNominal;
    private int[][] confusionMatrix;
    private double sumSqrErr;
    private String[] classNames;
    private InstanceSet instanceSet;
    private double[] confidenceLimits = new double[]{3.09, 2.58, 2.33, 1.65, 1.28, 0.84, 0.25};
    private String[] confidenceProbs = new String[]{"99.8%", "99%", "98%", "90%", "80%", "60%", "20%"};
    private int confidenceLimit = 100;
    private int numInstances;
    private int counter;
    private Classifier classifier;

    public Evaluation(InstanceSet instanceSet) throws Exception {
        this.instanceSet = instanceSet;
        this.numClasses = instanceSet.numClasses();
        this.numInstances = instanceSet.numInstances();
        this.counter = 0;
        this.classIsNominal = instanceSet.getClassAttribute().isNominal();
        this.confidenceLimit = Options.getInstance().getConfidenceLimit();
        if (this.classIsNominal) {
            this.confusionMatrix = new int[this.numClasses][this.numClasses];
            this.classNames = new String[this.numClasses];
            int i = 0;
            while (i < this.numClasses) {
                this.classNames[i] = instanceSet.getClassAttribute().value(i);
                ++i;
            }
        }
    }

    public Evaluation(InstanceSet instanceSet, Classifier classifier) throws Exception {
        this(instanceSet);
        this.classifier = classifier;
    }

    public void evaluateModel(Classifier classifier) throws Exception {
        int i = 0;
        while (i < this.numInstances) {
            if (i % 50000 == 0) {
                String currentHour = new SimpleDateFormat("HH:mm:ss - ").format(new Date());
                System.out.println("inst\ufffdncia = " + i + " hora = " + currentHour);
            }
            this.evaluateModelOnce(classifier, this.instanceSet.getInstance(i));
            ++i;
        }
    }

    public void evaluateModel(Classifier classifier, InstanceSet testData) throws Exception {
        int numInstances = testData.numInstances();
        int i = 0;
        while (i < numInstances) {
            this.evaluateModelOnce(classifier, testData.getInstance(i));
            ++i;
        }
    }

    public float evaluateModelOnce(Classifier classifier, Instance instance) throws Exception {
        int pred = 0;
        if (this.classIsNominal) {
            if (classifier instanceof DistributionClassifier) {
                float[] dist = ((DistributionClassifier)classifier).distributionForInstance(instance);
                pred = ((DistributionClassifier)classifier).classifyInstance(dist);
                this.updateStatsForClassifier(pred, instance);
            } else {
                pred = classifier.classifyInstance(instance);
                if ((float)pred == Float.NaN) {
                    boolean bl = true;
                }
                this.updateStatsForClassifier(pred, instance);
            }
        } else {
            System.out.println("numeric class");
        }
        return pred;
    }

    private float[] makeDistribution(float predictedClass) {
        float[] result = new float[this.numClasses];
        if (Instance.isMissingValue(predictedClass)) {
            return result;
        }
        if (this.classIsNominal) {
            result[(int)predictedClass] = 1.0f;
        } else {
            result[0] = predictedClass;
        }
        return result;
    }

    public String toString() {
        StringBuilder text = new StringBuilder(resource.getString("summary"));
        try {
            text.append(resource.getString("correctly"));
            text.append(String.valueOf(Utils.doubleToString(this.correct(), 12, 4)) + " " + Utils.doubleToString(this.pctCorrect(), 12, 4) + " %\n");
            if (this.withClass >= this.confidenceLimit) {
                text.append(this.correctConfidence());
            }
            text.append(resource.getString("incorrectly"));
            text.append(String.valueOf(Utils.doubleToString(this.incorrect(), 12, 4)) + " " + Utils.doubleToString(this.pctIncorrect(), 12, 4) + " %\n");
            if (this.withClass >= this.confidenceLimit) {
                text.append(this.incorrectConfidence());
            }
            text.append("Quadratic loss function\t\t\t\t" + Utils.doubleToString(this.sumSqrErr / (double)this.withClass, 17, 4) + "\n");
            if (Utils.gr(this.unclassified(), 0.0)) {
                text.append(resource.getString("unclassified"));
                text.append(String.valueOf(Utils.doubleToString(this.unclassified(), 12, 4)) + " " + Utils.doubleToString(this.pctUnclassified(), 12, 4) + "%\n");
            }
            text.append(resource.getString("totalNumber"));
            text.append(String.valueOf(Utils.doubleToString(this.withClass, 12, 4)) + "\n");
            if (this.missingClass > 0) {
                text.append(resource.getString("unknownInstances"));
                text.append(String.valueOf(Utils.doubleToString(this.missingClass, 12, 4)) + "\n");
            }
        }
        catch (Exception ex) {
            System.err.println("A bug in Evaluation class");
        }
        return text.toString();
    }

    private void updateNumericScores(float[] predicted, float[] actual, float weight) {
        double partialSumSqrErr = 0.0;
        int i = 0;
        while (i < this.numClasses) {
            float diff = predicted[i] - actual[i];
            partialSumSqrErr += (double)(diff * diff);
            ++i;
        }
        this.sumSqrErr += (double)weight * partialSumSqrErr;
    }

    private String correctConfidence() {
        double f = (double)this.correct / (double)this.withClass;
        double n = this.numInstances();
        StringBuilder sb = new StringBuilder("Correct confidence limits\nPr[c]\t   z\n");
        int i = 0;
        while (i < this.confidenceLimits.length) {
            double z = this.confidenceLimits[i];
            double initialTerm = this.initialTerm(f, z, n);
            double mediumTerm = this.mediumTerm(f, z, n);
            double lowerBound = (initialTerm - mediumTerm) / this.finalTerm(z, n);
            double upperBound = (initialTerm + mediumTerm) / this.finalTerm(z, n);
            sb.append(String.valueOf(this.confidenceProbs[i]) + "\t[" + Utils.doubleToString(lowerBound, 4, 4) + " , " + Utils.doubleToString(upperBound, 4, 4) + "]\n");
            ++i;
        }
        return sb.toString();
    }

    private String incorrectConfidence() {
        double f = (double)this.incorrect / (double)this.withClass;
        double n = this.numInstances();
        StringBuilder sb = new StringBuilder("Incorrect confidence limits\nPr[c]\t   z\n");
        int i = 0;
        while (i < this.confidenceLimits.length) {
            double z = this.confidenceLimits[i];
            double initialTerm = this.initialTerm(f, z, n);
            double mediumTerm = this.mediumTerm(f, z, n);
            double lowerBound = (initialTerm - mediumTerm) / this.finalTerm(z, n);
            double upperBound = (initialTerm + mediumTerm) / this.finalTerm(z, n);
            sb.append(String.valueOf(this.confidenceProbs[i]) + "\t[" + Utils.doubleToString(lowerBound, 4, 4) + " , " + Utils.doubleToString(upperBound, 4, 4) + "]\n");
            ++i;
        }
        return sb.toString();
    }

    private double finalTerm(double z, double n) {
        return 1.0 + Math.pow(z, 2.0) / n;
    }

    private double initialTerm(double f, double z, double n) {
        return f + Math.pow(z, 2.0) / (2.0 * n);
    }

    private double mediumTerm(double f, double z, double n) {
        return z * Math.sqrt(f / n - Math.pow(f, 2.0) / n + Math.pow(z, 2.0) / (4.0 * Math.pow(n, 2.0)));
    }

    public final int numInstances() {
        return this.withClass;
    }

    public final int incorrect() {
        return this.incorrect;
    }

    public final double pctIncorrect() {
        return 100.0 * (double)this.incorrect / (double)this.withClass;
    }

    public final int correct() {
        return this.correct;
    }

    public final double pctCorrect() {
        return 100.0 * (double)this.correct / (double)this.withClass;
    }

    public final int unclassified() {
        return this.unclassified;
    }

    public final double pctUnclassified() {
        return 100.0 * (double)this.unclassified / (double)this.withClass;
    }

    private void updateStatsForClassifier(int predictedClass, Instance instance) throws Exception {
        if (!instance.classIsMissing()) {
            this.withClass = (int)((float)this.withClass + instance.getWeight());
            if (predictedClass < 0) {
                this.unclassified = (int)((float)this.unclassified + instance.getWeight());
                return;
            }
            int actualClass = instance.getClassValue();
            this.updateNumericScores(this.makeDistribution(predictedClass), this.makeDistribution(actualClass), instance.getWeight());
            int[] nArray = this.confusionMatrix[actualClass];
            int n = predictedClass;
            nArray[n] = (int)((float)nArray[n] + instance.getWeight());
            if (predictedClass != actualClass) {
                this.incorrect = (int)((float)this.incorrect + instance.getWeight());
            } else {
                this.correct = (int)((float)this.correct + instance.getWeight());
            }
        } else {
            this.missingClass = (int)((float)this.missingClass + instance.getWeight());
        }
    }

    public void crossValidateModel(Classifier classifier, int numFolds) throws Exception {
        Folds folds = new Folds(this.instanceSet, numFolds);
        int fold = 0;
        while (fold < numFolds) {
            InstanceSet train = folds.getTrain(fold);
            InstanceSet test = folds.getTest(fold);
            classifier.buildClassifier(train);
            this.evaluateModel(classifier, test);
            ++fold;
        }
    }

    public String toClassDetailsString() throws Exception {
        if (!this.classIsNominal) {
            throw new Exception(resource.getString("noMatrix"));
        }
        StringBuilder text = new StringBuilder(resource.getString("accuracy"));
        text.append("\nTP Rate   FP Rate   TN Rate   FN Rate   Class\n");
        int i = 0;
        while (i < this.numClasses) {
            text.append(Utils.doubleToString(this.truePositiveRate(i), 7, 3)).append("   ");
            text.append(Utils.doubleToString(this.falsePositiveRate(i), 7, 3)).append("    ");
            text.append(Utils.doubleToString(this.trueNegativeRate(i), 7, 3)).append("   ");
            text.append(Utils.doubleToString(this.falseNegativeRate(i), 7, 3)).append("    ");
            text.append(this.classNames[i]).append('\n');
            ++i;
        }
        return text.toString();
    }

    public int numTruePositives(int positiveClass) {
        int correct = 0;
        int j = 0;
        while (j < this.numClasses) {
            if (j == positiveClass) {
                correct += this.confusionMatrix[positiveClass][j];
            }
            ++j;
        }
        return correct;
    }

    public double truePositiveRate(int positiveClass) {
        double correct = 0.0;
        double total = 0.0;
        int j = 0;
        while (j < this.numClasses) {
            if (j == positiveClass) {
                correct += (double)this.confusionMatrix[positiveClass][j];
            }
            total += (double)this.confusionMatrix[positiveClass][j];
            ++j;
        }
        if (total == 0.0) {
            return 0.0;
        }
        return correct / total;
    }

    public int numTrueNegatives(int negativeClass) {
        int correct = 0;
        int i = 0;
        while (i < this.numClasses) {
            if (i != negativeClass) {
                int j = 0;
                while (j < this.numClasses) {
                    if (j != negativeClass) {
                        correct += this.confusionMatrix[i][j];
                    }
                    ++j;
                }
            }
            ++i;
        }
        return correct;
    }

    public double trueNegativeRate(int negativeClass) {
        double correct = 0.0;
        double total = 0.0;
        int i = 0;
        while (i < this.numClasses) {
            if (i != negativeClass) {
                int j = 0;
                while (j < this.numClasses) {
                    if (j != negativeClass) {
                        correct += (double)this.confusionMatrix[i][j];
                    }
                    total += (double)this.confusionMatrix[i][j];
                    ++j;
                }
            }
            ++i;
        }
        if (total == 0.0) {
            return 0.0;
        }
        return correct / total;
    }

    public int numFalsePositives(int positiveClass) {
        int incorrect = 0;
        int i = 0;
        while (i < this.numClasses) {
            if (i != positiveClass) {
                int j = 0;
                while (j < this.numClasses) {
                    if (j == positiveClass) {
                        incorrect += this.confusionMatrix[i][j];
                    }
                    ++j;
                }
            }
            ++i;
        }
        return incorrect;
    }

    public double falsePositiveRate(int positiveClass) {
        double incorrect = 0.0;
        double total = 0.0;
        int i = 0;
        while (i < this.numClasses) {
            if (i != positiveClass) {
                int j = 0;
                while (j < this.numClasses) {
                    if (j == positiveClass) {
                        incorrect += (double)this.confusionMatrix[i][j];
                    }
                    total += (double)this.confusionMatrix[i][j];
                    ++j;
                }
            }
            ++i;
        }
        if (total == 0.0) {
            return 0.0;
        }
        return incorrect / total;
    }

    public int numFalseNegatives(int negativeClass) {
        int incorrect = 0;
        int i = 0;
        while (i < this.numClasses) {
            if (i == negativeClass) {
                int j = 0;
                while (j < this.numClasses) {
                    if (j != negativeClass) {
                        incorrect += this.confusionMatrix[i][j];
                    }
                    ++j;
                }
            }
            ++i;
        }
        return incorrect;
    }

    public double falseNegativeRate(int negativeClass) {
        double incorrect = 0.0;
        double total = 0.0;
        int i = 0;
        while (i < this.numClasses) {
            if (i == negativeClass) {
                int j = 0;
                while (j < this.numClasses) {
                    if (j != negativeClass) {
                        incorrect += (double)this.confusionMatrix[i][j];
                    }
                    total += (double)this.confusionMatrix[i][j];
                    ++j;
                }
            }
            ++i;
        }
        if (total == 0.0) {
            return 0.0;
        }
        return incorrect / total;
    }

    public double getPrecision(int positiveClass) {
        double numTruePositives = this.numTruePositives(positiveClass);
        double numFalsePositives = this.numFalsePositives(positiveClass);
        return numTruePositives / (numTruePositives + numFalsePositives);
    }

    public double getRecall(int positiveClass) {
        return this.truePositiveRate(positiveClass);
    }

    public double getFScore(int positiveClass) {
        return this.getPrecision(positiveClass) * this.getRecall(positiveClass);
    }

    public double getAccuracy(int positiveClass) {
        double numTruePositives = this.numTruePositives(positiveClass);
        double numTrueNegatives = this.numTrueNegatives(positiveClass);
        return (numTruePositives + numTrueNegatives) / (double)this.instanceSet.numInstances;
    }

    public double getSensitivity(int positiveClass) {
        return this.truePositiveRate(positiveClass);
    }

    public double getSpecificity(int positiveClass) {
        return 1.0 - this.falsePositiveRate(positiveClass);
    }

    public double getPositivePredictiveValue(int positiveClass) {
        return this.getPrecision(positiveClass);
    }

    public String toMatrixString() throws Exception {
        int j;
        StringBuilder text = new StringBuilder(resource.getString("matrix"));
        if (!this.classIsNominal) {
            throw new Exception(resource.getString("noMatrix"));
        }
        char[] IDChars = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        boolean fractional = false;
        double maxval = 0.0;
        int i = 0;
        while (i < this.numClasses) {
            j = 0;
            while (j < this.numClasses) {
                double current = this.confusionMatrix[i][j];
                if (current < 0.0) {
                    current *= -10.0;
                }
                if (current > maxval) {
                    maxval = current;
                }
                double fract = current - Math.rint(current);
                if (!fractional && Math.log(fract) / Math.log(10.0) >= -2.0) {
                    fractional = true;
                }
                ++j;
            }
            ++i;
        }
        int IDWidth = 1 + Math.max((int)(Math.log(maxval) / Math.log(10.0) + (double)(fractional ? 3 : 0)), (int)(Math.log(this.numClasses) / Math.log(IDChars.length)));
        i = 0;
        while (i < this.numClasses) {
            if (fractional) {
                text.append(" ").append(this.num2ByteID(i, IDChars, IDWidth - 3)).append("   ");
            } else {
                text.append(" ").append(this.num2ByteID(i, IDChars, IDWidth));
            }
            ++i;
        }
        text.append("   <-- classified as\n");
        i = 0;
        while (i < this.numClasses) {
            j = 0;
            while (j < this.numClasses) {
                text.append(" ").append(Utils.doubleToString(this.confusionMatrix[i][j], IDWidth, fractional ? 2 : 0));
                ++j;
            }
            text.append(" | ").append(this.num2ByteID(i, IDChars, IDWidth)).append(" = ").append(this.classNames[i]).append("\n");
            ++i;
        }
        return text.toString();
    }

    private String num2ByteID(int num, char[] IDChars, int IDWidth) {
        char[] ID = new char[IDWidth];
        int i = IDWidth - 1;
        while (i >= 0) {
            ID[i] = IDChars[num % IDChars.length];
            if ((num = num / IDChars.length - 1) < 0) break;
            --i;
        }
        --i;
        while (i >= 0) {
            ID[i] = 32;
            --i;
        }
        return new String(ID);
    }

    public int maxCount() {
        return this.numInstances;
    }

    public boolean next() {
        if (this.counter == this.numInstances) {
            return false;
        }
        try {
            this.evaluateModelOnce(this.classifier, this.instanceSet.getInstance(this.counter));
            ++this.counter;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void cancel() {
        this.counter = 0;
    }

    public static float[] getEvaluatedProbabilities(Classifier classifier, InstanceSet testData, int positiveClass) throws Exception {
        int numInstances = testData.numInstances();
        float[] probs = new float[numInstances];
        int inst = 0;
        while (inst < numInstances) {
            float[] dist = ((DistributionClassifier)classifier).distributionForInstance(testData.getInstance(inst));
            probs[inst] = dist[positiveClass];
            ++inst;
        }
        return probs;
    }

    public int[][] getConfusionMatrix() {
        return this.confusionMatrix;
    }

    public void setConfusionMatrix(int[][] confusionMatrix) {
        this.confusionMatrix = confusionMatrix;
    }
}

