/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.datamanipulation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.ResourceBundle;
import unbbayes.datamining.datamanipulation.Attribute;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.datamanipulation.Loader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TxtLoader
extends Loader {
    public static final String FILE_EXTENSION = ".txt";
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.datamining.datamanipulation.resources.DataManipulationResource");

    public TxtLoader(File file, int numLines) throws IOException {
        this.file = file;
        this.countInstancesFromFile(file, numLines, true);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        this.tokenizer = new StreamTokenizer(reader);
        this.initTokenizer();
    }

    @Override
    protected void initTokenizer() {
        this.tokenizer.resetSyntax();
        this.tokenizer.wordChars(33, 255);
        this.tokenizer.wordChars(95, 95);
        this.tokenizer.wordChars(45, 45);
        this.tokenizer.whitespaceChars(0, 32);
        this.tokenizer.whitespaceChars(9, 9);
        this.tokenizer.whitespaceChars(44, 44);
        this.tokenizer.commentChar(37);
        this.tokenizer.quoteChar(34);
        this.tokenizer.eolIsSignificant(true);
    }

    @Override
    public void buildHeader() throws IOException {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        --this.initialInstances;
        int counter = 0;
        this.getNextToken();
        while (this.tokenizer.ttype != 10) {
            String attName = this.tokenizer.sval;
            if (attName.equalsIgnoreCase(this.counterAttributeName)) {
                this.likelyCounterIndex = counter;
            }
            if (attName == null) {
                this.errms(resource.getString("Invalid header"));
            }
            attributes.add(new Attribute(attName, 1, true, this.initialInstances, counter));
            this.tokenizer.nextToken();
            ++counter;
        }
        this.numAttributes = counter;
        this.attributeType = new byte[this.numAttributes];
        this.attributeIsString = new boolean[this.numAttributes];
        Attribute[] attributesArray = new Attribute[this.numAttributes];
        int att = 0;
        while (att < this.numAttributes) {
            attributesArray[att] = (Attribute)attributes.get(att);
            this.attributeType[att] = 1;
            this.attributeIsString[att] = true;
            ++att;
        }
        this.instanceSet = new InstanceSet(this.initialInstances, attributesArray);
        this.instanceSet.setCounterAttributeName(this.counterAttributeName);
    }

    @Override
    public ArrayList<Object> getHeaderInfo() throws IOException {
        ArrayList<String> attributesName = new ArrayList<String>();
        String likelyCounterName = null;
        Object relationName = null;
        this.getNextToken();
        while (this.tokenizer.ttype != 10) {
            attributesName.add(this.tokenizer.sval);
            if (this.tokenizer.sval.equalsIgnoreCase(this.counterAttributeName)) {
                likelyCounterName = this.tokenizer.sval;
            }
            if (this.tokenizer.sval == null) {
                this.errms(resource.getString("Invalid header"));
            }
            this.tokenizer.nextToken();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(attributesName);
        result.add(likelyCounterName);
        result.add(relationName);
        return result;
    }

    @Override
    public void readHeader() throws IOException {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        this.getNextToken();
        int attIndex = 0;
        --this.initialInstances;
        this.compacted = false;
        while (this.tokenizer.ttype != 10) {
            String attName = this.tokenizer.sval;
            if (attName == null) {
                this.errms(resource.getString("Invalid header"));
            }
            if (attIndex == this.counterIndex) {
                this.compacted = true;
                this.counterAttributeName = attName;
                this.tokenizer.nextToken();
                continue;
            }
            attributes.add(new Attribute(attName, this.attributeType[attIndex], this.attributeIsString[attIndex], this.initialInstances, attIndex));
            this.tokenizer.nextToken();
            ++attIndex;
        }
        this.numAttributes = attributes.size();
        Attribute[] attributesArray = new Attribute[this.numAttributes];
        int i = 0;
        while (i < this.numAttributes) {
            attributesArray[i] = (Attribute)attributes.get(i);
            ++i;
        }
        this.instanceSet = new InstanceSet(this.initialInstances, attributesArray);
        this.instanceSet.setCounterAttributeName(this.counterAttributeName);
    }

    @Override
    public boolean getInstance() throws IOException {
        if (this.instanceSet == null) {
            this.readHeader();
        }
        if (this.instanceSet.numAttributes() == 0) {
            this.errms(resource.getString("getInstanceTXT"));
        }
        this.getFirstToken();
        if (this.tokenizer.ttype == -1) {
            return false;
        }
        return this.getInstanceAux();
    }

    @Override
    protected boolean getInstanceAux() throws IOException {
        float[] instance = new float[this.numAttributes + 1];
        float instanceWeight = 1.0f;
        int attIndex = 0;
        int columns = this.numAttributes;
        if (this.compacted) {
            ++columns;
        }
        int i = 0;
        while (i < columns) {
            block10: {
                if (i == this.counterIndex) {
                    try {
                        float numValue;
                        instanceWeight = numValue = (float)Double.parseDouble(this.tokenizer.sval);
                        break block10;
                    }
                    catch (NumberFormatException nfe) {
                        this.errms("Atributo de contagem inv\ufffdlido");
                    }
                }
                if (this.attributeType[attIndex] == 1) {
                    String stringValue = this.tokenizer.sval;
                    Attribute attribute = this.instanceSet.getAttribute(attIndex);
                    if (this.attributeIsString[attIndex]) {
                        stringValue = this.tokenizer.sval;
                        if (stringValue.equals("?")) {
                            instance[attIndex] = Float.NaN;
                        }
                        instance[attIndex] = attribute.addValue(stringValue);
                    } else {
                        float numValue = (float)Double.parseDouble(this.tokenizer.sval);
                        instance[attIndex] = attribute.addValue(numValue);
                    }
                } else {
                    float numValue;
                    instance[attIndex] = numValue = (float)Double.parseDouble(this.tokenizer.sval);
                }
                ++attIndex;
                this.tokenizer.nextToken();
            }
            ++i;
        }
        instance[attIndex] = instanceWeight;
        this.instanceSet.insertInstance(instance);
        return true;
    }

    @Override
    protected void getFirstToken() throws IOException {
        while (this.tokenizer.nextToken() == 10) {
        }
    }

    @Override
    protected void getNextToken() throws IOException {
        if (this.tokenizer.nextToken() == 10) {
            this.errms(resource.getString("getNextTokenException1"));
        }
        if (this.tokenizer.ttype == -1) {
            this.errms(resource.getString("getNextTokenException2"));
        }
    }
}

