/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.classifiers.bayesianlearning;

import java.util.ArrayList;
import unbbayes.datamining.datamanipulation.Attribute;
import unbbayes.datamining.datamanipulation.Instance;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.prs.Edge;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.prs.exception.InvalidParentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParametricLearning {
    private String[] x;
    private ArrayList[] dx;
    private int[][] d;
    private int[] freq;

    public ParametricLearning(InstanceSet set) {
        int j;
        Instance inst;
        int numAttributes = set.numAttributes();
        this.x = new String[numAttributes];
        this.dx = new ArrayList[numAttributes];
        int i = 0;
        while (i < numAttributes) {
            Attribute attrib = set.getAttribute(i);
            this.x[i] = attrib.getAttributeName();
            ArrayList<String[]> temp = new ArrayList<String[]>();
            temp.add(attrib.getDistinticNominalValues());
            this.dx[i] = temp;
            ++i;
        }
        int numInstances = set.numInstances();
        this.freq = new int[numInstances];
        ArrayList<Instance> dataTemp = new ArrayList<Instance>();
        i = 0;
        while (i < numInstances) {
            inst = set.getInstance(i);
            j = 0;
            while (j < dataTemp.size()) {
                Instance inst2 = (Instance)dataTemp.get(j);
                int k = 0;
                while (k < this.x.length) {
                    if (inst.getValue(k) != inst2.getValue(k)) break;
                    ++k;
                }
                if (k == this.x.length) break;
                ++j;
            }
            if (j == dataTemp.size()) {
                this.freq[dataTemp.size()] = 1;
                dataTemp.add(inst);
            } else {
                this.freq[j] = this.freq[j] + 1;
            }
            ++i;
        }
        this.d = new int[dataTemp.size()][this.x.length];
        i = 0;
        while (i < dataTemp.size()) {
            inst = (Instance)dataTemp.get(i);
            j = 0;
            while (j < this.x.length) {
                this.d[i][j] = (int)inst.getValue(j);
                ++j;
            }
            ++i;
        }
    }

    public int[] multiplies(int[] pai) {
        int np = pai.length;
        np = np == 0 ? 1 : np;
        int[] mult = new int[np];
        mult[np - 1] = 1;
        int k = np - 2;
        while (k >= 0) {
            int ip = pai[k + 1];
            mult[k] = this.dx[ip].size() * mult[k + 1];
            --k;
        }
        return mult;
    }

    public int computeQ(int[] pai) {
        int qi = 1;
        int i = 0;
        while (i < pai.length) {
            qi *= this.dx[pai[i]].size();
            ++i;
        }
        return qi;
    }

    public int[][] computeNijk(int i, int[] pai) {
        int qi = this.computeQ(pai);
        int ri = this.dx[i].size();
        int[] mult = this.multiplies(pai);
        int[][] njk = new int[qi][ri];
        int n = this.x.length;
        int nd = this.d.length;
        int ic = 0;
        while (ic < nd) {
            int j = 0;
            int im = 0;
            while (im < pai.length) {
                int ip = pai[im];
                j += this.d[ic][ip] * mult[im];
                ++im;
            }
            int k = this.d[ic][i];
            int fc = this.freq[ic];
            njk[j][k] = njk[j][k] + fc;
            ++ic;
        }
        return njk;
    }

    public ArrayList<float[][]> prob(ArrayList<int[]> pa) {
        int n = this.x.length;
        ArrayList<int[][]> nijk = new ArrayList<int[][]>();
        int i = 0;
        while (i < n) {
            nijk.add(this.computeNijk(i, pa.get(i)));
            ++i;
        }
        ArrayList<float[][]> p = new ArrayList<float[][]>();
        i = 0;
        while (i < n) {
            int ri = this.dx[i].size();
            int qi = this.computeQ(pa.get(i));
            float[][] pjk = new float[qi][ri];
            int[][] njk = (int[][])nijk.get(i);
            int j = 0;
            while (j < qi) {
                int nij = 0;
                int k = 0;
                while (k < ri) {
                    nij += njk[j][k];
                    ++k;
                }
                k = 0;
                while (k < ri) {
                    pjk[j][k] = (float)(1 + njk[j][k]) / (float)(ri + nij);
                    ++k;
                }
                ++j;
            }
            p.add(pjk);
            ++i;
        }
        return p;
    }

    public ProbabilisticNetwork getProbabilisticNetwork(ArrayList<int[]> pa) throws InvalidParentException {
        ProbabilisticNode node;
        ProbabilisticNetwork net = new ProbabilisticNetwork("net");
        int width = 50;
        int i = 0;
        while (i < this.x.length) {
            node = new ProbabilisticNode();
            node.setDescription(this.x[i]);
            node.setName(this.x[i]);
            node.setPosition(width, 100.0);
            width += 100;
            ArrayList states = this.dx[i];
            int j = 0;
            while (j < states.size()) {
                node.appendState("" + states.get(j));
                ++j;
            }
            PotentialTable tab = node.getPotentialTable();
            tab.addVariable(node);
            net.addNode(node);
            ++i;
        }
        i = 0;
        while (i < this.x.length) {
            node = (ProbabilisticNode)net.getNodeAt(i);
            PotentialTable tab = node.getPotentialTable();
            int[] parents = pa.get(i);
            int j = 0;
            while (j < parents.length) {
                Edge arco = new Edge(net.getNodeAt(parents[j]), node);
                net.addEdge(arco);
                ++j;
            }
            ArrayList<float[][]> probs = this.prob(pa);
            float[][] pjk = probs.get(i);
            int counter = 0;
            int j2 = 0;
            while (j2 < pjk.length) {
                int k = 0;
                while (k < pjk[j2].length) {
                    tab.setValue(counter, pjk[j2][k]);
                    ++counter;
                    ++k;
                }
                ++j2;
            }
            ++i;
        }
        return net;
    }
}

