/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.classifiers;

import java.util.ResourceBundle;
import unbbayes.datamining.classifiers.Classifier;
import unbbayes.datamining.datamanipulation.Instance;
import unbbayes.datamining.datamanipulation.Utils;

public abstract class DistributionClassifier
extends Classifier {
    protected static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.datamining.resources.ClassifiersResource");
    protected float[] originalDistribution;
    private int[] classValues;
    private float[] probabilities;
    public static final int NORMAL_CLASSIFICATION = 0;
    public static final int RELATIVE_FREQUENCY_CLASSIFICATION = 1;
    public static final int ABSOLUTE_FREQUENCY_CLASSIFICATION = 2;
    public static final int BINARY_CLASSIFICATION = 3;
    private int classificationType = 0;
    private int interestingClass;
    private double threshold;

    public abstract float[] distributionForInstance(Instance var1) throws Exception;

    public float[] getOriginalDistribution() {
        return this.originalDistribution;
    }

    public int classifyInstance(Instance instance) throws Exception {
        float[] dist = this.distributionForInstance(instance);
        if (dist == null) {
            throw new Exception(resource.getString("nullPrediction"));
        }
        switch (this.classificationType) {
            case 0: {
                return Utils.maxIndex(dist);
            }
            case 1: {
                int maxIndex = -1;
                float max = Float.MIN_VALUE;
                int i = 0;
                while (i < dist.length) {
                    float aux = dist[i] / this.originalDistribution[i];
                    if (aux > max) {
                        max = aux;
                        maxIndex = i;
                    }
                    ++i;
                }
                return maxIndex;
            }
            case 2: {
                int j = 0;
                while (j < this.classValues.length) {
                    int actualValue = this.classValues[j];
                    if (dist[actualValue] >= this.probabilities[j]) {
                        return actualValue;
                    }
                    ++j;
                }
                return 0;
            }
        }
        throw new Exception("Classification type not known");
    }

    public int classifyInstance(float[] dist) throws Exception {
        if (dist == null) {
            throw new Exception(resource.getString("nullPrediction"));
        }
        switch (this.classificationType) {
            case 0: {
                return Utils.maxIndex(dist);
            }
            case 1: {
                int maxIndex = -1;
                float max = Float.MIN_VALUE;
                int i = 0;
                while (i < dist.length) {
                    float aux = dist[i] / this.originalDistribution[i];
                    if (aux > max) {
                        max = aux;
                        maxIndex = i;
                    }
                    ++i;
                }
                return maxIndex;
            }
            case 2: {
                int j = 0;
                while (j < this.classValues.length) {
                    int actualValue = this.classValues[j];
                    if (dist[actualValue] >= this.probabilities[j]) {
                        return actualValue;
                    }
                    ++j;
                }
                return 0;
            }
            case 3: {
                int i = 0;
                while (i < dist.length) {
                    dist[i] = dist[i] / this.originalDistribution[i];
                    ++i;
                }
                float prob = dist[this.interestingClass] / dist[1 - this.interestingClass];
                if ((double)prob >= this.threshold) {
                    return this.interestingClass;
                }
                return 1 - this.interestingClass;
            }
        }
        throw new Exception("Classification type not known");
    }

    public void setNormalClassification() {
        this.classificationType = 0;
    }

    public void setRelativeClassification() {
        this.classificationType = 1;
    }

    public void setAbsoluteClassification(int[] classValues, float[] probabilities) {
        this.classificationType = 2;
        this.classValues = classValues;
        this.probabilities = probabilities;
    }

    public void setOriginalDistribution(float[] originalDistribution) {
        this.originalDistribution = originalDistribution;
    }

    public void setInterestingClass(int interestingClass) {
        this.interestingClass = interestingClass;
    }

    public void setThreshold(float threshold) {
        this.threshold = threshold;
    }

    public void setBinaryClassification() {
        this.classificationType = 3;
    }
}

