/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.classifiers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import unbbayes.datamining.classifiers.DistributionClassifier;
import unbbayes.datamining.classifiers.cnmentities.Combination;
import unbbayes.datamining.classifiers.cnmentities.OutputNeuron;
import unbbayes.datamining.datamanipulation.Attribute;
import unbbayes.datamining.datamanipulation.Instance;
import unbbayes.datamining.datamanipulation.InstanceSet;

public class CombinatorialNeuralModel
extends DistributionClassifier
implements Serializable {
    private static final long serialVersionUID = 0L;
    private HashMap<String, Combination> model = new HashMap();
    private Attribute[] attributeVector;
    private int classIndex;
    private int support;
    private int confidence;
    private int maxOrder;
    private transient InstanceSet instanceSet;

    public CombinatorialNeuralModel(int maxOrder) {
        this.maxOrder = maxOrder;
    }

    public void buildClassifier(InstanceSet instanceSet) throws Exception {
        this.instanceSet = instanceSet;
        Enumeration instanceEnum = instanceSet.enumerateInstances();
        int attributeNum = instanceSet.numAttributes();
        int numOfInstances = instanceSet.numWeightedInstances();
        this.attributeVector = instanceSet.getAttributes();
        this.classIndex = instanceSet.getClassIndex();
        while (instanceEnum.hasMoreElements()) {
            Instance instance = (Instance)instanceEnum.nextElement();
            this.createCombinations(instance, attributeNum, this.classIndex);
        }
        this.punishment(numOfInstances);
    }

    private void createCombinations(Instance instance, int attributeNum, int classIndex) {
        int missingAttNum = 0;
        int att = 0;
        while (att < attributeNum) {
            if (instance.isMissing(att)) {
                ++missingAttNum;
            }
            ++att;
        }
        int evidenceNum = attributeNum - missingAttNum - 1;
        if (evidenceNum < this.maxOrder) {
            this.maxOrder = evidenceNum;
        }
        String[] inputKeys = new String[evidenceNum];
        int keyIndex = 0;
        int att2 = 0;
        while (att2 < attributeNum) {
            if (!instance.isMissing(att2) && att2 != classIndex) {
                inputKeys[keyIndex] = this.generateInputKey(att2, instance.getValue(att2));
                ++keyIndex;
            }
            ++att2;
        }
        String[] combinationsKeys = this.makeCombinations(inputKeys);
        int combinationsSize = combinationsKeys.length;
        int i = 0;
        while (i < combinationsSize) {
            this.addCombination(combinationsKeys[i], instance.getClassValue(), (int)instance.getWeight());
            ++i;
        }
    }

    private void addCombination(String key, int classValue, int weight) {
        if (!this.model.containsKey(key)) {
            OutputNeuron[] outputArray = new OutputNeuron[this.instanceSet.getClassAttribute().numValues()];
            int i = 0;
            while (i < outputArray.length) {
                outputArray[i] = null;
                ++i;
            }
            outputArray[classValue] = new OutputNeuron(weight);
            Combination combination = new Combination(key, outputArray);
            this.model.put(key, combination);
        } else {
            Combination combination = this.model.get(key);
            combination.increaseAccumulator(classValue, weight);
        }
    }

    private String generateCombKey(String[] inputKeys) {
        int inputSize = inputKeys.length;
        String combKey = new String();
        int i = 0;
        while (i < inputSize) {
            combKey = String.valueOf(combKey) + inputKeys[i] + " ";
            ++i;
        }
        return combKey;
    }

    private String generateInputKey(int attribute, float value) {
        return new String(String.valueOf(attribute) + " " + value);
    }

    private String[] makeCombinations(String[] inputKeys) {
        int combArraySize;
        ArrayList<String[]> combinations = new ArrayList<String[]>();
        int inputKeysNum = inputKeys.length;
        int inputNum = 0;
        while (inputNum < inputKeysNum) {
            String[] keysArray;
            combArraySize = combinations.size();
            int j = 0;
            while (j < combArraySize) {
                String[] tempArray = (String[])combinations.get(j);
                int tempSize = tempArray.length;
                if (tempSize < this.maxOrder) {
                    keysArray = new String[tempSize + 1];
                    keysArray[tempSize] = inputKeys[inputNum];
                    System.arraycopy(tempArray, 0, keysArray, 0, tempSize);
                    combinations.add(keysArray);
                }
                ++j;
            }
            keysArray = new String[]{inputKeys[inputNum]};
            combinations.add(keysArray);
            ++inputNum;
        }
        combArraySize = combinations.size();
        String[] combinationsArray = new String[combArraySize];
        int i = 0;
        while (i < combArraySize) {
            combinationsArray[i] = this.generateCombKey((String[])combinations.get(i));
            ++i;
        }
        return combinationsArray;
    }

    private void punishment(int numOfInstances) {
        for (Combination tempCombination : this.model.values()) {
            tempCombination.punish(numOfInstances);
        }
    }

    public void prunning(int threshold) {
        Iterator<Combination> iterator = this.model.values().iterator();
        ArrayList<String> keysArray = new ArrayList<String>();
        while (iterator.hasNext()) {
            Combination tempCombination = iterator.next();
            tempCombination.prunning(threshold);
            if (!tempCombination.isNull()) continue;
            keysArray.add(tempCombination.getKey());
        }
        int arraySize = keysArray.size();
        int i = 0;
        while (i < arraySize) {
            this.model.remove((String)keysArray.get(i));
            ++i;
        }
    }

    public void prunning(int minSupport, int minConfidence) {
        Iterator<Combination> iterator = this.model.values().iterator();
        ArrayList<String> keysArray = new ArrayList<String>();
        while (iterator.hasNext()) {
            Combination tempCombination = iterator.next();
            tempCombination.prunning(minSupport, minConfidence);
            if (!tempCombination.isNull()) continue;
            keysArray.add(tempCombination.getKey());
        }
        int arraySize = keysArray.size();
        int i = 0;
        while (i < arraySize) {
            this.model.remove((String)keysArray.get(i));
            ++i;
        }
    }

    public Combination[] inference(Instance instance) {
        int numAtt = this.attributeVector.length;
        Combination[] combArray = new Combination[this.attributeVector[this.classIndex].numValues()];
        int missingAttNum = 0;
        int att = 0;
        while (att < numAtt) {
            if (instance.isMissing(att)) {
                ++missingAttNum;
            }
            ++att;
        }
        String[] instanceKeys = new String[numAtt - missingAttNum - 1];
        int keyIndex = 0;
        int att2 = 0;
        while (att2 < numAtt) {
            if (att2 != this.classIndex && !instance.isMissing(att2)) {
                float value = instance.getValue(att2);
                instanceKeys[keyIndex] = this.generateInputKey(att2, value);
                ++keyIndex;
            }
            ++att2;
        }
        String[] combKeys = this.makeCombinations(instanceKeys);
        int i = 0;
        while (i < combKeys.length) {
            if (this.model.containsKey(combKeys[i])) {
                Combination tempCombination = this.model.get(combKeys[i]);
                OutputNeuron[] tempOutput = tempCombination.getOutputArray();
                int j = 0;
                while (j < tempOutput.length) {
                    if (combArray[j] == null || combArray[j].getOutputNeuron(j) == null) {
                        combArray[j] = tempCombination;
                    } else if (tempOutput[j] != null && combArray[j].getOutputNeuron(j).getNetWeight() < tempCombination.getOutputNeuron(j).getNetWeight()) {
                        combArray[j] = tempCombination;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < combArray.length) {
            if (combArray[i] != null && combArray[i].getOutputNeuron(i) == null) {
                combArray[i] = null;
            }
            ++i;
        }
        return combArray;
    }

    public float[] distributionForInstance(Instance instance) throws Exception {
        float[] distribution = null;
        Combination[] outputArray = this.inference(instance);
        distribution = new float[outputArray.length];
        int i = 0;
        while (i < distribution.length) {
            distribution[i] = outputArray[i] != null ? (float)outputArray[i].getOutputNeuron(i).getNetWeight() : 0.0f;
            ++i;
        }
        return distribution;
    }

    public Attribute[] getAttributeVector() {
        return this.attributeVector;
    }

    public int getClassIndex() {
        return this.classIndex;
    }

    public int getConfidence() {
        return this.confidence;
    }

    public int getSupport() {
        return this.support;
    }

    public Iterator getModel() {
        return this.model.values().iterator();
    }
}

