/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.controller;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Pageable;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import unbbayes.controller.PrintComponent;

public class PrintPreviewer
extends JPanel {
    private static final long serialVersionUID = 0L;
    protected Pageable pageable;
    protected PrintComponent printComponent;
    protected int pageIndex;
    protected JScrollPane scrollPane;
    protected JButton previousButton;
    protected JButton nextButton;
    protected JButton sizeButton;
    protected JTextField scaleText;
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.controller.resources.ControllerResources");

    public PrintPreviewer(Pageable p, int page) {
        this.pageable = p;
        this.pageIndex = page;
        this.printComponent = new PrintComponent(null, null);
        this.printComponent.setBorder(BorderFactory.createBevelBorder(0));
        this.buildLayout();
        this.displayPage(this.pageIndex);
    }

    protected void buildLayout() {
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(1, 10, 10));
        panel.add(this.printComponent);
        this.scrollPane = new JScrollPane(panel);
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.getBottomPanel(), "South");
        this.addListeners();
    }

    protected JPanel getBottomPanel() {
        JPanel outer = new JPanel();
        outer.setLayout(new FlowLayout(1, 10, 0));
        JPanel inner = new JPanel();
        inner.setLayout(new GridLayout(1, 2, 10, 0));
        this.previousButton = new JButton(resource.getString("previewButtonLabel"));
        inner.add(this.previousButton);
        this.nextButton = new JButton(resource.getString("nextButtonLabel"));
        inner.add(this.nextButton);
        outer.add(inner);
        this.scaleText = new JTextField(3);
        outer.add(this.scaleText);
        this.sizeButton = new JButton(resource.getString("fitToPageButtonLabel"));
        outer.add(this.sizeButton);
        return outer;
    }

    protected void addListeners() {
        this.previousButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PrintPreviewer.this.displayPage(PrintPreviewer.this.pageIndex - 1);
            }
        });
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PrintPreviewer.this.displayPage(PrintPreviewer.this.pageIndex + 1);
            }
        });
        this.sizeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PrintPreviewer.this.sizeToFit();
            }
        });
        this.scaleText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    int scale = Integer.parseInt(PrintPreviewer.this.scaleText.getText());
                    PrintPreviewer.this.printComponent.setScaleFactor(scale);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
    }

    protected void displayPage(int index) {
        this.pageIndex = index;
        this.printComponent.setPrintable(this.pageable.getPrintable(this.pageIndex));
        this.printComponent.setPageFormat(this.pageable.getPageFormat(this.pageIndex));
        this.printComponent.setDisplayPage(index);
        this.previousButton.setEnabled(this.pageIndex > 0);
        this.nextButton.setEnabled(this.pageIndex < this.pageable.getNumberOfPages() - 1);
        this.repaint();
    }

    protected void sizeToFit() {
        Dimension compSize = this.printComponent.getSizeWithScale(100.0);
        Dimension viewSize = this.scrollPane.getSize();
        int scaleX = (viewSize.width - 25) * 100 / compSize.width;
        int scaleY = (viewSize.height - 25) * 100 / compSize.height;
        int newScaleFactor = Math.min(scaleX, scaleY);
        this.printComponent.setScaleFactor(newScaleFactor);
        this.scaleText.setText(Integer.toString(newScaleFactor));
        this.repaint();
    }
}

