/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.controller;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JPanel;

public class PrintComponent
extends JPanel {
    private static final long serialVersionUID = 0L;
    protected Printable printable;
    protected PageFormat pageFormat;
    protected int displayPage;
    protected double scaleFactor;

    public PrintComponent(Printable p, PageFormat pf) {
        this.setPrintable(p);
        this.setPageFormat(pf);
        this.setDisplayPage(0);
        this.setScaleFactor(100.0);
        this.setBackground(Color.white);
    }

    public void setPrintable(Printable p) {
        this.printable = p;
        this.revalidate();
    }

    public void setPageFormat(PageFormat pf) {
        this.pageFormat = pf;
        this.revalidate();
    }

    public void setDisplayPage(int page) {
        this.displayPage = page;
        this.revalidate();
    }

    public void setScaleFactor(double scale) {
        this.scaleFactor = scale;
        this.revalidate();
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public Dimension getSizeWithScale(double scale) {
        Insets insets = this.getInsets();
        int width = (int)(this.pageFormat.getWidth() * scale / 100.0) + insets.left + insets.right;
        int height = (int)(this.pageFormat.getHeight() * scale / 100.0) + insets.top + insets.bottom;
        return new Dimension(width, height);
    }

    public Dimension getPreferredSize() {
        return this.getSizeWithScale(this.scaleFactor);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        Rectangle clipRect = g2.getClipBounds();
        AffineTransform at = g2.getTransform();
        int x = (int)(this.pageFormat.getImageableX() * this.scaleFactor / 100.0);
        int y = (int)(this.pageFormat.getImageableY() * this.scaleFactor / 100.0);
        int w = (int)(this.pageFormat.getImageableWidth() * this.scaleFactor / 100.0);
        int h = (int)(this.pageFormat.getImageableHeight() * this.scaleFactor / 100.0);
        g2.clipRect(x, y, w, h);
        g2.scale(this.scaleFactor / 100.0, this.scaleFactor / 100.0);
        try {
            this.printable.print(g, this.pageFormat, this.displayPage);
        }
        catch (PrinterException printerException) {
            // empty catch block
        }
        g2.setTransform(at);
        g2.setClip(clipRect);
    }
}

