/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.controller;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import org.shetline.io.GIFOutputStream;
import unbbayes.controller.FileController;
import unbbayes.controller.IconController;
import unbbayes.controller.MEBNController;
import unbbayes.controller.PrintMonitor;
import unbbayes.controller.PrintNet;
import unbbayes.controller.PrintPreviewer;
import unbbayes.controller.PrintTable;
import unbbayes.controller.PrintText;
import unbbayes.controller.SENController;
import unbbayes.evaluation.controller.EvaluationController;
import unbbayes.gui.FileIcon;
import unbbayes.gui.NetworkWindow;
import unbbayes.gui.SimpleFileFilter;
import unbbayes.prs.Edge;
import unbbayes.prs.Graph;
import unbbayes.prs.Network;
import unbbayes.prs.Node;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.prs.bn.SingleEntityNetwork;
import unbbayes.prs.hybridbn.ContinuousNode;
import unbbayes.prs.mebn.MultiEntityBayesianNetwork;
import unbbayes.prs.mebn.exception.CycleFoundException;
import unbbayes.prs.mebn.exception.MEBNConstructionException;
import unbbayes.prs.mebn.exception.MFragDoesNotExistException;
import unbbayes.prs.mebn.ssbn.AbstractSSBNGenerator;

public class NetworkController
implements KeyListener {
    private NetworkWindow screen;
    private SingleEntityNetwork singleEntityNetwork;
    private MultiEntityBayesianNetwork multiEntityBayesianNetwork;
    private SENController senController;
    private MEBNController mebnController;
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.controller.resources.ControllerResources");

    public SENController.InferenceAlgorithmEnum getInferenceAlgorithm() {
        if (this.senController != null) {
            return this.senController.getInferenceAlgorithm();
        }
        return null;
    }

    public void setInferenceAlgorithm(SENController.InferenceAlgorithmEnum inferenceAlgorithm) {
        if (this.senController != null) {
            this.senController.setInferenceAlgorithm(inferenceAlgorithm);
        }
    }

    public NetworkController(MultiEntityBayesianNetwork multiEntityBayesianNetwork, NetworkWindow screen) {
        this.multiEntityBayesianNetwork = multiEntityBayesianNetwork;
        this.screen = screen;
        this.mebnController = new MEBNController(multiEntityBayesianNetwork, screen);
    }

    public void insertDomainMFrag() {
        if (this.mebnController != null) {
            try {
                this.mebnController.insertDomainMFrag();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void insertResidentNode(double x, double y) throws MFragDoesNotExistException {
        if (this.mebnController != null) {
            this.mebnController.insertDomainResidentNode(x, y);
        }
    }

    public void insertInputNode(double x, double y) throws MFragDoesNotExistException {
        if (this.mebnController != null) {
            this.mebnController.insertGenerativeInputNode(x, y);
        }
    }

    public void insertContextNode(double x, double y) throws MFragDoesNotExistException {
        if (this.mebnController != null) {
            this.mebnController.insertContextNode(x, y);
        }
    }

    public MEBNController getMebnController() {
        return this.mebnController;
    }

    public void setResetButtonActive() {
        if (this.mebnController != null) {
            this.mebnController.setResetButtonActive();
        }
    }

    public NetworkController(SingleEntityNetwork singleEntityNetwork, NetworkWindow screen) {
        this.singleEntityNetwork = singleEntityNetwork;
        this.screen = screen;
        this.senController = new SENController(singleEntityNetwork, screen);
    }

    public SENController getSENController() {
        return this.senController;
    }

    public SingleEntityNetwork getSingleEntityNetwork() {
        return this.singleEntityNetwork;
    }

    public Network getNetwork() {
        if (this.singleEntityNetwork != null) {
            return this.singleEntityNetwork;
        }
        if (this.multiEntityBayesianNetwork != null) {
            return this.multiEntityBayesianNetwork;
        }
        return null;
    }

    public Graph getGraph() {
        if (this.singleEntityNetwork != null) {
            return this.singleEntityNetwork;
        }
        if (this.multiEntityBayesianNetwork != null) {
            if (!this.mebnController.isShowSSBNGraph()) {
                if (this.multiEntityBayesianNetwork.getCurrentMFrag() != null) {
                    return this.multiEntityBayesianNetwork.getCurrentMFrag();
                }
                return this.multiEntityBayesianNetwork;
            }
            return this.mebnController.getSpecificSituationBayesianNetwork();
        }
        return null;
    }

    public void initialize() {
        if (this.senController != null) {
            this.senController.initialize();
        } else if (this.mebnController != null) {
            this.mebnController.initialize();
        }
    }

    public void createTable(Node node) {
        if (node.getType() == 5) {
            this.createContinuousDistribution((ContinuousNode)node);
        } else {
            this.createDiscreteTable(node);
        }
    }

    public void createContinuousDistribution(ContinuousNode node) {
        if (this.senController != null) {
            this.senController.createContinuousDistribution(node);
        }
    }

    public void createDiscreteTable(Node node) {
        if (this.senController != null) {
            this.senController.createDiscreteTable(node);
        }
    }

    public JTable makeTable(Node node) {
        if (this.senController != null) {
            return this.senController.makeTable(node);
        }
        return null;
    }

    public void propagate() {
        if (this.senController != null) {
            this.senController.propagate();
        } else if (this.mebnController != null) {
            this.mebnController.propagate();
        }
    }

    public boolean compileNetwork() {
        if (this.senController != null) {
            return this.senController.compileNetwork();
        }
        return false;
    }

    public void evaluateNetwork() {
        if (this.singleEntityNetwork != null && this.singleEntityNetwork instanceof ProbabilisticNetwork) {
            EvaluationController evaluationController = new EvaluationController((ProbabilisticNetwork)this.singleEntityNetwork);
            this.screen.changeToPNEvaluationPane(evaluationController.getView());
        } else {
            JOptionPane.showMessageDialog(this.screen, "Evaluation can only be done in probabilistic networks.", "Evaluation Error", 0);
        }
    }

    public void insertContinuousNode(double x, double y) {
        if (this.senController != null) {
            this.senController.insertContinuousNode(x, y);
        }
    }

    public void insertProbabilisticNode(double x, double y) {
        if (this.senController != null) {
            this.senController.insertProbabilisticNode(x, y);
        }
    }

    public void insertDecisionNode(double x, double y) {
        if (this.senController != null) {
            this.senController.insertDecisionNode(x, y);
        }
    }

    public void insertUtilityNode(double x, double y) {
        if (this.senController != null) {
            this.senController.insertUtilityNode(x, y);
        }
    }

    public void showExplanationProperties(ProbabilisticNode node) {
        if (this.senController != null) {
            this.senController.showExplanationProperties(node);
        }
    }

    public void insertEdge(Edge edge) throws MEBNConstructionException, CycleFoundException, Exception {
        if (this.senController != null) {
            this.senController.insertEdge(edge);
        } else if (this.mebnController != null) {
            this.mebnController.insertEdge(edge);
        }
    }

    public void insertState(Node node) {
        if (this.senController != null) {
            this.senController.insertState(node);
        }
    }

    public void removeState(Node node) {
        if (this.senController != null) {
            this.senController.removeState(node);
        }
    }

    private void deleteSelected(Object selected) {
        if (this.senController != null) {
            this.senController.deleteSelected(selected);
        } else if (this.mebnController != null) {
            this.mebnController.deleteSelected(selected);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 127) {
            Object selecionado = this.screen.getGraphPane().getSelected();
            this.deleteSelected(selecionado);
            int i = 0;
            while (i < this.screen.getGraphPane().getSelectedGroup().size()) {
                selecionado = this.screen.getGraphPane().getSelectedGroup().get(i);
                this.deleteSelected(selecionado);
                ++i;
            }
        }
        this.screen.getGraphPane().update();
    }

    public void keyReleased(KeyEvent e) {
    }

    public NetworkWindow getScreen() {
        return this.screen;
    }

    private BufferedImage graphicsToImage(Component component, Rectangle r) {
        BufferedImage buffImg = new BufferedImage(component.getWidth(), component.getHeight(), 13);
        component.setVisible(true);
        Graphics2D g = buffImg.createGraphics();
        component.paint(g);
        g.dispose();
        return buffImg;
    }

    public void saveNetImage() {
        String[] gif = new String[]{"GIF"};
        JFileChooser chooser = new JFileChooser(FileController.getInstance().getCurrentDirectory());
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileView(new FileIcon(this.screen));
        chooser.addChoosableFileFilter(new SimpleFileFilter(gif, resource.getString("imageFileFilter")));
        int opcao = chooser.showSaveDialog(this.screen);
        if (opcao == 0) {
            try {
                GIFOutputStream out = new GIFOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(String.valueOf(chooser.getSelectedFile().getPath()) + ".gif")));
                Rectangle r = this.calculateNetRectangle();
                out.write((Image)this.graphicsToImage(this.screen.getGraphPane().getGraphViewport(), r));
                out.flush();
                out.close();
                FileController.getInstance().setCurrentDirectory(chooser.getCurrentDirectory());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void saveTableImage() {
        String[] gif = new String[]{"GIF"};
        JFileChooser chooser = new JFileChooser(FileController.getInstance().getCurrentDirectory());
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileView(new FileIcon(this.screen));
        chooser.addChoosableFileFilter(new SimpleFileFilter(gif, resource.getString("imageFileFilter")));
        int opcao = chooser.showSaveDialog(this.screen);
        if (opcao == 0) {
            try {
                GIFOutputStream out = new GIFOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(String.valueOf(chooser.getSelectedFile().getPath()) + ".gif")));
                out.write((Image)this.graphicsToImage(this.screen.getTable(), null));
                out.flush();
                out.close();
                FileController.getInstance().setCurrentDirectory(chooser.getCurrentDirectory());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void showLog() {
        this.screen.setCursor(new Cursor(3));
        final JTextArea texto = new JTextArea();
        texto.setEditable(false);
        if (this.singleEntityNetwork != null) {
            texto.setText(this.singleEntityNetwork.getLog());
        } else {
            texto.setText(AbstractSSBNGenerator.logManager.getLog());
        }
        texto.moveCaretPosition(0);
        texto.setSelectionEnd(0);
        texto.setSize(texto.getPreferredSize());
        texto.append("\n");
        final JDialog dialog = new JDialog();
        JScrollPane jspTexto = new JScrollPane(texto);
        jspTexto.setPreferredSize(new Dimension(450, 400));
        IconController iconController = IconController.getInstance();
        JPanel panel = new JPanel(new BorderLayout());
        JButton botaoImprimir = new JButton(iconController.getPrintIcon());
        botaoImprimir.setToolTipText(resource.getString("printLogToolTip"));
        JButton botaoVisualizar = new JButton(iconController.getVisualizeIcon());
        botaoVisualizar.setToolTipText(resource.getString("previewLogToolTip"));
        botaoImprimir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                NetworkController.this.printLog(texto);
            }
        });
        botaoVisualizar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                NetworkController.this.previewPrintLog(texto, dialog);
            }
        });
        panel.add((Component)jspTexto, "Center");
        JPanel topPane = new JPanel(new FlowLayout(1));
        topPane.add(botaoImprimir);
        topPane.add(botaoVisualizar);
        panel.add((Component)topPane, "North");
        JPanel bottomPane = new JPanel(new FlowLayout(1));
        JButton botaoOK = new JButton(resource.getString("closeButtonLabel"));
        botaoOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                dialog.dispose();
            }
        });
        bottomPane.add(botaoOK);
        panel.add((Component)bottomPane, "South");
        dialog.getContentPane().add(panel);
        dialog.setTitle(resource.getString("logDialogTitle"));
        dialog.setLocationRelativeTo(null);
        dialog.pack();
        dialog.setVisible(true);
        this.screen.setCursor(new Cursor(0));
    }

    public void openWarningDialog() {
        if (this.multiEntityBayesianNetwork != null) {
            this.mebnController.openWarningDialog();
        }
    }

    public void closeWarningDialog() {
        if (this.multiEntityBayesianNetwork != null) {
            this.mebnController.closeWarningDialog();
        }
    }

    public void previewPrintLog(final JTextArea texto, final JDialog dialog) {
        this.screen.setCursor(new Cursor(3));
        Thread t = new Thread(new Runnable(){

            public void run() {
                PrintText it = new PrintText(texto, new PageFormat());
                PrintPreviewer pp = new PrintPreviewer(it, 0);
                JDialog dlg = new JDialog((Dialog)dialog, resource.getString("previewLogToolTip"));
                dlg.getContentPane().add(pp);
                dlg.setSize(640, 480);
                dlg.setVisible(true);
            }
        });
        t.start();
        this.screen.setCursor(new Cursor(0));
    }

    public void previewPrintTable() {
        this.screen.setCursor(new Cursor(3));
        Thread t = new Thread(new Runnable(){

            public void run() {
                ArrayList<JTable> tabelas = new ArrayList<JTable>();
                ArrayList<Object> donos = new ArrayList<Object>();
                List temp = NetworkController.this.screen.getGraphPane().getSelectedGroup();
                if (temp.size() == 0) {
                    tabelas.add(NetworkController.this.screen.getTable());
                    donos.add(NetworkController.this.screen.getTableOwner());
                } else {
                    int i = 0;
                    while (i < temp.size()) {
                        if (temp.get(i) instanceof Node) {
                            donos.add(((Node)temp.get(i)).toString());
                            tabelas.add(NetworkController.this.makeTable((Node)temp.get(i)));
                        }
                        ++i;
                    }
                }
                PrintTable tp = new PrintTable(tabelas, donos, new PageFormat());
                PrintPreviewer pp = new PrintPreviewer(tp, 0);
                JDialog dlg = new JDialog();
                dlg.getContentPane().add(pp);
                dlg.setSize(400, 300);
                dlg.setVisible(true);
            }
        });
        t.start();
        this.screen.setCursor(new Cursor(0));
    }

    public void previewPrintNet(final JComponent rede, final Rectangle retangulo) {
        this.screen.setCursor(new Cursor(3));
        Thread t = new Thread(new Runnable(){

            public void run() {
                String rotulo = JOptionPane.showInputDialog(NetworkController.this.screen, resource.getString("askTitle"), resource.getString("informationText"), 1);
                if (rotulo == null) {
                    rotulo = "";
                }
                PrintNet it = new PrintNet(rotulo, rede, retangulo, new PageFormat());
                PrintPreviewer pp = new PrintPreviewer(it, 0);
                JDialog dlg = new JDialog();
                dlg.getContentPane().add(pp);
                dlg.setSize(640, 480);
                dlg.setVisible(true);
            }
        });
        t.start();
        this.screen.setCursor(new Cursor(0));
    }

    public void printNet(final JComponent network, final Rectangle rectangle) {
        this.screen.setCursor(new Cursor(3));
        Thread t = new Thread(new Runnable(){

            public void run() {
                String rotulo = JOptionPane.showInputDialog(NetworkController.this.screen, resource.getString("askTitle"), resource.getString("informationText"), 1);
                if (rotulo == null) {
                    rotulo = "";
                }
                PrintNet it = new PrintNet(rotulo, network, rectangle, new PageFormat());
                PrintMonitor pm = new PrintMonitor(it);
                try {
                    pm.performPrint(true);
                }
                catch (PrinterException pe) {
                    JOptionPane.showMessageDialog(NetworkController.this.screen, String.valueOf(resource.getString("printException")) + pe.getMessage());
                }
            }
        });
        t.start();
        this.screen.setCursor(new Cursor(0));
    }

    public void printTable() {
        this.screen.setCursor(new Cursor(3));
        Thread t = new Thread(new Runnable(){

            public void run() {
                ArrayList<JTable> tabelas = new ArrayList<JTable>();
                ArrayList<Object> donos = new ArrayList<Object>();
                List temp = NetworkController.this.screen.getGraphPane().getSelectedGroup();
                if (temp.size() == 0) {
                    tabelas.add(NetworkController.this.screen.getTable());
                    donos.add(NetworkController.this.screen.getTableOwner());
                } else {
                    int i = 0;
                    while (i < temp.size()) {
                        if (temp.get(i) instanceof Node) {
                            donos.add(((Node)temp.get(i)).toString());
                            tabelas.add(NetworkController.this.makeTable((Node)temp.get(i)));
                        }
                        ++i;
                    }
                }
                PrintTable impressora = new PrintTable(tabelas, donos, new PageFormat());
                PrintMonitor pm = new PrintMonitor(impressora);
                try {
                    pm.performPrint(true);
                }
                catch (PrinterException pe) {
                    JOptionPane.showMessageDialog(NetworkController.this.screen, String.valueOf(resource.getString("printException")) + pe.getMessage());
                }
            }
        });
        t.start();
        this.screen.setCursor(new Cursor(0));
    }

    private void printLog(final JTextArea textArea) {
        Thread t = new Thread(new Runnable(){

            public void run() {
                PrintText it = new PrintText(textArea, new PageFormat());
                PrintMonitor pm = new PrintMonitor(it);
                try {
                    pm.performPrint(true);
                }
                catch (PrinterException pe) {
                    JOptionPane.showMessageDialog(NetworkController.this.screen, String.valueOf(resource.getString("printException")) + pe.getMessage());
                }
            }
        });
        t.start();
    }

    public Rectangle calculateNetRectangle() {
        int i;
        ArrayList<Node> nos;
        List vetorAux = this.screen.getGraphPane().getSelectedGroup();
        if (vetorAux.size() == 0) {
            nos = new ArrayList<Node>();
            i = 0;
            while (i < this.singleEntityNetwork.getNodeCount()) {
                nos.add(i, this.singleEntityNetwork.getNodeAt(i));
                ++i;
            }
        } else {
            nos = new ArrayList();
            i = 0;
            while (i < vetorAux.size()) {
                if (vetorAux.get(i) instanceof Node) {
                    nos.add((Node)vetorAux.get(i));
                }
                ++i;
            }
        }
        int maiorX = 0;
        int menorX = Integer.MAX_VALUE;
        int maiorY = 0;
        int menorY = Integer.MAX_VALUE;
        int i2 = 0;
        while (i2 < nos.size()) {
            Node noAux = (Node)nos.get(i2);
            Point2D.Double pontoAux = noAux.getPosition();
            int xAux = (int)((Point2D)pontoAux).getX();
            int yAux = (int)((Point2D)pontoAux).getY();
            if (xAux > maiorX) {
                maiorX = xAux;
            }
            if (xAux < menorX) {
                menorX = xAux;
            }
            if (yAux > maiorY) {
                maiorY = yAux;
            }
            if (yAux < menorY) {
                menorY = yAux;
            }
            ++i2;
        }
        double raio = Node.getWidth() / 2;
        maiorX = (int)((double)maiorX + raio);
        maiorY = (int)((double)maiorY + raio);
        menorX = (int)((double)menorX - raio);
        menorY = (int)((double)menorY - raio);
        return new Rectangle(menorX, menorY, maiorX - menorX, maiorY - menorY);
    }

    public void selectNode(Node node) {
        if (this.multiEntityBayesianNetwork != null) {
            this.mebnController.selectNode(node);
            this.screen.getGraphPane().selectObject(node);
        }
    }

    public void unselectAll() {
        if (this.multiEntityBayesianNetwork != null) {
            this.mebnController.unselectNodes();
        }
    }
}

